/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataForBind;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ImageElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.util.DataUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;

public class ChartElement
extends ImageElement {
    private String chartType = "ChartType.CT_PIE.toString()";
    private String title = "";
    private boolean isSeriesBindToDS = true;
    private String seriesDS = "";
    private String seriesField = "";
    private String seriesFixedValue = "";
    private boolean isGroupsBindToDS = true;
    private String groupsDS = "";
    private String groupsField = "";
    private String groupsFixedValue = "";
    private boolean isValueBindToDS = true;
    private String valueDS = "";
    private boolean isValueBindAllField = true;
    private String valueField = "";
    private String valueFixedValue = "";

    public ChartElement(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.setImg(Icons.IMG_CHART_SAMPLE);
        this.eletype = 9;
    }

    @Override
    protected void reDrawImage() {
        if (!this.getStyleAttribute().isShrinkText()) {
            StyleAttributes sa = this.getStyleAttribute();
            sa.setShrinkText(true);
            this.setStyleAttribute(sa);
        }
        super.reDrawImage();
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        if (this.chartType == chartType) {
            return;
        }
        this.chartType = chartType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public ReportElement cloneMe() {
        ChartElement newChart = new ChartElement(this.name, 0, 0, this.width, this.height);
        newChart.chartType = this.chartType;
        newChart.title = this.title;
        newChart.isSeriesBindToDS = this.isSeriesBindToDS;
        newChart.seriesDS = this.seriesDS;
        newChart.seriesField = this.seriesField;
        newChart.seriesFixedValue = this.seriesFixedValue;
        newChart.isGroupsBindToDS = this.isGroupsBindToDS;
        newChart.groupsDS = this.groupsDS;
        newChart.groupsField = this.groupsField;
        newChart.groupsFixedValue = this.groupsFixedValue;
        newChart.isValueBindToDS = this.isValueBindToDS;
        newChart.valueDS = this.valueDS;
        newChart.isValueBindAllField = this.isValueBindAllField;
        newChart.valueField = this.valueField;
        newChart.valueFixedValue = this.valueFixedValue;
        this.copyBaseReportElement(newChart, this);
        return newChart;
    }

    public String getGroupsDS() {
        return this.groupsDS;
    }

    public String getGroupsField() {
        return this.groupsField;
    }

    public String getGroupsFixedValue() {
        return this.groupsFixedValue;
    }

    public boolean isGroupsBindToDS() {
        return this.isGroupsBindToDS;
    }

    public boolean isSeriesBindToDS() {
        return this.isSeriesBindToDS;
    }

    public boolean isValueBindAllField() {
        return this.isValueBindAllField;
    }

    public boolean isValueBindToDS() {
        return this.isValueBindToDS;
    }

    public String getSeriesDS() {
        return this.seriesDS;
    }

    public String getSeriesField() {
        return this.seriesField;
    }

    public String getSeriesFixedValue() {
        return this.seriesFixedValue;
    }

    public String getValueDS() {
        return this.valueDS;
    }

    public String getValueField() {
        return this.valueField;
    }

    public String getValueFixedValue() {
        return this.valueFixedValue;
    }

    public void setGroupsDS(String string) {
        this.groupsDS = string;
    }

    public void setGroupsField(String string) {
        this.groupsField = string;
    }

    public void setGroupsFixedValue(String string) {
        this.groupsFixedValue = string;
    }

    public void setGroupsBindToDS(boolean b) {
        this.isGroupsBindToDS = b;
    }

    public void setSeriesBindToDS(boolean b) {
        this.isSeriesBindToDS = b;
    }

    public void setValueBindAllField(boolean b) {
        this.isValueBindAllField = b;
    }

    public void setValueBindToDS(boolean b) {
        this.isValueBindToDS = b;
    }

    public void setSeriesDS(String string) {
        this.seriesDS = string;
    }

    public void setSeriesField(String string) {
        this.seriesField = string;
    }

    public void setSeriesFixedValue(String string) {
        this.seriesFixedValue = string;
    }

    public void setValueDS(String string) {
        this.valueDS = string;
    }

    public void setValueField(String string) {
        this.valueField = string;
    }

    public void setValueFixedValue(String string) {
        this.valueFixedValue = string;
    }

    public String makeSavingString(IDataForBind data) {
        this.translateValueField(data, true);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getChartType());
        sb.append("|");
        sb.append(this.transferTitle(this.getTitle()));
        sb.append("|");
        sb.append(this.getDSHead(this.isSeriesBindToDS()));
        if (this.isSeriesBindToDS()) {
            sb.append(this.getSeriesDS());
            if (!StringUtil.isEmptyString((String)this.getSeriesField())) {
                sb.append(":");
                sb.append(this.getSeriesField());
            }
        } else {
            sb.append(this.getSeriesFixedValue());
        }
        sb.append("|");
        sb.append(this.getDSHead(this.isGroupsBindToDS()));
        if (this.isGroupsBindToDS()) {
            sb.append(this.getGroupsDS());
            if (!StringUtil.isEmptyString((String)this.getGroupsField())) {
                sb.append(":");
                sb.append(this.getGroupsField());
            }
        } else {
            sb.append(this.getGroupsFixedValue());
        }
        sb.append("|");
        sb.append(this.getDSHead(this.isValueBindToDS()));
        if (this.isValueBindToDS()) {
            sb.append(this.getValueDS());
            if (!this.isValueBindAllField() && !StringUtil.isEmptyString((String)this.getValueField())) {
                sb.append(":");
                sb.append(this.getValueField());
            }
        } else {
            sb.append(this.transferValueFixedValue(this.getValueFixedValue()));
        }
        return sb.toString();
    }

    private String transferTitle(String title) {
        return title.replaceAll("\\|", ";#x7c;");
    }

    private String reTransferTitle(String title) {
        return title.replaceAll(";#x7c;", "\\|");
    }

    private String transferValueFixedValue(String value) {
        return value.replaceAll("\\n", ":");
    }

    private String reTransferValueFixedValue(String value) {
        return value.replaceAll(":", "\n");
    }

    private String getDSHead(boolean isBindToDS) {
        if (isBindToDS) {
            return "DV:";
        }
        return "CV:";
    }

    public void translateSavingString(IDataForBind data, String src) {
        String[] ss;
        if (src != null && src.length() > 0 && (ss = src.split("\\|")).length > 0) {
            this.setChartType(ss[0]);
            if (ss.length > 1) {
                this.setTitle(this.reTransferTitle(ss[1]));
                if (ss.length > 2) {
                    if (ss[2].startsWith("CV:")) {
                        this.setSeriesBindToDS(false);
                        this.setSeriesFixedValue(ss[2].substring(3));
                    } else if (ss[2].startsWith("DV:")) {
                        String[] series = ss[2].substring(3).split("\\:");
                        this.setSeriesBindToDS(true);
                        if (series.length > 0) {
                            this.setSeriesDS(series[0]);
                            if (series.length > 1) {
                                this.setSeriesField(series[1]);
                            }
                        }
                    }
                    if (ss.length > 3) {
                        if (ss[3].startsWith("CV:")) {
                            this.setGroupsBindToDS(false);
                            this.setGroupsFixedValue(ss[3].substring(3));
                        } else if (ss[3].startsWith("DV:")) {
                            String[] groups = ss[3].substring(3).split("\\:");
                            this.setGroupsBindToDS(true);
                            if (groups.length > 0) {
                                this.setGroupsDS(groups[0]);
                                if (groups.length > 1) {
                                    this.setGroupsField(groups[1]);
                                }
                            }
                        }
                        if (ss.length > 4) {
                            if (ss[4].startsWith("CV:")) {
                                this.setValueBindToDS(false);
                                String fv = this.reTransferValueFixedValue(ss[4].substring(3));
                                this.setValueFixedValue(fv);
                            } else if (ss[4].startsWith("DV:")) {
                                String[] values = ss[4].substring(3).split("\\:");
                                this.setValueBindToDS(true);
                                if (values.length > 0) {
                                    this.setValueDS(values[0]);
                                    if (values.length > 1) {
                                        this.setValueBindAllField(false);
                                        this.setValueField(values[1]);
                                    } else {
                                        this.setValueBindAllField(true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.translateValueField(data, false);
    }

    private void translateValueField(IDataForBind data, boolean isName2PrgID) {
        if (!this.isValueBindToDS() || this.isValueBindAllField()) {
            return;
        }
        MetaClass query = data.getData(this.getValueDS());
        if (query == null) {
            return;
        }
        String newFields = "";
        String[] fields = this.getValueField().split("\\,");
        for (int i = 0; i < fields.length; ++i) {
            MetaField column;
            if (isName2PrgID) {
                column = DataUtil.getColumnByAlias(query, fields[i]);
                if (column != null) {
                    fields[i] = column.getName();
                }
            } else {
                column = DataUtil.getColumnById(query, fields[i]);
                if (column != null) {
                    fields[i] = column.getAlias();
                }
            }
            newFields = newFields + (i > 0 ? "," : "");
            newFields = newFields + fields[i];
        }
        this.setValueField(newFields);
    }
}

