/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Group;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;

public class LoopArea
extends AbstractContainer {
    private float verticalSpacing = 0.0f;
    private float horizontalSpacing = 0.0f;
    private int maxLoopCount = -1;
    private int minLoopCount = 0;
    private LoopArea nextLoopArea = null;

    public LoopArea(String name, int top, int left, int width, int height) {
        super(name, top, left, width, height);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_DOT);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_DOT);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
        this.eletype = 11;
        this.setNextLoopArea(this);
    }

    public void setHorizontalSpacing(float horizontalSpaceing) {
        this.horizontalSpacing = horizontalSpaceing;
        this.firePropertyChange(null);
    }

    public float getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setVerticalSpacing(float verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
        this.firePropertyChange(null);
    }

    public float getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setMaxLoopCount(int maxloopcount) {
        this.maxLoopCount = maxloopcount;
        this.firePropertyChange(null);
    }

    public int getMaxLoopCount() {
        return this.maxLoopCount;
    }

    public void setMinLoopCount(int minloopcount) {
        this.minLoopCount = minloopcount;
        this.firePropertyChange(null);
    }

    public int getMinLoopCount() {
        return this.minLoopCount;
    }

    public boolean isCanAddElement(int reType) {
        if (this.allChildren.size() != 0) {
            return false;
        }
        return reType == 10 || reType == 12;
    }

    public String getNearDataSource() {
        IContainer parent = this.getParent();
        while (!(parent instanceof Page)) {
            if (parent instanceof Group) {
                if (!((Group)parent).getDataSource().equals("")) {
                    return ((Group)parent).getDataSource();
                }
            } else if (parent instanceof Table && !((Table)parent).getDataSource().equals("")) {
                return ((Table)parent).getDataSource();
            }
            parent = parent.getParent();
        }
        return ((Page)parent).getDataSource();
    }

    public LoopArea getNextLoopArea() {
        return this.nextLoopArea;
    }

    public void setNextLoopArea(LoopArea nextLoopArea) {
        this.nextLoopArea = nextLoopArea;
        this.firePropertyChange(null);
    }

    public ArrayList getUsedNextLoopArea() {
        ArrayList<ReportElement> array = new ArrayList<ReportElement>();
        IContainer parent = this.getParent();
        for (ReportElement re : parent.getChildren()) {
            if (!(re instanceof LoopArea)) continue;
            array.add(re);
        }
        Page thispage = this.getTopContainer();
        KDF kdf = thispage.getKDF();
        for (Page page : kdf.getPages()) {
            if (page == thispage) continue;
            array.addAll(page.getAllLoopArea());
        }
        return array;
    }

    @Override
    public ReportElement cloneMe() {
        LoopArea newReportElement = new LoopArea(this.name, 0, 0, this.width, this.height);
        newReportElement.maxLoopCount = this.maxLoopCount;
        newReportElement.minLoopCount = this.minLoopCount;
        newReportElement.nextLoopArea = this.nextLoopArea;
        newReportElement.horizontalSpacing = this.horizontalSpacing;
        newReportElement.verticalSpacing = this.verticalSpacing;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }
}

