/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.kdf.expr.RelationKey;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.Location;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.TableLocation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.PropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.PropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog.LocationPanel;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.bos.ctrl.kdf.util.render.BorderRender;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class ReportElement
implements IElement {
    static int id_gen = 1;
    protected String name;
    protected String aliasName;
    protected Point position;
    protected int width;
    protected int height;
    public Point posLom;
    protected int widthLom;
    protected int heightLom;
    protected Rectangle bounds;
    protected ShareStyleAttributes ssa = null;
    protected Style style = null;
    protected Location location = null;
    protected TableLocation tablocation = null;
    double zoom_factor = 1.0;
    private static Stroke solidStroke = null;
    private boolean isLoading = false;
    private DivideCharacter divideCharacter;
    private BorderRender borderRender = new BorderRender();
    protected IContainer container = null;
    private boolean isLocked = false;
    private String layer = "";
    private String preSteps = "";
    private String postSteps = "";
    private String holdPlace = "";
    private String visibility = "";
    private int priorityLevel = 0;
    protected Page topPage = null;
    protected int eletype = -1;
    protected EventListenerList listenerList = new EventListenerList();

    public void drawObject(Graphics2D g, double zoom_factor) {
        this.zoom_factor = zoom_factor;
        this.drawGraphicsElement(g, zoom_factor);
        this.drawBorder(g, zoom_factor);
    }

    public void drawGraphicsElement(Graphics2D g, double zoom_factor) {
        this.drawGraphicsElement(g, zoom_factor, 0);
    }

    public void drawGraphicsElement(Graphics2D g, double zoom_factor, int radius) {
        this.zoom_factor = zoom_factor;
        Rectangle rect = new Rectangle(this.getZoomedDim(this.position.x), this.getZoomedDim(this.position.y), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.paintInterior(g, rect);
    }

    protected void paintInterior(Graphics2D g, Rectangle rect) {
        if (this.style.getPattern() == Pattern.Solid) {
            g.setColor(this.style.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else if (this.style.getPattern() != Pattern.None) {
            Paint paint = this.style.getFillPaint();
            g.setPaint(paint);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void drawBorder(Graphics2D g, double zoom_factor) {
        this.zoom_factor = zoom_factor;
        Point topleft = new Point();
        topleft.x = this.getZoomedDim(this.position.x);
        topleft.y = this.getZoomedDim(this.position.y);
        Point bottomright = new Point();
        bottomright.x = topleft.x + this.getZoomedDim(this.width);
        bottomright.y = topleft.y + this.getZoomedDim(this.height);
        Styles.Position pos = Styles.Position.TOP;
        if (!LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(pos))) {
            g.setColor(this.style.getBorderColor(pos));
            g.setStroke(this.style.getStroke(pos));
            g.drawLine(topleft.x, topleft.y, bottomright.x, topleft.y);
        }
        if (!LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(pos = Styles.Position.LEFT))) {
            g.setColor(this.style.getBorderColor(pos));
            g.setStroke(this.style.getStroke(pos));
            g.drawLine(topleft.x, topleft.y, topleft.x, bottomright.y);
        }
        if (!LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(pos = Styles.Position.RIGHT))) {
            g.setColor(this.style.getBorderColor(pos));
            g.setStroke(this.style.getStroke(pos));
            g.drawLine(bottomright.x, topleft.y, bottomright.x, bottomright.y);
        }
        if (!LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(pos = Styles.Position.BOTTOM))) {
            g.setColor(this.style.getBorderColor(pos));
            g.setStroke(this.style.getStroke(pos));
            g.drawLine(topleft.x, bottomright.y, bottomright.x, bottomright.y);
        }
    }

    public Point getCorrespondTopPos() {
        Point retPT = new Point(0, 0);
        IContainer container = this.getParent();
        while (!(container instanceof Page)) {
            retPT.translate(container.getPosition().x, container.getPosition().y);
            container = container.getParent();
        }
        return retPT;
    }

    public Point getRelativePagePosition() {
        Point reRelativeTop = this.getCorrespondTopPos();
        return new Point(this.getPosition().x + reRelativeTop.x, this.getPosition().y + reRelativeTop.y);
    }

    public Point getCorrespondTopPosLom() {
        Point retPT = new Point(0, 0);
        IContainer container = this.getParent();
        while (!(container instanceof Page)) {
            retPT.translate(container.getPosLom().x, container.getPosLom().y);
            container = container.getParent();
        }
        return retPT;
    }

    public void drawCorona(Graphics2D g, double zoom_factor, int xOff, int yOff, boolean lastselected) {
        Color rectColor;
        this.zoom_factor = zoom_factor;
        Point pt = this.getCorrespondTopPos();
        int blockLength = 6;
        int xLeft = this.position.x - blockLength / 2 + (xOff += pt.x);
        int xMid = xLeft + this.width / 2;
        int xRight = xLeft + this.width;
        int yTop = this.position.y - blockLength / 2 + (yOff += pt.y);
        int yMid = yTop + this.height / 2;
        int yBottom = yTop + this.height;
        if (lastselected) {
            rectColor = this.isLocked ? Color.GRAY : Color.BLUE;
            g.setPaint(Color.WHITE);
        } else {
            if (this.isLocked) {
                g.setPaint(Color.GRAY);
            } else {
                g.setPaint(Color.BLUE);
            }
            rectColor = Color.WHITE;
        }
        g.fillRect(xLeft, yTop, blockLength, blockLength);
        g.fillRect(xMid, yTop, blockLength, blockLength);
        g.fillRect(xRight, yTop, blockLength, blockLength);
        g.fillRect(xLeft, yMid, blockLength, blockLength);
        g.fillRect(xRight, yMid, blockLength, blockLength);
        g.fillRect(xLeft, yBottom, blockLength, blockLength);
        g.fillRect(xMid, yBottom, blockLength, blockLength);
        g.fillRect(xRight, yBottom, blockLength, blockLength);
        g.setStroke(solidStroke);
        g.setColor(rectColor);
        if (lastselected && !this.isLocked) {
            g.drawLine(xLeft, yTop + blockLength / 2, xLeft + blockLength, yTop + blockLength / 2);
            g.drawLine(xLeft + blockLength / 2, yTop, xLeft + blockLength / 2, yTop + blockLength);
        }
        g.drawRect(xLeft, yTop, blockLength, blockLength);
        g.drawRect(xMid, yTop, blockLength, blockLength);
        g.drawRect(xRight, yTop, blockLength, blockLength);
        g.drawRect(xLeft, yMid, blockLength, blockLength);
        g.drawRect(xRight, yMid, blockLength, blockLength);
        g.drawRect(xLeft, yBottom, blockLength, blockLength);
        g.drawRect(xMid, yBottom, blockLength, blockLength);
        g.drawRect(xRight, yBottom, blockLength, blockLength);
    }

    public ReportElement(String name, int x, int y, int width, int height) {
        this.position = new Point(x, y);
        this.posLom = new Point((int)StyleUtil.pixelToLom((long)x), (int)StyleUtil.pixelToLom((long)y));
        this.name = name;
        this.bounds = new Rectangle(this.position.x, this.position.y, width, height);
        name = "element-" + id_gen;
        ++id_gen;
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
        sa.setPatternColor(Color.BLACK);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.LEFT, Color.BLACK);
        sa.setBorderColor(Styles.Position.RIGHT, Color.BLACK);
        sa.setBorderColor(Styles.Position.TOP, Color.BLACK);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.BLACK);
        sa.setFontColor(Color.BLACK);
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
        this.location = new Location(this);
        this.tablocation = new TableLocation(null);
        this.width = width;
        this.widthLom = (int)StyleUtil.pixelToLom((long)width);
        this.height = height;
        this.heightLom = (int)StyleUtil.pixelToLom((long)height);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean intersects(Point p) {
        Rectangle r = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        Point pt = this.getCorrespondTopPos();
        r.translate(pt.x, pt.y);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(p.x, p.y, 1.0, 1.0);
    }

    public boolean intersects2(Point p) {
        Rectangle r = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        Point pt = this.getCorrespondTopPos();
        r.translate(pt.x, pt.y);
        r.height += 10;
        r.y -= 5;
        r.width += 10;
        r.x -= 5;
        return r.intersects(p.x, p.y, 1.0, 1.0);
    }

    @Override
    public boolean intersects(Rectangle r2) {
        Rectangle r = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        Point pt = this.getCorrespondTopPos();
        r.translate(pt.x, pt.y);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(r2);
    }

    @Override
    public Point trasform(Point delta, int type) {
        Location newLoc;
        if (delta == null || this.isLocked()) {
            return null;
        }
        Point result = new Point(delta.x, delta.y);
        this.location = newLoc = this.location.cloneMe();
        switch (type) {
            case 0: {
                if (this.location.getSideLocation(0).getType() != 1 && delta.x != 0) {
                    this.translate(delta.x, 0);
                }
                if (this.location.getSideLocation(3).getType() == 1 || delta.y == 0) break;
                this.translate(0, delta.y);
                break;
            }
            case 2: {
                this.transformE(delta, result);
                break;
            }
            case 8: {
                this.transformW(delta);
                break;
            }
            case 1: {
                this.transformN(delta);
                break;
            }
            case 4: {
                this.transformS(delta, result);
                break;
            }
            case 6: {
                this.transformS(delta, result);
                this.transformE(delta, result);
                break;
            }
            case 3: {
                this.transformN(delta);
                this.transformE(delta, result);
                break;
            }
            case 12: {
                this.transformS(delta, result);
                this.transformW(delta);
                break;
            }
            case 9: {
                this.transformN(delta);
                this.transformW(delta);
            }
        }
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
        this.essureInParent();
        if (this.getEleType() == 10) {
            this.setWidthLom(this.getWidthLom());
            this.setHeightLom(this.getHeightLom());
        }
        return result;
    }

    private void transformS(Point delta, Point result) {
        if (this.location.getSideLocation(2).getType() != 1) {
            int old_y = this.heightLom;
            this.height += delta.y;
            this.heightLom = (int)((long)this.heightLom + StyleUtil.pixelToLom((long)delta.y));
            if (this.height < 0) {
                this.height = 0;
                this.heightLom = 0;
            }
            result.y = this.heightLom - old_y;
            this.location.getSideLocation(3).setValue(this.location.getSideLocation(3).getValue() + result.y);
            if (!(this.getParent() instanceof Table)) {
                this.setLocation(this.location);
            }
        }
    }

    private void transformN(Point delta) {
        if (this.location.getSideLocation(2).getType() != 1) {
            this.position.y += delta.y;
            this.posLom.y = (int)((long)this.posLom.y + StyleUtil.pixelToLom((long)delta.y));
            this.height += -delta.y;
            this.heightLom = (int)((long)this.heightLom + StyleUtil.pixelToLom((long)(-delta.y)));
            this.location.getSideLocation(2).setValue((int)((long)this.location.getSideLocation(2).getValue() + StyleUtil.pixelToLom((long)delta.y)));
            if (this.location.isDefaultLocationSide(3)) {
                this.location.getSideLocation(3).setValue((int)((long)this.location.getSideLocation(3).getValue() + StyleUtil.pixelToLom((long)(-delta.y))));
            }
            if (!(this.getParent() instanceof Table)) {
                this.setLocation(this.location);
            }
        }
    }

    private void transformW(Point delta) {
        if (this.location.getSideLocation(0).getType() != 1) {
            this.position.x += delta.x;
            this.posLom.x = (int)((long)this.posLom.x + StyleUtil.pixelToLom((long)delta.x));
            this.width += -delta.x;
            this.widthLom = (int)((long)this.widthLom + StyleUtil.pixelToLom((long)(-delta.x)));
            this.location.getSideLocation(0).setValue((int)((long)this.location.getSideLocation(0).getValue() + StyleUtil.pixelToLom((long)delta.x)));
            if (this.location.isDefaultLocationSide(1)) {
                this.location.getSideLocation(1).setValue((int)((long)this.location.getSideLocation(1).getValue() + StyleUtil.pixelToLom((long)(-delta.x))));
            }
            if (!(this.getParent() instanceof Table)) {
                this.setLocation(this.location);
            }
        }
    }

    private void transformE(Point delta, Point result) {
        if (this.location.getSideLocation(0).getType() != 1) {
            int old_x = this.widthLom;
            this.width += delta.x;
            this.widthLom = (int)((long)this.widthLom + StyleUtil.pixelToLom((long)delta.x));
            if (this.width < 0) {
                this.width = 0;
                this.widthLom = 0;
            }
            result.x = this.widthLom - old_x;
            this.location.getSideLocation(1).setValue(this.location.getSideLocation(1).getValue() + result.x);
            if (!(this.getParent() instanceof Table)) {
                this.setLocation(this.location);
            }
        }
    }

    private void essureInParent() {
        Rectangle parentrc = new Rectangle(0, 0, this.container.getWidth(), this.container.getHeight());
        Rectangle interRc = parentrc.intersection(this.bounds);
        this.position.x = interRc.x;
        this.position.y = interRc.y;
        this.width = interRc.width;
        this.height = interRc.height;
        this.bounds = interRc;
    }

    public void updateBounds() {
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public void translate(int x, int y) {
        if (this.location.getSideLocation(0).getType() != 1) {
            if (x + this.position.x + this.width > this.getParent().getWidth()) {
                x = this.getParent().getWidth() - this.width - this.position.x;
            }
            if (this.position.x + x < 0) {
                x = -this.position.x;
            }
            this.position.x += x;
            this.posLom.x = (int)((long)this.posLom.x + StyleUtil.pixelToLom((long)x));
            this.location.getSideLocation(0).setValue((int)((long)this.location.getSideLocation(0).getValue() + StyleUtil.pixelToLom((long)x)));
            if (!this.location.isDefaultLocationSide(1)) {
                this.location.getSideLocation(1).setValue((int)((long)this.location.getSideLocation(1).getValue() + StyleUtil.pixelToLom((long)x)));
            }
        }
        if (this.location.getSideLocation(2).getType() != 1) {
            if (y + this.position.y + this.height > this.getParent().getHeight()) {
                y = this.getParent().getHeight() - this.height - this.position.y;
            }
            if (this.position.y + y < 0) {
                y = -this.position.y;
            }
            this.position.y += y;
            this.posLom.y = (int)((long)this.posLom.y + StyleUtil.pixelToLom((long)y));
            this.location.getSideLocation(2).setValue((int)((long)this.location.getSideLocation(2).getValue() + StyleUtil.pixelToLom((long)y)));
            if (!this.location.isDefaultLocationSide(3)) {
                this.location.getSideLocation(3).setValue((int)((long)this.location.getSideLocation(3).getValue() + StyleUtil.pixelToLom((long)y)));
            }
        }
        this.updateBounds();
        if (!(this.getParent() instanceof Table)) {
            this.setLocation(this.location);
        }
    }

    public Point trasformTest(Point delta, int type) {
        if (delta == null) {
            return null;
        }
        Point result = new Point(delta.x, delta.y);
        int old_x = 0;
        int old_y = 0;
        if (type != 0) {
            if (type == 2) {
                old_x = this.width;
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == 8) {
                result.x = Math.min(delta.x, this.width);
            } else if (type == 1) {
                result.y = Math.min(delta.y, this.height);
            } else if (type == 4) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.y = old_y - this.height;
            } else if (type == 6) {
                old_y = this.height;
                old_x = this.width;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
                result.y = old_y - this.height;
            } else if (type == 12) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.x = Math.min(delta.x, this.width);
                result.y = old_y - this.height;
            } else if (type == 3) {
                old_x = this.width;
                result.y = Math.min(delta.y, this.height);
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == 9) {
                result.y = Math.min(delta.y, this.height);
                result.x = Math.min(delta.x, this.width);
            }
        }
        this.setHeight(this.height);
        this.setWidth(this.width);
        return result;
    }

    public String toString() {
        return this.aliasName;
    }

    public int getZoomedDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim * this.zoom_factor);
    }

    public double getZoomedDim(double dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return dim * this.zoom_factor;
    }

    public int getLogicalDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim / this.zoom_factor);
    }

    public ReportElement cloneMe() {
        ReportElement newReportElement = new ReportElement(this.name, 0, 0, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        destination.aliasName = this.aliasName;
        destination.ssa = this.ssa;
        destination.style = this.style;
        destination.eletype = this.eletype;
        destination.holdPlace = this.holdPlace;
        destination.isLocked = this.isLocked;
        destination.layer = this.layer;
        destination.location = this.location.cloneMe();
        destination.location.setOwner(destination);
        destination.tablocation = this.tablocation.cloneMe();
        destination.postSteps = this.postSteps;
        destination.preSteps = this.preSteps;
        destination.visibility = this.visibility;
        destination.widthLom = this.widthLom;
        destination.heightLom = this.heightLom;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point p) {
        if (p == null) {
            return;
        }
        if (p.x == this.position.x && p.y == this.position.y) {
            return;
        }
        this.position.x = p.x;
        this.position.y = p.y;
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
        this.firePropertyChange(null);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.widthLom = (int)StyleUtil.pixelToLom((long)width);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.heightLom = (int)StyleUtil.pixelToLom((long)height);
    }

    @Override
    public StyleAttributes getStyleAttribute() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.ssa);
        sa.append(Styles.getDefaultSSA(), false);
        return sa;
    }

    public ShareStyleAttributes getShareStyleAttribute() {
        return this.ssa;
    }

    @Override
    public void setStyleAttribute(StyleAttributes sa) {
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
        this.firePropertyChange("style");
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setParent(IContainer parent) {
        this.container = parent;
        this.topPage = ((ReportElement)((Object)parent)).getTopContainer();
        this.location.createDefaultLocation();
    }

    @Override
    public IContainer getParent() {
        return this.container;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName, boolean bOnlyAdd) {
        KDF kdf;
        String oldAliasName = this.aliasName;
        this.aliasName = aliasName;
        KDFFrame frame = null;
        if (this.getTopContainer() != null && (kdf = this.getTopContainer().getKDF()) != null) {
            frame = kdf.getKDFFrame();
        }
        if (frame != null) {
            HashMap map = this.getTopContainer().getKDF().getElementsAliasNameMap();
            if (!bOnlyAdd && map.containsKey(oldAliasName)) {
                map.remove(oldAliasName);
            }
            map.put(this.aliasName, this);
            frame.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(frame, this, 3));
        }
    }

    @Override
    public void setAliasName(String aliasName) {
        this.setAliasName(aliasName, false);
        this.firePropertyChange(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String strName) {
        this.name = strName;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public String getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(String string) {
        this.layer = string;
        this.firePropertyChange(null);
    }

    @Override
    public String getPostSteps() {
        return this.postSteps;
    }

    @Override
    public String getPreSteps() {
        return this.preSteps;
    }

    @Override
    public void setPostSteps(String string) {
        this.postSteps = string;
        this.firePropertyChange(null);
    }

    @Override
    public void setPreSteps(String string) {
        this.preSteps = string;
        this.firePropertyChange(null);
    }

    @Override
    public void setLocked(boolean locked) {
        this.isLocked = locked;
        this.firePropertyChange(null);
    }

    @Override
    public String getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(String val) {
        this.visibility = val;
        this.firePropertyChange(null);
    }

    @Override
    public String getHoldPlace() {
        return this.holdPlace;
    }

    @Override
    public void setHoldPlace(String val) {
        this.holdPlace = val;
        this.firePropertyChange(null);
    }

    @Override
    public int getPriority() {
        return this.priorityLevel;
    }

    @Override
    public void setPriority(int priorityLevel) {
        this.priorityLevel = priorityLevel;
        this.firePropertyChange(null);
    }

    public Page getTopContainer() {
        return this.topPage;
    }

    public void setTopContainer(Page topcontainer) {
        this.topPage = topcontainer;
    }

    public void setTableLocation(TableLocation tl) {
        if (this.getParent() instanceof Table) {
            Table parent = (Table)this.getParent();
            if (tl.getEndRow() > parent.getRowCount()) {
                tl.setEndRow(parent.getRowCount());
                if (tl.getStartRow() >= tl.getEndRow()) {
                    tl.setStartRow(tl.getEndRow() - 1);
                }
            }
            if (tl.getEndCol() > parent.getColumnCount()) {
                tl.setEndCol(parent.getColumnCount());
                if (tl.getStartCol() >= tl.getEndCol()) {
                    tl.setStartCol(tl.getEndCol() - 1);
                }
            }
            this.tablocation = tl;
            ((Table)this.getParent()).refreshChildPos();
        }
    }

    public boolean setLocation(Location loc) {
        this.firePropertyChange(null);
        Location oldLoc = this.location;
        this.location = loc;
        this.addRelationQuean(this.getTopContainer().deps);
        if (this.getTopContainer().recalcAllPos()) {
            return true;
        }
        this.location = oldLoc;
        this.addRelationQuean(this.getTopContainer().deps);
        this.getTopContainer().recalcAllPos();
        return false;
    }

    public void addRelationQuean(TableRelations deps) {
        if (this.getParent() instanceof Table) {
            RelationKey keyleft = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_left"), null);
            deps.queue(keyleft, "=" + this.getParent().getName() + "_left+" + String.valueOf(this.posLom.x));
            this.getTopContainer().allRelationsMap.put(keyleft, this);
            RelationKey keyright = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_right"), null);
            deps.queue(keyright, "=" + this.getName() + "_left+" + String.valueOf(this.widthLom));
            this.getTopContainer().allRelationsMap.put(keyright, this);
            RelationKey keytop = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_top"), null);
            deps.queue(keytop, "=" + this.getParent().getName() + "_top+" + String.valueOf(this.posLom.y));
            this.getTopContainer().allRelationsMap.put(keytop, this);
            RelationKey keybottom = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_bottom"), null);
            deps.queue(keybottom, "=" + this.getName() + "_top+" + String.valueOf(this.posLom.y + this.heightLom));
            this.getTopContainer().allRelationsMap.put(keybottom, this);
        } else {
            RelationKey keyleft = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_left"), null);
            deps.queue(keyleft, this.getLocation().getRelationFormula(0));
            this.getTopContainer().allRelationsMap.put(keyleft, this);
            RelationKey keyright = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_right"), null);
            deps.queue(keyright, this.getLocation().getRelationFormula(1));
            this.getTopContainer().allRelationsMap.put(keyright, this);
            RelationKey keytop = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_top"), null);
            deps.queue(keytop, this.getLocation().getRelationFormula(2));
            this.getTopContainer().allRelationsMap.put(keytop, this);
            RelationKey keybottom = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_bottom"), null);
            deps.queue(keybottom, this.getLocation().getRelationFormula(3));
            this.getTopContainer().allRelationsMap.put(keybottom, this);
        }
    }

    public void valideBounds() {
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        if (this.position.x + this.width > this.getParent().getWidth()) {
            this.width = this.getParent().getWidth() - this.position.x;
        }
        if (this.position.y + this.height > this.getParent().getHeight()) {
            this.height = this.getParent().getHeight() - this.position.y;
        }
    }

    public TableLocation getTableLocation() {
        return this.tablocation;
    }

    public void delete() {
        AbstractContainer parent = (AbstractContainer)this.getParent();
        ArrayList<ReportElement> children = new ArrayList<ReportElement>();
        for (ReportElement child : parent.allChildren) {
            if (child.equals(this)) continue;
            children.add(child);
            if (parent instanceof Table) continue;
            this.ensureRelativeObject(parent, child);
        }
        parent.allChildren = children;
    }

    private void ensureRelativeObject(AbstractContainer parent, ReportElement brother) {
        SideLocation bottom;
        SideLocation top;
        SideLocation right;
        SideLocation left = brother.getLocation().getSideLocation(0);
        if (left.getRelativeObjectID().equals(this.getName())) {
            left.setRelativeObjectID(parent.getName());
            left.setContextValue(0);
        }
        if ((right = brother.getLocation().getSideLocation(1)).getRelativeObjectID().equals(this.getName())) {
            right.setRelativeObjectID(brother.getName());
            right.setContextValue(0);
        }
        if ((top = brother.getLocation().getSideLocation(2)).getRelativeObjectID().equals(this.getName())) {
            top.setRelativeObjectID(parent.getName());
            top.setContextValue(2);
        }
        if ((bottom = brother.getLocation().getSideLocation(3)).getRelativeObjectID().equals(this.getName())) {
            bottom.setRelativeObjectID(brother.getName());
            bottom.setContextValue(2);
        }
        LocationPanel.lockObjectPos(brother);
    }

    public int getEleType() {
        return this.eletype;
    }

    @Override
    public int getHeightLom() {
        return this.heightLom;
    }

    @Override
    public void setHeightLom(int heightLom) {
        this.heightLom = heightLom;
        this.height = (int)StyleUtil.lomToPixel((long)heightLom);
        this.updateBounds();
    }

    @Override
    public Point getPosLom() {
        return this.posLom;
    }

    public void setPosLom(Point posLom) {
        this.posLom = posLom;
        this.position.x = (int)StyleUtil.lomToPixel((long)posLom.x);
        this.position.y = (int)StyleUtil.lomToPixel((long)posLom.y);
    }

    @Override
    public int getWidthLom() {
        return this.widthLom;
    }

    @Override
    public void setWidthLom(int widthLom) {
        this.widthLom = widthLom;
        this.width = (int)StyleUtil.lomToPixel((long)widthLom);
        this.updateBounds();
    }

    public Rectangle getBoundsLom() {
        Rectangle rc = new Rectangle(this.posLom.x, this.posLom.y, this.widthLom, this.heightLom);
        return rc;
    }

    public void setStartCol(int col) {
        this.getTableLocation().setStartCol(col);
        this.firePropertyChange(null);
    }

    public void setStartRow(int row) {
        this.getTableLocation().setStartRow(row);
        this.firePropertyChange(null);
    }

    public void setEndCol(int col) {
        this.getTableLocation().setEndCol(col);
        this.firePropertyChange(null);
    }

    public void setEndRow(int row) {
        this.getTableLocation().setEndRow(row);
        this.firePropertyChange(null);
    }

    @Override
    public void setIsLoading(boolean b) {
        this.isLoading = b;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChange(String prptName) {
        Object[] listeners = this.listenerList.getListenerList();
        PropertyChangeEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            if (null == event) {
                event = new PropertyChangeEvent(this, prptName);
            }
            ((PropertyChangeListener)listeners[i + 1]).propertyChanged(event);
        }
    }

    public boolean isHorizontalAbsoluteLocation() {
        SideLocation left = this.getLocation().getSideLocation(0);
        SideLocation right = this.getLocation().getSideLocation(1);
        return left.getType() == 0 && left.getRelativeObjectID().equals(this.getParent().getName()) && left.getContextValue() == 0 && right.getType() == 0 && right.getRelativeObjectID().equals(this.getName()) && right.getContextValue() == 0;
    }

    public boolean isVerticalAbsoluteLocation() {
        SideLocation top = this.getLocation().getSideLocation(2);
        SideLocation bottom = this.getLocation().getSideLocation(3);
        return top.getType() == 0 && top.getRelativeObjectID().equals(this.getParent().getName()) && top.getContextValue() == 2 && bottom.getType() == 0 && bottom.getRelativeObjectID().equals(this.getName()) && bottom.getContextValue() == 2;
    }

    public DivideCharacter getDivideCharacter() {
        return this.divideCharacter;
    }

    public void setDivideCharacter(DivideCharacter divideCharacter) {
        this.divideCharacter = divideCharacter;
        this.firePropertyChange(null);
    }

    static {
        solidStroke = new BasicStroke(1.0f);
    }
}

