/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElementType;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.TextElement;
import java.util.HashMap;

public class VariantElement
extends TextElement {
    private static HashMap variantSupply = new HashMap();
    private Variant variant;
    private String format;

    public VariantElement(String name, int left, int top, int width, int height) {
        super(name, left, top, width, height);
        this.text = ReportElementType.getMLS("defaultVariantText", "\u53d8\u91cf");
        this.eletype = 14;
        this.format = "";
    }

    public static HashMap getVariantSupply() {
        return variantSupply;
    }

    public void setVariant(String vName) {
        Variant var = (Variant)variantSupply.get(vName);
        this.variant = var == null ? new Variant(vName) : var;
        StringBuffer sb = new StringBuffer();
        sb.append("$V{");
        if (this.variant.getAlias() == null) {
            sb.append(this.variant.getName());
        } else {
            sb.append(this.variant.getAlias());
        }
        sb.append("}");
        this.setText(sb.toString());
    }

    public Variant getVariant() {
        return this.variant;
    }

    public String getVariantName() {
        if (this.variant == null) {
            return null;
        }
        return this.variant.getName();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.firePropertyChange(null);
    }

    @Override
    public ReportElement cloneMe() {
        VariantElement newReportElement = new VariantElement(this.name, 0, 0, this.width, this.height);
        newReportElement.format = this.format;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public static class Variant {
        private String name;
        private String alias;

        public Variant(String name) {
            this.setName(name);
        }

        public Variant(String name, String alias) {
            this.setName(name);
            this.setAlias(alias);
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.alias != null) {
                sb.append(this.alias);
            }
            if (!StringUtil.isEmptyString((String)this.name)) {
                sb.append("(");
                sb.append(this.name);
                sb.append(")");
            }
            return sb.toString();
        }

        public boolean equals(Object another) {
            return another != null && another instanceof Variant && StringUtil.equals((String)this.getName(), (String)((Variant)another).getName());
        }
    }
}

