/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.undo;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.kdf.fd2.UndoOperation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import java.util.ArrayList;

public class DeleteElementsOperation
implements UndoOperation {
    private ArrayList elements = new ArrayList();
    private KDFFrame jrf = null;
    private static String res = CtrlClassUtil.getPackageName(DeleteElementsOperation.class) + ".undo";

    public DeleteElementsOperation(KDFFrame jrf) {
        this.jrf = jrf;
    }

    @Override
    public void redo() {
        if (this.jrf == null) {
            return;
        }
        for (ReportElement element : this.getElements()) {
            this.jrf.getSelectedElements().remove(element);
            element.delete();
            if (element.getTopContainer() != this.jrf.getCurrentPage()) {
                this.jrf.setCurrentpage(element.getTopContainer());
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 1));
        }
        this.jrf.getReportPanel().repaint();
    }

    @Override
    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getSelectedElements().clear();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            ReportElement element = (ReportElement)this.getElements().get(i);
            element.getParent().addElement(element);
            if (element.getTopContainer() != this.jrf.getCurrentPage()) {
                this.jrf.setCurrentpage(element.getTopContainer());
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 2));
            this.jrf.addSelectedElement(element);
            if (!(element.getParent() instanceof Table)) continue;
            element.setTableLocation(element.getTableLocation());
        }
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return this.getMLS("delete", "\u5220\u9664");
    }

    public ArrayList getElements() {
        return this.elements;
    }

    public void setElements(ArrayList elements) {
        this.elements = (ArrayList)elements.clone();
    }

    public void addElement(ReportElement element) {
        this.getElements().add(element);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }
}

