/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.undo;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.kdf.fd2.ILocation;
import com.kingdee.bos.ctrl.kdf.fd2.Location;
import com.kingdee.bos.ctrl.kdf.fd2.TableLocation;
import com.kingdee.bos.ctrl.kdf.fd2.UndoOperation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.fd2.undo.ElementTransformation;
import java.util.Enumeration;
import java.util.Vector;

public class TransformElementsOperation
implements UndoOperation {
    private Vector transformations = new Vector();
    private KDFFrame jrf = null;
    private static String res = CtrlClassUtil.getPackageName(TransformElementsOperation.class) + ".undo";

    public TransformElementsOperation(KDFFrame jrf) {
        this.jrf = jrf;
    }

    @Override
    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        Enumeration enum1 = this.getTransformations().elements();
        while (enum1.hasMoreElements()) {
            ElementTransformation pe = (ElementTransformation)enum1.nextElement();
            ReportElement element = pe.element;
            this.jrf.addSelectedElement(element);
            ILocation loc = pe.newLocation;
            if (loc instanceof Location) {
                element.setLocation((Location)pe.newLocation);
            } else {
                if (!(loc instanceof TableLocation)) continue;
                element.setTableLocation((TableLocation)pe.newLocation);
                ((Table)pe.element.getParent()).refreshGridPos();
            }
            if (element.getTopContainer() != this.jrf.getCurrentPage()) {
                this.jrf.setCurrentpage(element.getTopContainer());
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.getReportPanel().repaint();
    }

    @Override
    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        for (int i = this.getTransformations().size() - 1; i >= 0; --i) {
            ElementTransformation pe = (ElementTransformation)this.getTransformations().get(i);
            ReportElement element = pe.element;
            this.jrf.addSelectedElement(element);
            ILocation loc = pe.oldLocation;
            if (loc instanceof Location) {
                element.setLocation((Location)pe.oldLocation);
            } else {
                if (!(loc instanceof TableLocation)) continue;
                element.setTableLocation((TableLocation)pe.oldLocation);
                ((Table)pe.element.getParent()).refreshGridPos();
            }
            if (element.getTopContainer() != this.jrf.getCurrentPage()) {
                this.jrf.setCurrentpage(element.getTopContainer());
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
        }
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return this.getMLS("move", "\u79fb\u52a8");
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(ReportElement element, ILocation oldLoc, ILocation newLoc) {
        ElementTransformation et = new ElementTransformation();
        et.element = element;
        et.oldLocation = oldLoc;
        et.newLocation = newLoc;
        this.getTransformations().add(et);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }
}

