/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis.standard;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.analysis.LowerCaseFilter;
import com.kingdee.bos.ctrl.lucene.analysis.StopAnalyzer;
import com.kingdee.bos.ctrl.lucene.analysis.StopFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import com.kingdee.bos.ctrl.lucene.analysis.WordlistLoader;
import com.kingdee.bos.ctrl.lucene.analysis.standard.StandardFilter;
import com.kingdee.bos.ctrl.lucene.analysis.standard.StandardTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;

public class StandardAnalyzer
extends Analyzer {
    private Set stopSet;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;

    public StandardAnalyzer() {
        this(STOP_WORDS);
    }

    public StandardAnalyzer(Set stopWords) {
        this.stopSet = stopWords;
    }

    public StandardAnalyzer(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet(stopWords);
    }

    public StandardAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
    }

    public StandardAnalyzer(Reader stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopSet);
        return result;
    }
}

