/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.index;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.document.FieldSelector;
import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.MultiTermDocs;
import com.kingdee.bos.ctrl.lucene.index.MultiTermEnum;
import com.kingdee.bos.ctrl.lucene.index.MultiTermPositions;
import com.kingdee.bos.ctrl.lucene.index.SegmentInfos;
import com.kingdee.bos.ctrl.lucene.index.SegmentReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.index.TermFreqVector;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import com.kingdee.bos.ctrl.lucene.store.Directory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public class MultiReader
extends IndexReader {
    private IndexReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    public MultiReader(IndexReader[] subReaders) throws IOException {
        super(subReaders.length == 0 ? null : subReaders[0].directory());
        this.initialize(subReaders);
    }

    MultiReader(Directory directory, SegmentInfos sis, boolean closeDirectory, IndexReader[] subReaders) {
        super(directory, sis, closeDirectory);
        this.initialize(subReaders);
    }

    private void initialize(IndexReader[] subReaders) {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    @Override
    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    @Override
    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes == null && !this.hasNorms(field)) {
            bytes = this.fakeNorms();
        }
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    @Override
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    @Override
    protected void doCommit() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    @Override
    void startCommit() {
        super.startCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    @Override
    void rollbackCommit() {
        super.rollbackCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].close();
        }
    }

    @Override
    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.subReaders.length; ++i) {
            IndexReader reader = this.subReaders[i];
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }
}

