/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.index;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import java.io.IOException;

final class SegmentMergeInfo {
    Term term;
    int base;
    TermEnum termEnum;
    IndexReader reader;
    private TermPositions postings;
    private int[] docMap;

    SegmentMergeInfo(int b, TermEnum te, IndexReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
    }

    int[] getDocMap() {
        if (this.docMap == null && this.reader.hasDeletions()) {
            int maxDoc = this.reader.maxDoc();
            this.docMap = new int[maxDoc];
            int j = 0;
            for (int i = 0; i < maxDoc; ++i) {
                this.docMap[i] = this.reader.isDeleted(i) ? -1 : j++;
            }
        }
        return this.docMap;
    }

    TermPositions getPositions() throws IOException {
        if (this.postings == null) {
            this.postings = this.reader.termPositions();
        }
        return this.postings;
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        if (this.postings != null) {
            this.postings.close();
        }
    }
}

