/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.BooleanClause;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.FilteredTermEnum;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;

public abstract class MultiTermQuery
extends Query {
    private Term term;

    public MultiTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        try (FilteredTermEnum enumerator = this.getEnum(reader);){
            do {
                Term t;
                if ((t = enumerator.term()) == null) continue;
                TermQuery tq = new TermQuery(t);
                tq.setBoost(this.getBoost() * enumerator.difference());
                query.add(tq, BooleanClause.Occur.SHOULD);
            } while (enumerator.next());
        }
        return query;
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiTermQuery)) {
            return false;
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)o;
        if (!this.term.equals(multiTermQuery.term)) {
            return false;
        }
        return this.getBoost() == multiTermQuery.getBoost();
    }

    public int hashCode() {
        return this.term.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

