/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.IndexSearcher;
import com.kingdee.bos.ctrl.lucene.search.Query;
import java.io.IOException;
import java.util.BitSet;

public class QueryWrapperFilter
extends Filter {
    private Query query;

    public QueryWrapperFilter(Query query) {
        this.query = query;
    }

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bits = new BitSet(reader.maxDoc());
        new IndexSearcher(reader).search(this.query, new HitCollector(){

            @Override
            public final void collect(int doc, float score) {
                bits.set(doc);
            }
        });
        return bits;
    }

    public String toString() {
        return "QueryWrapperFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryWrapperFilter)) {
            return false;
        }
        return this.query.equals(((QueryWrapperFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

