/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.function;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.ComplexExplanation;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.search.function.ValueSourceQuery;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.Set;

public class CustomScoreQuery
extends Query {
    private Query subQuery;
    private ValueSourceQuery valSrcQuery;
    private boolean strict = false;

    public CustomScoreQuery(Query subQuery) {
        this(subQuery, null);
    }

    public CustomScoreQuery(Query subQuery, ValueSourceQuery valSrcQuery) {
        this.subQuery = subQuery;
        this.valSrcQuery = valSrcQuery;
        if (subQuery == null) {
            throw new IllegalArgumentException("<subqyery> must not be null!");
        }
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        this.subQuery = this.subQuery.rewrite(reader);
        if (this.valSrcQuery != null) {
            this.valSrcQuery = (ValueSourceQuery)this.valSrcQuery.rewrite(reader);
        }
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
        this.subQuery.extractTerms(terms);
        if (this.valSrcQuery != null) {
            this.valSrcQuery.extractTerms(terms);
        }
    }

    @Override
    public Object clone() {
        CustomScoreQuery clone = (CustomScoreQuery)super.clone();
        clone.subQuery = (Query)this.subQuery.clone();
        if (this.valSrcQuery != null) {
            clone.valSrcQuery = (ValueSourceQuery)this.valSrcQuery.clone();
        }
        return clone;
    }

    @Override
    public String toString(String field) {
        StringBuffer sb = new StringBuffer(this.name()).append("(");
        sb.append(this.subQuery.toString(field));
        if (this.valSrcQuery != null) {
            sb.append(", ").append(this.valSrcQuery.toString(field));
        }
        sb.append(")");
        sb.append(this.strict ? " STRICT" : "");
        return sb.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CustomScoreQuery other = (CustomScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.subQuery.equals(other.subQuery) && (this.valSrcQuery == null ? other.valSrcQuery == null : this.valSrcQuery.equals(other.valSrcQuery));
    }

    public int hashCode() {
        int valSrcHash = this.valSrcQuery == null ? 0 : this.valSrcQuery.hashCode();
        return this.getClass().hashCode() + this.subQuery.hashCode() + valSrcHash ^ Float.floatToIntBits(this.getBoost());
    }

    public float customScore(int doc, float subQueryScore, float valSrcScore) {
        return valSrcScore * subQueryScore;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) {
        float valSrcScore = valSrcExpl == null ? 1.0f : valSrcExpl.getValue();
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        if (valSrcExpl != null) {
            exp.addDetail(valSrcExpl);
        }
        return exp;
    }

    @Override
    protected Weight createWeight(Searcher searcher) throws IOException {
        return new CustomWeight(searcher);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String name() {
        return "custom";
    }

    private class CustomScorer
    extends Scorer {
        private final CustomWeight weight;
        private final float qWeight;
        private Scorer subQueryScorer;
        private Scorer valSrcScorer;
        private IndexReader reader;

        private CustomScorer(Similarity similarity, IndexReader reader, CustomWeight w, Scorer subQueryScorer, Scorer valSrcScorer) throws IOException {
            super(similarity);
            this.weight = w;
            this.qWeight = w.getValue();
            this.subQueryScorer = subQueryScorer;
            this.valSrcScorer = valSrcScorer;
            this.reader = reader;
        }

        @Override
        public boolean next() throws IOException {
            boolean hasNext = this.subQueryScorer.next();
            if (this.valSrcScorer != null && hasNext) {
                this.valSrcScorer.skipTo(this.subQueryScorer.doc());
            }
            return hasNext;
        }

        @Override
        public int doc() {
            return this.subQueryScorer.doc();
        }

        @Override
        public float score() throws IOException {
            float valSrcScore = this.valSrcScorer == null ? 1.0f : this.valSrcScorer.score();
            return this.qWeight * CustomScoreQuery.this.customScore(this.subQueryScorer.doc(), this.subQueryScorer.score(), valSrcScore);
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            boolean hasNext = this.subQueryScorer.skipTo(target);
            if (this.valSrcScorer != null && hasNext) {
                this.valSrcScorer.skipTo(this.subQueryScorer.doc());
            }
            return hasNext;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            Explanation subQueryExpl = this.weight.subQueryWeight.explain(this.reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            Explanation valSrcExpl = this.valSrcScorer == null ? null : this.valSrcScorer.explain(doc);
            Explanation customExp = CustomScoreQuery.this.customExplain(doc, subQueryExpl, valSrcExpl);
            float sc = this.qWeight * customExp.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, CustomScoreQuery.this.toString() + ", product of:");
            res.addDetail(customExp);
            res.addDetail(new Explanation(this.qWeight, "queryBoost"));
            return res;
        }
    }

    private class CustomWeight
    implements Weight {
        Searcher searcher;
        Weight subQueryWeight;
        Weight valSrcWeight;
        boolean qStrict;

        public CustomWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.subQueryWeight = CustomScoreQuery.this.subQuery.weight(searcher);
            if (CustomScoreQuery.this.valSrcQuery != null) {
                this.valSrcWeight = CustomScoreQuery.this.valSrcQuery.createWeight(searcher);
            }
            this.qStrict = CustomScoreQuery.this.strict;
        }

        @Override
        public Query getQuery() {
            return CustomScoreQuery.this;
        }

        @Override
        public float getValue() {
            return CustomScoreQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum = this.subQueryWeight.sumOfSquaredWeights();
            if (this.valSrcWeight != null) {
                if (this.qStrict) {
                    this.valSrcWeight.sumOfSquaredWeights();
                } else {
                    sum += this.valSrcWeight.sumOfSquaredWeights();
                }
            }
            return sum *= CustomScoreQuery.this.getBoost() * CustomScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= CustomScoreQuery.this.getBoost());
            if (this.valSrcWeight != null) {
                if (this.qStrict) {
                    this.valSrcWeight.normalize(1.0f);
                } else {
                    this.valSrcWeight.normalize(norm);
                }
            }
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader);
            Scorer valSrcScorer = this.valSrcWeight == null ? null : this.valSrcWeight.scorer(reader);
            return new CustomScorer(CustomScoreQuery.this.getSimilarity(this.searcher), reader, this, subQueryScorer, valSrcScorer);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }
}

