/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.function;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.FieldCache;
import com.kingdee.bos.ctrl.lucene.search.function.DocValues;
import com.kingdee.bos.ctrl.lucene.search.function.ValueSource;
import java.io.IOException;

public class OrdFieldSource
extends ValueSource {
    protected String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public OrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "ord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(IndexReader reader) throws IOException {
        final int[] arr = FieldCache.DEFAULT.getStringIndex((IndexReader)reader, (String)this.field).order;
        return new DocValues(arr.length){

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(arr[doc]);
            }

            @Override
            public String toString(int doc) {
                return OrdFieldSource.this.description() + '=' + this.intVal(doc);
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != OrdFieldSource.class) {
            return false;
        }
        OrdFieldSource other = (OrdFieldSource)o;
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

