/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.spans;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanQuery;
import com.kingdee.bos.ctrl.lucene.search.spans.Spans;
import com.kingdee.bos.ctrl.lucene.search.spans.TermSpans;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class SpanTermQuery
extends SpanQuery {
    protected Term term;

    public SpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    @Override
    public void extractTerms(Set terms) {
        terms.add(this.term);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpanTermQuery)) {
            return false;
        }
        SpanTermQuery other = (SpanTermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode() ^ 0xD23FE494;
    }

    @Override
    public Spans getSpans(IndexReader reader) throws IOException {
        return new TermSpans(reader.termPositions(this.term), this.term);
    }
}

