/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DefaultContentHandler
extends DefaultHandler {
    private static final Logger logger = CommonSLF4JLogger.getLogger(DefaultContentHandler.class);
    private final ContentHandler handler;

    public DefaultContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public void parse(InputStream in) throws IOException, RepositoryException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser parser = factory.newSAXParser();
            logger.debug("Using SAX parser " + parser.getClass().getName());
            parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (FactoryConfigurationError e) {
            throw new RepositoryException("SAX parser implementation not available", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("SAX parser configuration error", (Throwable)e);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("Error parsing XML import", (Throwable)e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handler.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.handler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.handler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.handler.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.handler.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.handler.startPrefixMapping(prefix, uri);
    }
}

