/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.slf4j.Logger;

public class DerbyFileSystem
extends DbFileSystem {
    private static Logger log = CommonSLF4JLogger.getLogger(DerbyFileSystem.class);
    protected boolean shutdownOnClose;

    public DerbyFileSystem() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.shutdownOnClose = true;
        this.initialized = false;
    }

    public boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public void setShutdownOnClose(boolean shutdownOnClose) {
        this.shutdownOnClose = shutdownOnClose;
    }

    @Override
    protected void closeConnection(Connection connection) throws SQLException {
        String url = connection.getMetaData().getURL();
        int pos = url.lastIndexOf(59);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        url = url + ";shutdown=true";
        connection.setAutoCommit(true);
        connection.close();
        if (this.shutdownOnClose) {
            try {
                DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                log.info(e.getMessage());
            }
        }
    }
}

