/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.local;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;

class RAFOutputStream
extends RandomAccessOutputStream {
    static final int DEFAULT_BUFFER_SIZE = 1024;
    private final byte[] buffer;
    protected RandomAccessFile raf;
    private long bufferStart;
    private int bufferEnd;
    private byte[] one = new byte[1];

    public RAFOutputStream(RandomAccessFile raf, int size) throws IOException {
        this.raf = raf;
        this.buffer = new byte[size];
        this.bufferStart = raf.getFilePointer();
    }

    public RAFOutputStream(RandomAccessFile raf) throws IOException {
        this(raf, 1024);
    }

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferEnd;
    }

    @Override
    public void seek(long position) throws IOException {
        this.flush();
        this.raf.seek(position);
        this.bufferStart = position;
    }

    @Override
    public void write(int b) throws IOException {
        this.one[0] = (byte)b;
        this.write(this.one, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this.buffer.length - this.bufferEnd) {
            this.flush();
            this.raf.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.buffer, this.bufferEnd, len);
            this.bufferEnd += len;
        }
    }

    @Override
    public void flush() throws IOException {
        this.raf.write(this.buffer, 0, this.bufferEnd);
        this.bufferEnd = 0;
        this.bufferStart = this.raf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.raf.close();
        this.raf = null;
    }
}

