/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.ReadRecord;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;

class DatabaseRecordIterator
implements RecordIterator {
    private static Logger log = CommonSLF4JLogger.getLogger(DatabaseJournal.class);
    private final ResultSet rs;
    private final NamespaceResolver resolver;
    private final NamePathResolver npResolver;
    private ReadRecord record;
    private ReadRecord lastRecord;
    private boolean isEOF;

    public DatabaseRecordIterator(ResultSet rs, NamespaceResolver resolver, NamePathResolver npResolver) {
        this.rs = rs;
        this.resolver = resolver;
        this.npResolver = npResolver;
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.isEOF && this.record == null) {
                this.fetchRecord();
            }
            return !this.isEOF;
        }
        catch (SQLException e) {
            String msg = "Error while moving to next record.";
            log.error(msg, (Throwable)e);
            return false;
        }
    }

    @Override
    public Record nextRecord() throws NoSuchElementException, JournalException {
        if (!this.hasNext()) {
            String msg = "No current record.";
            throw new NoSuchElementException(msg);
        }
        DatabaseRecordIterator.close(this.lastRecord);
        this.lastRecord = this.record;
        this.record = null;
        return this.lastRecord;
    }

    @Override
    public void close() {
        if (this.lastRecord != null) {
            DatabaseRecordIterator.close(this.lastRecord);
            this.lastRecord = null;
        }
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            String msg = "Error while closing result set: " + e.getMessage();
            log.warn(msg);
        }
    }

    private void fetchRecord() throws SQLException {
        if (this.rs.next()) {
            long revision = this.rs.getLong(1);
            String journalId = this.rs.getString(2);
            String producerId = this.rs.getString(3);
            DataInputStream dataIn = new DataInputStream(this.rs.getBinaryStream(4));
            this.record = new ReadRecord(journalId, producerId, revision, dataIn, 0, this.resolver, this.npResolver);
        } else {
            this.isEOF = true;
        }
    }

    private static void close(ReadRecord record) {
        if (record != null) {
            try {
                record.close();
            }
            catch (IOException e) {
                String msg = "Error while closing record.";
                log.warn(msg, (Throwable)e);
            }
        }
    }
}

