/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

class ReferenceConstraint
extends ValueConstraint {
    final Name ntName;

    ReferenceConstraint(String definition, NamePathResolver resolver) throws InvalidConstraintException {
        super(definition);
        try {
            this.ntName = resolver.getQName(definition);
        }
        catch (NameException e) {
            String msg = "invalid node type name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, (Throwable)((Object)e));
        }
        catch (NamespaceException e) {
            String msg = "invalid node type name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
    }

    @Override
    public String getDefinition(NamePathResolver resolver) {
        try {
            return resolver.getJCRName(this.ntName);
        }
        catch (NamespaceException e) {
            return this.definition;
        }
    }

    Name getNodeTypeName() {
        return this.ntName;
    }

    @Override
    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 9: {
                log.info("validation of REFERENCE constraint is not yet implemented");
                return;
            }
        }
        String msg = "REFERENCE constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

