/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;

public class AdditionalNamespaceResolver
extends AbstractNamespaceResolver {
    private final Properties prefixToURI = new Properties();
    private final Properties uriToPrefix = new Properties();

    public AdditionalNamespaceResolver(Properties namespaces) {
        Enumeration<?> prefixes = namespaces.propertyNames();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            this.addNamespace(prefix, namespaces.getProperty(prefix));
        }
        this.addNamespace("", "");
    }

    public AdditionalNamespaceResolver(NamespaceRegistry registry) throws RepositoryException {
        String[] prefixes = registry.getPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            this.addNamespace(prefixes[i], registry.getURI(prefixes[i]));
        }
    }

    private void addNamespace(String prefix, String uri) {
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        String uri = this.prefixToURI.getProperty(prefix);
        if (uri != null) {
            return uri;
        }
        throw new NamespaceException("Unknown namespace prefix " + prefix + ".");
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.getProperty(uri);
        if (prefix != null) {
            return prefix;
        }
        throw new NamespaceException("Unknown namespace URI " + uri + ".");
    }
}

