/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventListenerIteratorImpl;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;

public class ObservationManagerImpl
implements ObservationManager,
EventStateCollectionFactory {
    private static final Logger log = CommonSLF4JLogger.getLogger(ObservationManagerImpl.class);
    private final SessionImpl session;
    private final ItemManager itemMgr;
    private final ObservationDispatcher dispatcher;

    public ObservationManagerImpl(ObservationDispatcher dispatcher, SessionImpl session, ItemManager itemMgr) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (itemMgr == null) {
            throw new NullPointerException("itemMgr");
        }
        this.dispatcher = dispatcher;
        this.session = session;
        this.itemMgr = itemMgr;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        Path path;
        NodeTypeImpl[] nodeTypes;
        if (nodeTypeName == null) {
            nodeTypes = null;
        } else {
            NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
            nodeTypes = new NodeTypeImpl[nodeTypeName.length];
            for (int i = 0; i < nodeTypes.length; ++i) {
                nodeTypes[i] = (NodeTypeImpl)ntMgr.getNodeType(nodeTypeName[i]);
            }
        }
        try {
            path = this.session.getQPath(absPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path syntax: " + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        NodeId[] ids = null;
        if (uuid != null) {
            ids = new NodeId[uuid.length];
            for (int i = 0; i < uuid.length; ++i) {
                ids[i] = NodeId.valueOf(uuid[i]);
            }
        }
        EventFilter filter = new EventFilter(this.itemMgr, this.session, eventTypes, path, isDeep, ids, nodeTypes, noLocal);
        this.dispatcher.addConsumer(new EventConsumer(this.session, listener, filter));
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.dispatcher.removeConsumer(new EventConsumer(this.session, listener, EventFilter.BLOCK_ALL));
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return new EventListenerIteratorImpl(this.session, this.dispatcher.getSynchronousConsumers(), this.dispatcher.getAsynchronousConsumers());
    }

    public void dispose() {
        try {
            EventListenerIterator it = this.getRegisteredEventListeners();
            while (it.hasNext()) {
                EventListener l = it.nextEventListener();
                log.debug("removing EventListener: " + l);
                this.removeEventListener(l);
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error: Unable to dispose ObservationManager.", (Throwable)e);
        }
    }

    @Override
    public EventStateCollection createEventStateCollection() {
        return new EventStateCollection(this.dispatcher, this.session, null);
    }

    static {
        EventListenerIteratorImpl.class.hashCode();
    }
}

