/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;

public class H2PersistenceManager
extends BundleDbPersistenceManager {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/H2PersistenceManager.java $ $Rev: 575734 $ $Date: 2007-09-14 19:04:19 +0300 (Fri, 14 Sep 2007) $";
    private long lockTimeout = 10000L;

    public String getLockTimeout() {
        return String.valueOf(this.lockTimeout);
    }

    public void setLockTimeout(String lockTimeout) {
        this.lockTimeout = Long.parseLong(lockTimeout);
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.h2.Driver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:h2:file:" + context.getHomeDir().getPath() + "/db/itemState");
        }
        if (this.getUser() == null) {
            this.setUser("sa");
        }
        if (this.getPassword() == null) {
            this.setPassword("sa");
        }
        if (this.getSchema() == null) {
            this.setSchema("h2");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
    }

    @Override
    protected void checkSchema() throws SQLException, RepositoryException {
        try (Statement stmt = this.connectionManager.getConnection().createStatement();){
            stmt.execute("SET LOCK_TIMEOUT " + this.lockTimeout);
        }
        super.checkSchema();
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.getUrl().startsWith("jdbc:h2:file:")) {
            Statement stmt = this.connectionManager.getConnection().createStatement();
            stmt.execute("shutdown");
            stmt.close();
        }
        super.close();
    }
}

