/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.text.NumberFormat;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = CommonSLF4JLogger.getLogger(QueryImpl.class);
    public static final String JCR_SQL2 = "JCR-SQL2";
    public static final String JCR_JQOM = "JCR-JQOM";
    protected SessionImpl session;
    protected String statement;
    protected String language;
    protected ExecutableQuery query;
    protected Node node;
    protected QueryHandler handler;
    private boolean initialized = false;
    private long limit;
    private long offset;

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.statement = statement;
        this.language = language;
        this.handler = handler;
        this.query = handler.createExecutableQuery(session, itemMgr, statement, language);
        this.setInitialized();
    }

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        if (!node.isNodeType(session.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("node is not of type nt:query");
        }
        this.statement = node.getProperty(session.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        this.language = node.getProperty(session.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        this.query = handler.createExecutableQuery(session, itemMgr, this.statement, this.language);
        this.setInitialized();
    }

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, QueryObjectModelTree qomTree, String language) throws InvalidQueryException, RepositoryException {
        throw new UnsupportedOperationException("not a prepared query");
    }

    public QueryResult execute() throws RepositoryException {
        this.checkInitialized();
        long time = System.currentTimeMillis();
        QueryResult result = this.query.execute(this.offset, this.limit);
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            String seconds = format.format((double)time / 1000.0);
            log.debug("executed in " + seconds + " s. (" + this.statement + ")");
        }
        return result;
    }

    public String getStatement() {
        this.checkInitialized();
        return this.statement;
    }

    public String getLanguage() {
        this.checkInitialized();
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        try {
            Path p = this.session.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String relPath = this.session.getJCRPath(p).substring(1);
            Node queryNode = this.session.getRootNode().addNode(relPath, this.session.getJCRName(NameConstants.NT_QUERY));
            queryNode.setProperty(this.session.getJCRName(NameConstants.JCR_LANGUAGE), this.language);
            queryNode.setProperty(this.session.getJCRName(NameConstants.JCR_STATEMENT), this.statement);
            this.node = queryNode;
            return this.node;
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    protected void setInitialized() {
        this.initialized = true;
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

