/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.BooleanClause;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.query.lucene.fulltext.QueryParser;
import org.apache.jackrabbit.core.query.qom.AndImpl;
import org.apache.jackrabbit.core.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.core.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.core.query.qom.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.core.query.qom.ColumnImpl;
import org.apache.jackrabbit.core.query.qom.ComparisonImpl;
import org.apache.jackrabbit.core.query.qom.ConstraintImpl;
import org.apache.jackrabbit.core.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.core.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.core.query.qom.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.core.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.core.query.qom.EquiJoinConditionImpl;
import org.apache.jackrabbit.core.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.core.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.core.query.qom.JoinImpl;
import org.apache.jackrabbit.core.query.qom.LengthImpl;
import org.apache.jackrabbit.core.query.qom.LiteralImpl;
import org.apache.jackrabbit.core.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.core.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.core.query.qom.NodeNameImpl;
import org.apache.jackrabbit.core.query.qom.NotImpl;
import org.apache.jackrabbit.core.query.qom.OrImpl;
import org.apache.jackrabbit.core.query.qom.OrderingImpl;
import org.apache.jackrabbit.core.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.core.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.core.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.core.query.qom.SameNodeImpl;
import org.apache.jackrabbit.core.query.qom.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.core.query.qom.SelectorImpl;
import org.apache.jackrabbit.core.query.qom.StaticOperandImpl;
import org.apache.jackrabbit.core.query.qom.UpperCaseImpl;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;

public class JQOM2LuceneQueryBuilder
implements QOMTreeVisitor {
    private static final Logger log = CommonSLF4JLogger.getLogger(JQOM2LuceneQueryBuilder.class);
    private final QueryObjectModelTree qomTree;
    private final SessionImpl session;
    private final ItemStateManager sharedItemMgr;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;
    private final NamePathResolver npResolver;
    private final Analyzer analyzer;
    private final PropertyTypeRegistry propRegistry;
    private final SynonymProvider synonymProvider;
    private final Map bindVariableValues;
    private final Map selectors = new HashMap();

    private JQOM2LuceneQueryBuilder(QueryObjectModelTree qomTree, SessionImpl session, ItemStateManager sharedItemMgr, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, Map bindVariableValues) {
        this.qomTree = qomTree;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
        this.npResolver = NamePathResolverImpl.create(nsMappings);
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.bindVariableValues = bindVariableValues;
    }

    public static Query createQuery(QueryObjectModelTree qomTree, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, Map bindVariableValues) throws RepositoryException {
        NodeId id = ((NodeImpl)session.getRootNode()).getNodeId();
        HierarchyManagerImpl hmgr = new HierarchyManagerImpl(id, sharedItemMgr, session);
        JQOM2LuceneQueryBuilder builder = new JQOM2LuceneQueryBuilder(qomTree, session, sharedItemMgr, hmgr, nsMappings, analyzer, propReg, synonymProvider, bindVariableValues);
        return builder.createLuceneQuery();
    }

    private Query createLuceneQuery() throws InvalidQueryException {
        try {
            return (Query)this.qomTree.accept(this, null);
        }
        catch (InvalidQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object visit(AndImpl node, Object data) throws Exception {
        BooleanQuery b = new BooleanQuery();
        b.add((Query)((ConstraintImpl)node.getConstraint1()).accept(this, data), BooleanClause.Occur.MUST);
        b.add((Query)((ConstraintImpl)node.getConstraint2()).accept(this, data), BooleanClause.Occur.MUST);
        return b;
    }

    @Override
    public Object visit(BindVariableValueImpl node, Object data) throws InvalidQueryException {
        Value v = (Value)this.bindVariableValues.get(node.getBindVariableQName());
        if (v == null) {
            throw new InvalidQueryException("No value bound for variable " + node.getBindVariableName());
        }
        return v;
    }

    @Override
    public Object visit(ChildNodeImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(ChildNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(ColumnImpl node, Object data) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(ComparisonImpl node, Object data) throws Exception {
        String stringValue;
        Value v = (Value)((StaticOperandImpl)node.getOperand2()).accept(this, data);
        switch (v.getType()) {
            case 2: {
                throw new InvalidQueryException("Binary value not supported in comparison");
            }
            case 6: {
                stringValue = v.getString();
                break;
            }
            case 5: {
                stringValue = DateField.dateToString(v.getDate().getTime());
                break;
            }
            case 4: {
                stringValue = DoubleField.doubleToString(v.getDouble());
                break;
            }
            case 3: {
                stringValue = LongField.longToString(v.getLong());
                break;
            }
            case 7: {
                Name n = this.session.getQName(v.getString());
                stringValue = this.nsMappings.translatePropertyName(n);
                break;
            }
            case 8: {
                Path p = this.session.getQPath(v.getString());
                stringValue = this.npResolver.getJCRPath(p);
                break;
            }
            case 9: {
                stringValue = v.getString();
                break;
            }
            case 1: {
                stringValue = v.getString();
                break;
            }
            default: {
                throw new InvalidQueryException("Unsupported property type " + PropertyType.nameFromValue((int)v.getType()));
            }
        }
        final int operator = node.getOperator();
        return ((DynamicOperandImpl)node.getOperand1()).accept(new DefaultTraversingQOMTreeVisitor(){

            @Override
            public Object visit(PropertyValueImpl node, Object data) throws Exception {
                String propName = JQOM2LuceneQueryBuilder.this.npResolver.getJCRName(node.getPropertyQName());
                String text = FieldNames.createNamedValue(propName, stringValue);
                switch (operator) {
                    case 201: {
                        return new TermQuery(new Term(FieldNames.PROPERTIES, text));
                    }
                    case 205: {
                        Term lower = new Term(FieldNames.PROPERTIES, text);
                        Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, "\uffff"));
                        return new RangeQuery(lower, upper, false);
                    }
                    case 206: {
                        Term lower = new Term(FieldNames.PROPERTIES, text);
                        Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, "\uffff"));
                        return new RangeQuery(lower, upper, true);
                    }
                    case 203: {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, ""));
                        Term upper = new Term(FieldNames.PROPERTIES, text);
                        return new RangeQuery(lower, upper, false);
                    }
                    case 204: {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(propName, ""));
                        Term upper = new Term(FieldNames.PROPERTIES, text);
                        return new RangeQuery(lower, upper, true);
                    }
                    case 207: {
                        if (stringValue.equals("%")) {
                            return new MatchAllQuery(propName);
                        }
                        return new WildcardQuery(FieldNames.PROPERTIES, propName, stringValue);
                    }
                    case 202: {
                        MatchAllQuery all = new MatchAllQuery(propName);
                        BooleanQuery b = new BooleanQuery();
                        b.add(all, BooleanClause.Occur.SHOULD);
                        b.add(new TermQuery(new Term(FieldNames.PROPERTIES, text)), BooleanClause.Occur.MUST_NOT);
                        return b;
                    }
                }
                throw new InvalidQueryException("Unknown operator " + operator);
            }

            @Override
            public Object visit(LengthImpl node, Object data) throws Exception {
                return super.visit(node, data);
            }

            @Override
            public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
                throw new UnsupportedOperationException("Not yet implemented");
            }

            @Override
            public Object visit(NodeNameImpl node, Object data) throws Exception {
                throw new UnsupportedOperationException("Not yet implemented");
            }

            @Override
            public Object visit(FullTextSearchScoreImpl node, Object data) throws Exception {
                throw new UnsupportedOperationException("Not yet implemented");
            }

            @Override
            public Object visit(UpperCaseImpl node, Object data) throws Exception {
                Object obj = super.visit(node, data);
                if (obj instanceof Transformable) {
                    ((Transformable)obj).setTransformation(2);
                    return obj;
                }
                if (obj instanceof TermQuery) {
                    return this.transformTermQuery((TermQuery)obj, true);
                }
                throw new InvalidQueryException("upper-case not supported on operand " + node.getOperand().getClass().getName());
            }

            @Override
            public Object visit(LowerCaseImpl node, Object data) throws Exception {
                Object obj = super.visit(node, data);
                if (obj instanceof Transformable) {
                    ((Transformable)obj).setTransformation(1);
                    return obj;
                }
                if (obj instanceof TermQuery) {
                    return this.transformTermQuery((TermQuery)obj, false);
                }
                throw new InvalidQueryException("lower-case not supported on operand " + node.getOperand().getClass().getName());
            }

            private Query transformTermQuery(TermQuery query, boolean toUpper) throws InvalidQueryException {
                if (query.getTerm().field() == FieldNames.PROPERTIES) {
                    if (toUpper) {
                        return new CaseTermQuery.Upper(query.getTerm());
                    }
                    return new CaseTermQuery.Lower(query.getTerm());
                }
                throw new InvalidQueryException("Upper/LowerCase not supported on field " + query.getTerm().field());
            }
        }, data);
    }

    @Override
    public Object visit(DescendantNodeImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(DescendantNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(EquiJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(FullTextSearchImpl node, Object data) throws Exception {
        String fieldname;
        if (node.getPropertyName() == null) {
            fieldname = FieldNames.FULLTEXT;
        } else {
            Name propName = node.getPropertyQName();
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
            tmp.append(":").append("FULL:");
            tmp.append(propName.getLocalName());
            fieldname = tmp.toString();
        }
        QueryParser parser = new QueryParser(fieldname, this.analyzer, this.synonymProvider);
        parser.setOperator(1);
        StringBuffer query = new StringBuffer();
        String textsearch = node.getFullTextSearchExpression();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            if (textsearch.charAt(i) == '\\') {
                if (escaped) {
                    query.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (textsearch.charAt(i) == '\'') {
                if (escaped) {
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
                continue;
            }
            if (escaped) {
                query.append('\\');
                escaped = false;
            }
            query.append(textsearch.charAt(i));
        }
        return parser.parse(query.toString());
    }

    @Override
    public Object visit(FullTextSearchScoreImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(JoinImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(LengthImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(LiteralImpl node, Object data) {
        return node.getValue();
    }

    @Override
    public Object visit(LowerCaseImpl node, Object data) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(NodeLocalNameImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(NodeNameImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(NotImpl node, Object data) throws Exception {
        Query c = (Query)((ConstraintImpl)node.getConstraint()).accept(this, data);
        return new NotQuery(c);
    }

    @Override
    public Object visit(OrderingImpl node, Object data) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(OrImpl node, Object data) throws Exception {
        BooleanQuery b = new BooleanQuery();
        b.add((Query)((ConstraintImpl)node.getConstraint1()).accept(this, data), BooleanClause.Occur.SHOULD);
        b.add((Query)((ConstraintImpl)node.getConstraint2()).accept(this, data), BooleanClause.Occur.SHOULD);
        return b;
    }

    @Override
    public Object visit(PropertyExistenceImpl node, Object data) throws Exception {
        String propName = this.npResolver.getJCRName(node.getPropertyQName());
        return new MatchAllQuery(propName);
    }

    @Override
    public Object visit(PropertyValueImpl node, Object data) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(QueryObjectModelTree node, Object data) throws Exception {
        Query source = (Query)node.getSource().accept(this, data);
        if (node.getConstraint() == null) {
            return source;
        }
        Query constraint = (Query)node.getConstraint().accept(this, data);
        BooleanQuery b = new BooleanQuery();
        b.add(source, BooleanClause.Occur.MUST);
        b.add(constraint, BooleanClause.Occur.MUST);
        return b;
    }

    @Override
    public Object visit(SameNodeImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(SameNodeJoinConditionImpl node, Object data) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Object visit(SelectorImpl node, Object data) throws Exception {
        Query q;
        Term t;
        ArrayList<Term> terms = new ArrayList<Term>();
        String mixinTypesField = this.npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
        String primaryTypeField = this.npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        NodeType base = null;
        try {
            base = ntMgr.getNodeType(this.session.getJCRName(node.getNodeTypeQName()));
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (base != null && base.isMixin()) {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.npResolver.getJCRName(node.getNodeTypeQName())));
            terms.add(t);
        } else {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.npResolver.getJCRName(node.getNodeTypeQName())));
            terms.add(t);
        }
        if (base != null) {
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                Name n = this.session.getQName(nt.getName());
                String ntName = this.nsMappings.translatePropertyName(n);
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        if (terms.size() == 1) {
            q = new TermQuery((Term)terms.get(0));
        } else {
            BooleanQuery b = new BooleanQuery();
            Iterator it = terms.iterator();
            while (it.hasNext()) {
                b.add(new TermQuery((Term)it.next()), BooleanClause.Occur.SHOULD);
            }
            q = b;
        }
        this.selectors.put(node.getSelectorQName(), q);
        return q;
    }

    @Override
    public Object visit(UpperCaseImpl node, Object data) throws Exception {
        throw new IllegalStateException();
    }
}

