/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;

public class NamePathResolverImpl
extends DefaultNamePathResolver {
    private static Logger log = CommonSLF4JLogger.getLogger(NamePathResolverImpl.class);
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();

    private NamePathResolverImpl(NameResolver nResolver, PathResolver pResolver) {
        super(nResolver, pResolver);
    }

    public static NamePathResolver create(NamespaceMappings nsMappings) {
        NameResolverImpl nResolver = new NameResolverImpl(nsMappings);
        ParsingPathResolver pResolver = new ParsingPathResolver(PATH_FACTORY, nResolver);
        return new NamePathResolverImpl(nResolver, pResolver);
    }

    private static class NameResolverImpl
    implements NameResolver {
        private final NamespaceResolver resolver;

        public NameResolverImpl(NamespaceResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Name getQName(String name) throws IllegalNameException, NamespaceException {
            return NameParser.parse(name, this.resolver, NAME_FACTORY);
        }

        @Override
        public String getJCRName(Name name) throws NamespaceException {
            String uri = name.getNamespaceURI();
            if (this.resolver.getPrefix(uri).length() == 0) {
                return name.getLocalName();
            }
            return this.resolver.getPrefix(uri) + ":" + name.getLocalName();
        }
    }
}

