/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;

class ParentAxisQuery
extends Query {
    private static final Float DEFAULT_SCORE = new Float(1.0f);
    private final Query contextQuery;
    private final String nameTest;
    private Scorer contextScorer;

    ParentAxisQuery(Query context, String nameTest) {
        this.contextQuery = context;
        this.nameTest = nameTest;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new ParentAxisWeight(searcher);
    }

    @Override
    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new ParentAxisQuery(cQuery, this.nameTest);
    }

    @Override
    public String toString(String field) {
        return "ParentAxisQuery";
    }

    private class ParentAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final HierarchyResolver hResolver;
        private BitSet hits;
        private final Map scores;
        private int nextDoc;

        protected ParentAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver resolver) {
            super(similarity);
            this.scores = new HashMap();
            this.nextDoc = -1;
            this.reader = reader;
            this.hResolver = resolver;
        }

        @Override
        public boolean next() throws IOException {
            this.calculateParent();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        @Override
        public int doc() {
            return this.nextDoc;
        }

        @Override
        public float score() throws IOException {
            Float score = (Float)this.scores.get(new Integer(this.nextDoc));
            if (score == null) {
                score = DEFAULT_SCORE;
            }
            return score.floatValue();
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.calculateParent();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateParent() throws IOException {
            if (this.hits == null) {
                this.hits = new BitSet(this.reader.maxDoc());
                final IOException[] ex = new IOException[1];
                ParentAxisQuery.this.contextScorer.score(new HitCollector(){

                    @Override
                    public void collect(int doc, float score) {
                        try {
                            doc = ParentAxisScorer.this.hResolver.getParent(doc);
                            if (doc != -1) {
                                ParentAxisScorer.this.hits.set(doc);
                                if (score != DEFAULT_SCORE.floatValue()) {
                                    ParentAxisScorer.this.scores.put(new Integer(doc), new Float(score));
                                }
                            }
                        }
                        catch (IOException e) {
                            ex[0] = e;
                        }
                    }
                });
                if (ex[0] != null) {
                    throw ex[0];
                }
                if (ParentAxisQuery.this.nameTest != null) {
                    try (TermDocs tDocs = this.reader.termDocs(new Term(FieldNames.LABEL, ParentAxisQuery.this.nameTest));){
                        int i = this.hits.nextSetBit(0);
                        while (i >= 0) {
                            if (!tDocs.skipTo(i)) {
                                this.hits.clear(i);
                            }
                            i = this.hits.nextSetBit(i + 1);
                        }
                    }
                }
            }
        }
    }

    private class ParentAxisWeight
    implements Weight {
        private final Searcher searcher;

        private ParentAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return ParentAxisQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            ParentAxisQuery.this.contextScorer = ParentAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            HierarchyResolver resolver = (HierarchyResolver)((Object)reader);
            return new ParentAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

