/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.document.Field;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.MultiReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.search.Hits;
import com.kingdee.bos.ctrl.lucene.search.IndexSearcher;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.SortField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.query.AbstractQueryHandler;
import org.apache.jackrabbit.core.query.DefaultQueryNodeFactory;
import org.apache.jackrabbit.core.query.ExecutablePreparedQuery;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.AggregateRule;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.DefaultHTMLExcerpt;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FileBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationEntityResolver;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTextExtractor;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NodeIndexer;
import org.apache.jackrabbit.core.query.lucene.PooledTextExtractor;
import org.apache.jackrabbit.core.query.lucene.PreparedQueryImpl;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SharedFieldSortComparator;
import org.apache.jackrabbit.core.query.lucene.SpellChecker;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateIterator;
import org.apache.jackrabbit.extractor.DefaultTextExtractor;
import org.apache.jackrabbit.extractor.TextExtractor;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SearchIndex
extends AbstractQueryHandler {
    public static final List VALID_SYSTEM_INDEX_NODE_TYPE_NAMES = Collections.unmodifiableList(Arrays.asList(NameConstants.NT_CHILDNODEDEFINITION, NameConstants.NT_FROZENNODE, NameConstants.NT_NODETYPE, NameConstants.NT_PROPERTYDEFINITION, NameConstants.NT_VERSION, NameConstants.NT_VERSIONEDCHILD, NameConstants.NT_VERSIONHISTORY, NameConstants.NT_VERSIONLABELS, NameConstants.REP_NODETYPES, NameConstants.REP_SYSTEM, NameConstants.REP_VERSIONSTORAGE, NameConstants.NT_BASE, NameConstants.MIX_REFERENCEABLE));
    private static final DefaultQueryNodeFactory DEFAULT_QUERY_NODE_FACTORY = new DefaultQueryNodeFactory(VALID_SYSTEM_INDEX_NODE_TYPE_NAMES);
    private static final Logger log = CommonSLF4JLogger.getLogger(SearchIndex.class);
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_EXTRACTOR_POOL_SIZE = 0;
    public static final int DEFAULT_EXTRACTOR_BACK_LOG = 100;
    public static final long DEFAULT_EXTRACTOR_TIMEOUT = 100L;
    private MultiIndex index;
    private JackrabbitAnalyzer analyzer;
    private String textFilterClasses = DefaultTextExtractor.class.getName();
    private TextExtractor extractor;
    private NamespaceMappings nsMappings;
    private NamePathResolver npResolver;
    private String path;
    private int minMergeDocs = 100;
    private int volatileIdleTime = 3;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int extractorPoolSize = 0;
    private int extractorBackLog = 100;
    private long extractorTimeout = 100L;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = true;
    private boolean forceConsistencyCheck = false;
    private boolean consistencyCheckEnabled = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private int resultFetchSize = Integer.MAX_VALUE;
    private boolean supportHighlighting = false;
    private Class excerptProviderClass = DefaultHTMLExcerpt.class;
    private String indexingConfigPath;
    private Element indexingConfiguration;
    private IndexingConfiguration indexingConfig;
    private Class indexingConfigurationClass = IndexingConfigurationImpl.class;
    private Class synonymProviderClass;
    private SynonymProvider synProvider;
    private String synonymProviderConfigPath;
    private FileSystem synonymProviderConfigFs;
    private IndexFormatVersion indexFormatVersion;
    private Class spellCheckerClass;
    private SpellChecker spellChecker;
    private boolean closed = false;

    public SearchIndex() {
        this.analyzer = new JackrabbitAnalyzer();
    }

    @Override
    protected void doInit() throws IOException {
        QueryHandlerContext context = this.getContext();
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        HashSet<NodeId> excludedIDs = new HashSet<NodeId>();
        if (context.getExcludedNodeId() != null) {
            excludedIDs.add(context.getExcludedNodeId());
        }
        this.extractor = this.createTextExtractor();
        this.synProvider = this.createSynonymProvider();
        File indexDir = new File(this.path);
        if (context.getParentHandler() instanceof SearchIndex) {
            SearchIndex sysIndex = (SearchIndex)context.getParentHandler();
            this.nsMappings = sysIndex.getNamespaceMappings();
        } else {
            File mapFile = new File(indexDir, NS_MAPPING_FILE);
            this.nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(context.getNamespaceRegistry());
        }
        this.npResolver = NamePathResolverImpl.create(this.nsMappings);
        this.indexingConfig = this.createIndexingConfiguration(this.nsMappings);
        this.analyzer.setIndexingConfig(this.indexingConfig);
        this.index = new MultiIndex(indexDir, this, excludedIDs, this.nsMappings);
        if (this.index.numDocs() == 0) {
            this.index.createInitialIndex(context.getItemStateManager(), context.getRootId());
        }
        if (this.consistencyCheckEnabled && (this.index.getRedoLogApplied() || this.forceConsistencyCheck)) {
            log.info("Running consistency check...");
            try {
                ConsistencyCheck check = ConsistencyCheck.run(this.index, context.getItemStateManager());
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info("No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info(err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to run consistency check on index: " + e);
            }
        }
        this.spellChecker = this.createSpellChecker();
        log.info("Index initialized: {} Version: {}", new Object[]{this.path, this.index.getIndexFormatVersion()});
    }

    @Override
    public void addNode(NodeState node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    @Override
    public void deleteNode(NodeId id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    @Override
    public void updateNodes(NodeIdIterator remove, NodeStateIterator add) throws RepositoryException, IOException {
        this.checkOpen();
        final HashMap aggregateRoots = new HashMap();
        final HashSet removedNodeIds = new HashSet();
        final HashSet addedNodeIds = new HashSet();
        this.index.update((Iterator)new AbstractIteratorDecorator(remove){

            public Object next() {
                NodeId nodeId = (NodeId)super.next();
                removedNodeIds.add(nodeId);
                return nodeId.getUUID();
            }
        }, (Iterator)new AbstractIteratorDecorator(add){

            public Object next() {
                NodeState state = (NodeState)super.next();
                if (state == null) {
                    return null;
                }
                addedNodeIds.add(state.getNodeId());
                removedNodeIds.remove(state.getNodeId());
                Document doc = null;
                try {
                    doc = SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    SearchIndex.this.retrieveAggregateRoot(state, aggregateRoots);
                }
                catch (RepositoryException e) {
                    log.warn("Exception while creating document for node: " + state.getNodeId() + ": " + e.toString());
                }
                return doc;
            }
        });
        aggregateRoots.keySet().removeAll(addedNodeIds);
        this.retrieveAggregateRoot(removedNodeIds, aggregateRoots);
        if (aggregateRoots.size() > 0) {
            this.index.update((Iterator)new AbstractIteratorDecorator(aggregateRoots.keySet().iterator()){

                public Object next() {
                    return ((NodeId)super.next()).getUUID();
                }
            }, (Iterator)new AbstractIteratorDecorator(aggregateRoots.values().iterator()){

                public Object next() {
                    NodeState state = (NodeState)super.next();
                    try {
                        return SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception while creating document for node: " + state.getNodeId() + ": " + e.toString());
                        return null;
                    }
                }
            });
        }
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionImpl session, ItemManager itemMgr, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), statement, language, this.getQueryNodeFactory());
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    @Override
    public ExecutablePreparedQuery createExecutablePreparedQuery(SessionImpl session, ItemManager itemMgr, QueryObjectModelTree qomTree) throws InvalidQueryException {
        PreparedQueryImpl query = new PreparedQueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), qomTree);
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return DEFAULT_QUERY_NODE_FACTORY;
    }

    @Override
    public void close() {
        if (this.synonymProviderConfigFs != null) {
            try {
                this.synonymProviderConfigFs.close();
            }
            catch (FileSystemException e) {
                log.warn("Exception while closing FileSystem", (Throwable)e);
            }
        }
        if (this.extractor instanceof PooledTextExtractor) {
            ((PooledTextExtractor)this.extractor).shutdown();
        }
        if (this.spellChecker != null) {
            this.spellChecker.close();
        }
        this.index.close();
        this.getContext().destroy();
        this.closed = true;
        log.info("Index closed: " + this.path);
    }

    public QueryHits executeQuery(AbstractQueryImpl queryImpl, Query query, Name[] orderProps, boolean[] orderSpecs) throws IOException {
        this.checkOpen();
        SortField[] sortFields = this.createSortFields(orderProps, orderSpecs);
        IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
        IndexSearcher searcher = new IndexSearcher(reader);
        Hits hits = sortFields.length > 0 ? searcher.search(query, new Sort(sortFields)) : searcher.search(query);
        return new QueryHits(hits, reader);
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep;
        try {
            ep = (ExcerptProvider)this.excerptProviderClass.newInstance();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        ep.init(query, this);
        return ep;
    }

    public Analyzer getTextAnalyzer() {
        return this.analyzer;
    }

    public TextExtractor getTextExtractor() {
        return this.extractor;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.indexingConfig;
    }

    public SynonymProvider getSynonymProvider() {
        if (this.synProvider != null) {
            return this.synProvider;
        }
        QueryHandler handler = this.getContext().getParentHandler();
        if (handler instanceof SearchIndex) {
            return ((SearchIndex)handler).getSynonymProvider();
        }
        return null;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    public IndexFormatVersion getIndexFormatVersion() {
        if (this.indexFormatVersion == null) {
            SearchIndex parent;
            this.indexFormatVersion = this.getContext().getParentHandler() instanceof SearchIndex ? ((parent = (SearchIndex)this.getContext().getParentHandler()).getIndexFormatVersion().getVersion() < this.index.getIndexFormatVersion().getVersion() ? parent.getIndexFormatVersion() : this.index.getIndexFormatVersion()) : this.index.getIndexFormatVersion();
        }
        return this.indexFormatVersion;
    }

    protected IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        QueryHandler parentHandler = this.getContext().getParentHandler();
        CachingMultiIndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex && includeSystemIndex) {
            parentReader = ((SearchIndex)parentHandler).index.getIndexReader();
        }
        CachingMultiIndexReader reader = this.index.getIndexReader();
        if (parentReader != null) {
            CachingMultiIndexReader[] readers = new CachingMultiIndexReader[]{reader, parentReader};
            return new CombinedIndexReader(readers);
        }
        return reader;
    }

    protected SortField[] createSortFields(Name[] orderProps, boolean[] orderSpecs) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            String prop = null;
            if (NameConstants.JCR_SCORE.equals(orderProps[i])) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            try {
                prop = this.npResolver.getJCRName(orderProps[i]);
            }
            catch (NamespaceException namespaceException) {
                // empty catch block
            }
            sortFields.add(new SortField(prop, SharedFieldSortComparator.PROPERTIES, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.extractor);
        indexer.setSupportHighlighting(this.supportHighlighting);
        indexer.setIndexingConfiguration(this.indexingConfig);
        indexer.setIndexFormatVersion(indexFormatVersion);
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc);
        return doc;
    }

    protected MultiIndex getIndex() {
        return this.index;
    }

    protected TextExtractor createTextExtractor() {
        Object txtExtr = new JackrabbitTextExtractor(this.textFilterClasses);
        if (this.extractorPoolSize > 0) {
            txtExtr = new PooledTextExtractor((TextExtractor)txtExtr, this.extractorPoolSize, this.extractorBackLog, this.extractorTimeout);
        }
        return txtExtr;
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        Element docElement = this.getIndexingConfigurationDOM();
        if (docElement == null) {
            return null;
        }
        try {
            IndexingConfiguration idxCfg = (IndexingConfiguration)this.indexingConfigurationClass.newInstance();
            idxCfg.init(docElement, this.getContext(), namespaceMappings);
            return idxCfg;
        }
        catch (Exception e) {
            log.warn("Exception initializing indexing configuration from: " + this.indexingConfigPath, (Throwable)e);
            log.warn(this.indexingConfigPath + " ignored.");
            return null;
        }
    }

    protected SynonymProvider createSynonymProvider() {
        SynonymProvider sp = null;
        if (this.synonymProviderClass != null) {
            try {
                sp = (SynonymProvider)this.synonymProviderClass.newInstance();
                sp.initialize(this.createSynonymProviderConfigResource());
            }
            catch (Exception e) {
                log.warn("Exception initializing synonym provider: " + this.synonymProviderClass, (Throwable)e);
                sp = null;
            }
        }
        return sp;
    }

    protected FileSystemResource createSynonymProviderConfigResource() throws FileSystemException, IOException {
        if (this.synonymProviderConfigPath != null) {
            FileSystemResource fsr;
            if (this.synonymProviderConfigPath.endsWith("/")) {
                throw new FileSystemException("Invalid synonymProviderConfigPath: " + this.synonymProviderConfigPath);
            }
            FileSystem fs = this.getContext().getFileSystem();
            if (fs == null) {
                fs = new LocalFileSystem();
                int lastSeparator = this.synonymProviderConfigPath.lastIndexOf(47);
                if (lastSeparator != -1) {
                    File root = new File(this.path, this.synonymProviderConfigPath.substring(0, lastSeparator));
                    ((LocalFileSystem)fs).setRoot(root.getCanonicalFile());
                    fs.init();
                    fsr = new FileSystemResource(fs, this.synonymProviderConfigPath.substring(lastSeparator + 1));
                } else {
                    ((LocalFileSystem)fs).setPath(this.path);
                    fs.init();
                    fsr = new FileSystemResource(fs, this.synonymProviderConfigPath);
                }
                this.synonymProviderConfigFs = fs;
            } else {
                fsr = new FileSystemResource(fs, this.synonymProviderConfigPath);
            }
            return fsr;
        }
        return null;
    }

    protected SpellChecker createSpellChecker() {
        SpellChecker spCheck = null;
        if (this.spellCheckerClass != null) {
            try {
                spCheck = (SpellChecker)this.spellCheckerClass.newInstance();
                spCheck.init(this);
            }
            catch (Exception e) {
                log.warn("Exception initializing spell checker: " + this.spellCheckerClass, (Throwable)e);
            }
        }
        return spCheck;
    }

    protected Element getIndexingConfigurationDOM() {
        if (this.indexingConfiguration != null) {
            return this.indexingConfiguration;
        }
        if (this.indexingConfigPath == null) {
            return null;
        }
        File config = new File(this.indexingConfigPath);
        if (!config.exists()) {
            log.warn("File does not exist: " + this.indexingConfigPath);
            return null;
        }
        if (!config.canRead()) {
            log.warn("Cannot read file: " + this.indexingConfigPath);
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new IndexingConfigurationEntityResolver());
            this.indexingConfiguration = builder.parse(config).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            log.warn("Unable to create XML parser", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Exception parsing " + this.indexingConfigPath, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn("Exception parsing " + this.indexingConfigPath, (Throwable)e);
        }
        return this.indexingConfiguration;
    }

    protected void mergeAggregatedNodeIndexes(NodeState state, Document doc) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeState[] aggregates = aggregateRules[i].getAggregatedNodeStates(state);
                    if (aggregates == null) continue;
                    for (int j = 0; j < aggregates.length; ++j) {
                        Document aDoc = this.createDocument(aggregates[j], this.getNamespaceMappings(), this.index.getIndexFormatVersion());
                        Field[] fulltextFields = aDoc.getFields(FieldNames.FULLTEXT);
                        if (fulltextFields == null) continue;
                        for (int k = 0; k < fulltextFields.length; ++k) {
                            doc.add(fulltextFields[k]);
                        }
                        doc.add(new Field(FieldNames.AGGREGATED_NODE_UUID, aggregates[j].getNodeId().getUUID().toString(), Field.Store.NO, Field.Index.NO_NORMS));
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Exception while building indexing aggregate for node with UUID: " + state.getNodeId().getUUID(), (Throwable)e);
            }
        }
    }

    protected void retrieveAggregateRoot(NodeState state, Map map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeState root = aggregateRules[i].getAggregateRoot(state);
                    if (root == null) continue;
                    map.put(root.getNodeId(), root);
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Unable to get aggregate root for " + state.getNodeId().getUUID(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveAggregateRoot(Set removedNodeIds, Map map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            int found = 0;
            long time = System.currentTimeMillis();
            try (CachingMultiIndexReader reader = this.index.getIndexReader();){
                Term aggregateUUIDs = new Term(FieldNames.AGGREGATED_NODE_UUID, "");
                try (TermDocs tDocs = ((IndexReader)reader).termDocs();){
                    ItemStateManager ism = this.getContext().getItemStateManager();
                    for (NodeId id : removedNodeIds) {
                        aggregateUUIDs = aggregateUUIDs.createTerm(id.getUUID().toString());
                        tDocs.seek(aggregateUUIDs);
                        while (tDocs.next()) {
                            Document doc = reader.document(tDocs.doc());
                            String uuid = doc.get(FieldNames.UUID);
                            NodeId nId = new NodeId(UUID.fromString(uuid));
                            map.put(nId, ism.getItemState(nId));
                            ++found;
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception while retrieving aggregate roots", (Throwable)e);
            }
            time = System.currentTimeMillis() - time;
            log.debug("Retrieved {} aggregate roots in {} ms.", (Object)new Integer(found), (Object)new Long(time));
        }
    }

    public void setAnalyzer(String analyzerClassName) {
        try {
            Class<?> analyzerClass = Class.forName(analyzerClassName);
            this.analyzer.setDefaultAnalyzer((Analyzer)analyzerClass.newInstance());
        }
        catch (Exception e) {
            log.warn("Invalid Analyzer class: " + analyzerClassName, (Throwable)e);
        }
    }

    public String getAnalyzer() {
        return this.analyzer.getClass().getName();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setTextFilterClasses(String filterClasses) {
        this.textFilterClasses = filterClasses;
    }

    public String getTextFilterClasses() {
        return this.textFilterClasses;
    }

    public void setResultFetchSize(int size) {
        this.resultFetchSize = size;
    }

    public int getResultFetchSize() {
        return this.resultFetchSize;
    }

    public void setExtractorPoolSize(int numThreads) {
        if (numThreads < 0) {
            numThreads = 0;
        }
        this.extractorPoolSize = numThreads;
    }

    public int getExtractorPoolSize() {
        return this.extractorPoolSize;
    }

    public void setExtractorBackLogSize(int backLog) {
        this.extractorBackLog = backLog;
    }

    public int getExtractorBackLogSize() {
        return this.extractorBackLog;
    }

    public void setExtractorTimeout(long timeout) {
        this.extractorTimeout = timeout;
    }

    public long getExtractorTimeout() {
        return this.extractorTimeout;
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public boolean getSupportHighlighting() {
        return this.supportHighlighting;
    }

    public void setExcerptProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (ExcerptProvider.class.isAssignableFrom(clazz)) {
                this.excerptProviderClass = clazz;
            } else {
                log.warn("Invalid value for excerptProviderClass, {} does not implement ExcerptProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for excerptProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getExcerptProviderClass() {
        return this.excerptProviderClass.getName();
    }

    public void setIndexingConfiguration(String path) {
        this.indexingConfigPath = path;
    }

    public String getIndexingConfiguration() {
        return this.indexingConfigPath;
    }

    public void setIndexingConfigurationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (IndexingConfiguration.class.isAssignableFrom(clazz)) {
                this.indexingConfigurationClass = clazz;
            } else {
                log.warn("Invalid value for indexingConfigurationClass, {} does not implement IndexingConfiguration interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for indexingConfigurationClass, class {} not found.", (Object)className);
        }
    }

    public String getIndexingConfigurationClass() {
        return this.indexingConfigurationClass.getName();
    }

    public void setSynonymProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SynonymProvider.class.isAssignableFrom(clazz)) {
                this.synonymProviderClass = clazz;
            } else {
                log.warn("Invalid value for synonymProviderClass, {} does not implement SynonymProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for synonymProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getSynonymProviderClass() {
        return this.synonymProviderClass != null ? this.synonymProviderClass.getName() : null;
    }

    public void setSpellCheckerClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SpellChecker.class.isAssignableFrom(clazz)) {
                this.spellCheckerClass = clazz;
            } else {
                log.warn("Invalid value for spellCheckerClass, {} does not implement SpellChecker interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for spellCheckerClass, class {} not found.", (Object)className);
        }
    }

    public String getSpellCheckerClass() {
        return this.spellCheckerClass != null ? this.spellCheckerClass.getName() : null;
    }

    public void setEnableConsistencyCheck(boolean b) {
        this.consistencyCheckEnabled = b;
    }

    public boolean getEnableConsistencyCheck() {
        return this.consistencyCheckEnabled;
    }

    public void setSynonymProviderConfigPath(String path) {
        this.synonymProviderConfigPath = path;
    }

    public String getSynonymProviderConfigPath() {
        return this.synonymProviderConfigPath;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver,
    MultiIndexReader {
        private final CachingMultiIndexReader[] subReaders;
        private int[] starts;

        public CombinedIndexReader(CachingMultiIndexReader[] indexReaders) throws IOException {
            super(indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        @Override
        public int getParent(int n) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumber(this);
        }

        @Override
        public IndexReader[] getIndexReaders() {
            IndexReader[] readers = new IndexReader[this.subReaders.length];
            System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
            return readers;
        }

        private int readerIndex(int n) {
            int lo = 0;
            int hi = this.subReaders.length - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombinedIndexReader) {
                CombinedIndexReader other = (CombinedIndexReader)obj;
                return Arrays.equals(this.subReaders, other.subReaders);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                hash = 31 * hash + this.subReaders[i].hashCode();
            }
            return hash;
        }

        @Override
        public ForeignSegmentDocId createDocId(UUID uuid) throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                ForeignSegmentDocId doc = subReader.createDocId(uuid);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        public int getDocumentNumber(ForeignSegmentDocId docId) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                int realDoc = subReader.getDocumentNumber(docId);
                if (realDoc < 0) continue;
                return realDoc;
            }
            return -1;
        }
    }
}

