/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.FilterIndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import java.io.IOException;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;

class SharedIndexReader
extends FilterIndexReader {
    private boolean closeRequested = false;
    private final Map clients = new IdentityHashMap();

    public SharedIndexReader(CachingIndexReader in) {
        super(in);
    }

    long getCreationTick() {
        return this.getBase().getCreationTick();
    }

    public DocId getParent(int n, BitSet deleted) throws IOException {
        return this.getBase().getParent(n, deleted);
    }

    public synchronized void addClient(Object client) {
        this.clients.put(client, client);
    }

    public synchronized void removeClient(Object client) throws IOException {
        this.clients.remove(client);
        if (this.clients.isEmpty() && this.closeRequested) {
            super.doClose();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        if (this.clients.isEmpty()) {
            super.doClose();
        } else {
            this.closeRequested = true;
        }
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        return this.in.termDocs(term);
    }

    public CachingIndexReader getBase() {
        return (CachingIndexReader)this.in;
    }
}

