/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.hits;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.hits.ArrayHits;
import org.apache.jackrabbit.core.query.lucene.hits.BitSetHits;
import org.apache.jackrabbit.core.query.lucene.hits.Hits;
import org.slf4j.Logger;

public class AdaptingHits
implements Hits {
    private static final Logger log = CommonSLF4JLogger.getLogger(AdaptingHits.class);
    private static final int DEFAULT_THRESHOLD = 2048;
    private Hits hits;
    private int maxDoc;
    private int docCount;
    private int threshold;

    public AdaptingHits() {
        this(2048);
    }

    public AdaptingHits(int threshold) {
        this.threshold = threshold;
        this.hits = new ArrayHits();
        this.maxDoc = 0;
    }

    @Override
    public int next() throws IOException {
        return this.hits.next();
    }

    @Override
    public void set(int doc) {
        int intArraySize;
        int bitSetSize;
        this.hits.set(doc);
        ++this.docCount;
        if (doc > this.maxDoc) {
            this.maxDoc = doc;
        }
        if (this.docCount > this.threshold && this.hits instanceof ArrayHits && (bitSetSize = this.maxDoc / 8) < (intArraySize = this.docCount * 4)) {
            log.debug("BitSet is smaller than int[]: " + bitSetSize + " vs " + intArraySize);
            BitSetHits bitSetHits = new BitSetHits();
            int i = 0;
            while (i > -1) {
                try {
                    i = this.hits.next();
                    if (i <= -1) continue;
                    bitSetHits.set(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.hits = bitSetHits;
        }
    }

    @Override
    public int skipTo(int target) throws IOException {
        return this.hits.skipTo(target);
    }

    Hits getInternalHits() {
        return this.hits;
    }
}

