/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateStore;
import org.apache.jackrabbit.core.util.Dumpable;
import org.slf4j.Logger;

public class ItemStateMap
implements ItemStateStore,
Dumpable {
    private static Logger log = CommonSLF4JLogger.getLogger(ItemStateMap.class);
    protected final Map map;

    public ItemStateMap() {
        this(new HashMap());
    }

    protected ItemStateMap(Map map) {
        this.map = map;
    }

    @Override
    public boolean contains(ItemId id) {
        return this.map.containsKey(id);
    }

    @Override
    public ItemState get(ItemId id) {
        return (ItemState)this.map.get(id);
    }

    @Override
    public void put(ItemState state) {
        ItemId id = state.getId();
        if (this.map.containsKey(id)) {
            log.warn("overwriting map entry " + id);
        }
        this.map.put(id, state);
    }

    @Override
    public void remove(ItemId id) {
        this.map.remove(id);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("map entries:");
        ps.println();
        for (ItemId id : this.keySet()) {
            ItemState state = this.get(id);
            this.dumpItemState(id, state, ps);
        }
    }

    private void dumpItemState(ItemId id, ItemState state, PrintStream ps) {
        ps.print(state.isNode() ? "Node: " : "Prop: ");
        switch (state.getStatus()) {
            case 1: {
                ps.print("[existing]           ");
                break;
            }
            case 2: {
                ps.print("[existing, modified] ");
                break;
            }
            case 3: {
                ps.print("[existing, removed]  ");
                break;
            }
            case 4: {
                ps.print("[new]                ");
                break;
            }
            case 6: {
                ps.print("[stale, destroyed]   ");
                break;
            }
            case 5: {
                ps.print("[stale, modified]    ");
                break;
            }
            case 0: {
                ps.print("[undefined]          ");
            }
        }
        ps.println(id + " (" + state + ")");
    }
}

