/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateMap;
import org.apache.jackrabbit.core.state.ItemStateStore;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.state.NodeStateMerger;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;

public class SessionItemStateManager
implements UpdatableItemStateManager,
Dumpable,
NodeStateListener {
    private static Logger log = CommonSLF4JLogger.getLogger(SessionItemStateManager.class);
    private final UpdatableItemStateManager stateMgr;
    private CachingHierarchyManager hierMgr;
    private final ItemStateStore atticStore;
    private final ItemStateStore transientStore;
    private AtticItemStateManager attic;
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();

    public SessionItemStateManager(NodeId rootNodeId, LocalItemStateManager stateMgr, PathResolver resolver) {
        this.transientStore = new ItemStateMap();
        this.atticStore = new ItemStateMap();
        this.stateMgr = stateMgr;
        stateMgr.addListener(this);
        this.hierMgr = new CachingHierarchyManager(rootNodeId, this, resolver);
        this.addListener(this.hierMgr);
    }

    public HierarchyManager getHierarchyMgr() {
        return this.hierMgr;
    }

    public HierarchyManager getAtticAwareHierarchyMgr() {
        return new ZombieHierarchyManager(this.hierMgr, (ItemStateManager)this, this.getAttic());
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("SessionItemStateManager (" + this + ")");
        ps.println();
        ps.print("[transient] ");
        if (this.transientStore instanceof Dumpable) {
            ((Dumpable)((Object)this.transientStore)).dump(ps);
        } else {
            ps.println(this.transientStore.toString());
        }
        ps.println();
        ps.print("[attic]     ");
        if (this.atticStore instanceof Dumpable) {
            ((Dumpable)((Object)this.atticStore)).dump(ps);
        } else {
            ps.println(this.atticStore.toString());
        }
        ps.println();
    }

    @Override
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.atticStore.contains(id)) {
            return this.getTransientItemState(id);
        }
        if (this.transientStore.contains(id)) {
            return this.getTransientItemState(id);
        }
        if (this.stateMgr.hasItemState(id)) {
            return this.stateMgr.getItemState(id);
        }
        throw new NoSuchItemStateException(id.toString());
    }

    @Override
    public boolean hasItemState(ItemId id) {
        if (this.atticStore.contains(id)) {
            return this.transientStore.contains(id);
        }
        if (this.transientStore.contains(id)) {
            return true;
        }
        return this.stateMgr.hasItemState(id);
    }

    @Override
    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    @Override
    public boolean hasNodeReferences(NodeReferencesId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    @Override
    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    @Override
    public boolean inEditMode() {
        return this.stateMgr.inEditMode();
    }

    @Override
    public NodeState createNew(NodeId id, Name nodeTypeName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(id, nodeTypeName, parentId);
    }

    public NodeState createNew(NodeState transientState) throws IllegalStateException {
        NodeState persistentState = this.createNew(transientState.getNodeId(), transientState.getNodeTypeName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    @Override
    public PropertyState createNew(Name propName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(propName, parentId);
    }

    public PropertyState createNew(PropertyState transientState) throws IllegalStateException {
        PropertyState persistentState = this.createNew(transientState.getName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    @Override
    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    @Override
    public void destroy(ItemState state) throws IllegalStateException {
        this.stateMgr.destroy(state);
    }

    @Override
    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    @Override
    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        this.stateMgr.update();
    }

    @Override
    public void dispose() {
        this.disposeAllTransientItemStates();
        this.stateMgr.dispose();
    }

    public ItemState getTransientItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.transientStore.get(id);
        if (state != null) {
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasTransientItemState(ItemId id) {
        return this.transientStore.contains(id);
    }

    public boolean hasTransientItemStateInAttic(ItemId id) {
        return this.atticStore.contains(id);
    }

    public boolean hasAnyTransientItemStates() {
        return !this.transientStore.isEmpty();
    }

    public Iterator getDescendantTransientItemStates(NodeId parentId) throws InvalidItemStateException, RepositoryException {
        if (this.transientStore.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        List[] la = new List[10];
        try {
            for (ItemState state : this.transientStore.values()) {
                ArrayList<ItemState> list;
                int depth;
                try {
                    depth = this.hierMgr.getRelativeDepth(parentId, state.getId());
                }
                catch (ItemNotFoundException infe) {
                    String msg = state.getId() + ": the item seems to have been removed externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public Iterator getDescendantTransientItemStatesInAttic(NodeId parentId) {
        if (this.atticStore.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ZombieHierarchyManager zombieHierMgr = new ZombieHierarchyManager(this.hierMgr, (ItemStateManager)this, this.getAttic());
        List[] la = new List[10];
        try {
            for (ItemState state : this.atticStore.values()) {
                ArrayList<ItemState> list;
                int depth = zombieHierMgr.getRelativeDepth(parentId, state.getId());
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public boolean isItemStateInAttic(ItemId id) {
        return this.atticStore.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus) throws ItemStateException {
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(id, nodeTypeName, parentId, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeId id = overlayedState.getNodeId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(NodeId parentId, Name propName, int initialStatus) throws ItemStateException {
        PropertyId id = new PropertyId(parentId, propName);
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(id, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyId id = overlayedState.getPropertyId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    public void disconnectTransientItemState(ItemState state) {
        state.disconnect();
    }

    public void disposeTransientItemState(ItemState state) {
        state.discard();
        this.transientStore.remove(state.getId());
        state.onDisposed();
    }

    public void moveTransientItemStateToAttic(ItemState state) {
        this.transientStore.remove(state.getId());
        this.atticStore.put(state);
    }

    public void disposeTransientItemStateInAttic(ItemState state) {
        state.discard();
        this.atticStore.remove(state.getId());
        state.onDisposed();
    }

    public void disposeAllTransientItemStates() {
        ArrayList tmp = new ArrayList(this.transientStore.values());
        for (ItemState state : tmp) {
            this.disposeTransientItemState(state);
        }
        tmp = new ArrayList(this.atticStore.values());
        for (ItemState state : tmp) {
            this.disposeTransientItemStateInAttic(state);
        }
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    ItemStateManager getAttic() {
        if (this.attic == null) {
            this.attic = new AtticItemStateManager();
        }
        return this.attic;
    }

    @Override
    public void stateCreated(ItemState created) {
        ItemState transientState;
        ItemState visibleState = created;
        if (created.getContainer() != this && (transientState = this.transientStore.get(created.getId())) != null) {
            transientState.pull();
            transientState.setStatus(1);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateCreated(visibleState);
    }

    @Override
    public void stateModified(ItemState modified) {
        ItemState transientState;
        ItemState visibleState = modified;
        if (modified.getContainer() != this && (transientState = this.transientStore.get(modified.getId())) != null) {
            NodeStateMerger.MergeContext context;
            if (transientState.isNode() && !transientState.isStale() && NodeStateMerger.merge((NodeState)transientState, context = new NodeStateMerger.MergeContext(){

                @Override
                public boolean isAdded(ItemId id) {
                    ItemState is = SessionItemStateManager.this.transientStore.get(id);
                    return is != null && is.getStatus() == 4;
                }

                @Override
                public boolean isDeleted(ItemId id) {
                    return SessionItemStateManager.this.atticStore.contains(id);
                }
            })) {
                return;
            }
            transientState.setStatus(5);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateModified(visibleState);
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        ItemState transientState;
        ItemState visibleState = destroyed;
        if (destroyed.getContainer() != this && (transientState = this.transientStore.get(destroyed.getId())) != null) {
            transientState.setStatus(6);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateDestroyed(visibleState);
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        ItemState transientState;
        ItemState visibleState = discarded;
        if (discarded.getContainer() != this && (transientState = this.transientStore.get(discarded.getId())) != null) {
            transientState.setStatus(0);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateDiscarded(visibleState);
    }

    @Override
    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeAdded(state, name, index, id);
        }
    }

    @Override
    public void nodesReplaced(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodesReplaced(state);
        }
    }

    @Override
    public void nodeModified(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeModified(state);
        }
    }

    @Override
    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeRemoved(state, name, index, id);
        }
    }

    private class AtticItemStateManager
    implements ItemStateManager {
        private AtticItemStateManager() {
        }

        @Override
        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = SessionItemStateManager.this.atticStore.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException(id.toString());
        }

        @Override
        public boolean hasItemState(ItemId id) {
            return SessionItemStateManager.this.atticStore.contains(id);
        }

        @Override
        public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
            throw new ItemStateException("getNodeReferences() not implemented");
        }

        @Override
        public boolean hasNodeReferences(NodeReferencesId id) {
            return false;
        }
    }
}

