/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;

public class StateChangeDispatcher {
    private final Collection listeners = new CopyOnWriteArrayList();
    private final transient Collection nsListeners = new CopyOnWriteArrayList();

    public void addListener(ItemStateListener listener) {
        assert (!this.listeners.contains(listener));
        this.listeners.add(listener);
        if (listener instanceof NodeStateListener) {
            assert (!this.nsListeners.contains(listener));
            this.nsListeners.add(listener);
        }
    }

    public void removeListener(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            this.nsListeners.remove(listener);
        }
        this.listeners.remove(listener);
    }

    public void notifyStateCreated(ItemState created) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ItemStateListener)iter.next()).stateCreated(created);
        }
    }

    public void notifyStateModified(ItemState modified) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ItemStateListener)iter.next()).stateModified(modified);
        }
    }

    public void notifyStateDestroyed(ItemState destroyed) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ItemStateListener)iter.next()).stateDestroyed(destroyed);
        }
    }

    public void notifyStateDiscarded(ItemState discarded) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ItemStateListener)iter.next()).stateDiscarded(discarded);
        }
    }

    public void notifyNodeAdded(NodeState state, Name name, int index, NodeId id) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            ((NodeStateListener)iter.next()).nodeAdded(state, name, index, id);
        }
    }

    public void notifyNodesReplaced(NodeState state) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            ((NodeStateListener)iter.next()).nodesReplaced(state);
        }
    }

    public void notifyNodeModified(NodeState state) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            ((NodeStateListener)iter.next()).nodeModified(state);
        }
    }

    public void notifyNodeRemoved(NodeState state, Name name, int index, NodeId id) {
        Iterator iter = this.nsListeners.iterator();
        while (iter.hasNext()) {
            ((NodeStateListener)iter.next()).nodeRemoved(state, name, index, id);
        }
    }
}

