/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.uuid.Constants;
import org.slf4j.Logger;

public class BLOBInMemory
extends BLOBFileValue {
    private static Logger log = CommonSLF4JLogger.getLogger(BLOBInMemory.class);
    private static final String PREFIX = "0x";
    private byte[] data;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final BLOBInMemory EMPTY = new BLOBInMemory(EMPTY_BYTE_ARRAY);

    private BLOBInMemory(byte[] data) {
        this.data = data;
    }

    static BLOBInMemory getInstance(byte[] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return new BLOBInMemory(data);
    }

    static boolean isInstance(String s) {
        return s.startsWith(PREFIX);
    }

    static BLOBInMemory getInstance(String s) throws IllegalArgumentException {
        assert (s.startsWith(PREFIX));
        int len = (s = s.substring(PREFIX.length())).length();
        if (len % 2 != 0) {
            String msg = "unable to deserialize byte array " + s + " , length=" + s.length();
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] data = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                data[i] = (byte)(Character.digit(s.charAt(i + i), 16) << 4 | Character.digit(s.charAt(i + i + 1), 16));
            }
        }
        catch (NumberFormatException e) {
            String msg = "unable to deserialize byte array " + s;
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return BLOBInMemory.getInstance(data);
    }

    @Override
    public void delete(boolean pruneEmptyParentDirs) {
        this.data = EMPTY_BYTE_ARRAY;
    }

    @Override
    public void discard() {
        this.data = EMPTY_BYTE_ARRAY;
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(PREFIX.length() + 2 * this.data.length);
        buff.append(PREFIX);
        char[] hex = Constants.hexDigits;
        for (int i = 0; i < this.data.length; ++i) {
            int c = this.data[i] & 0xFF;
            buff.append(hex[c >> 4]);
            buff.append(hex[c & 0xF]);
        }
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBInMemory) {
            BLOBInMemory other = (BLOBInMemory)obj;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

