/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.version.VersionSelector;

public class DateVersionSelector
implements VersionSelector {
    private Calendar date = null;
    private boolean returnLatest = false;

    public DateVersionSelector(Calendar date) {
        this.date = date;
    }

    public DateVersionSelector(Calendar date, boolean returnLatest) {
        this.date = date;
        this.returnLatest = returnLatest;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public boolean isReturnLatest() {
        return this.returnLatest;
    }

    public void setReturnLatest(boolean returnLatest) {
        this.returnLatest = returnLatest;
    }

    @Override
    public Version select(VersionHistory versionHistory) throws RepositoryException {
        Version selected = null;
        if (this.date != null) {
            selected = DateVersionSelector.selectByDate(versionHistory, this.date);
        }
        if (selected == null && this.returnLatest) {
            selected = DateVersionSelector.selectByDate(versionHistory, null);
        }
        return selected;
    }

    public static Version selectByDate(VersionHistory history, Calendar date) throws RepositoryException {
        long time = date != null ? date.getTimeInMillis() : Long.MAX_VALUE;
        long latestDate = Long.MIN_VALUE;
        Version latestVersion = null;
        VersionIterator iter = history.getAllVersions();
        while (iter.hasNext()) {
            long c;
            Version v = iter.nextVersion();
            if (v.getPredecessors().length == 0 || (c = v.getCreated().getTimeInMillis()) <= latestDate || c > time) continue;
            latestDate = c;
            latestVersion = v;
        }
        return latestVersion;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("DateVersionSelector(");
        ret.append("date=");
        ret.append(this.date);
        ret.append(", returnLatest=");
        ret.append(this.returnLatest);
        ret.append(")");
        return ret.toString();
    }
}

