/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util;

import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class TransientFileFactory {
    private static TransientFileFactory INSTANCE;
    private ReferenceQueue phantomRefQueue = new ReferenceQueue();
    private Collection trackedRefs = Collections.synchronizedList(new ArrayList());
    private final Thread reaper = new ReaperThread("Transient File Reaper");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransientFileFactory getInstance() {
        Class<TransientFileFactory> clazz = TransientFileFactory.class;
        synchronized (TransientFileFactory.class) {
            if (INSTANCE == null) {
                INSTANCE = new TransientFileFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private TransientFileFactory() {
        this.reaper.setPriority(1);
        this.reaper.setDaemon(true);
        this.reaper.start();
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Collection collection = TransientFileFactory.this.trackedRefs;
                    synchronized (collection) {
                        for (MoribundFileReference fileRef : TransientFileFactory.this.trackedRefs) {
                            fileRef.delete();
                        }
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public File createTransientFile(String prefix, String suffix, File directory) throws IOException {
        File f = File.createTempFile(prefix, suffix, directory);
        this.trackedRefs.add(new MoribundFileReference(f, this.phantomRefQueue));
        return f;
    }

    private class MoribundFileReference
    extends PhantomReference {
        private String path;

        MoribundFileReference(File file, ReferenceQueue queue) {
            super(file, queue);
            this.path = file.getPath();
        }

        boolean delete() {
            return new File(this.path).delete();
        }
    }

    private class ReaperThread
    extends Thread {
        ReaperThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                MoribundFileReference fileRef = null;
                try {
                    fileRef = (MoribundFileReference)TransientFileFactory.this.phantomRefQueue.remove();
                }
                catch (Exception e) {
                    continue;
                }
                fileRef.delete();
                fileRef.clear();
                TransientFileFactory.this.trackedRefs.remove(fileRef);
            }
        }
    }
}

