/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.BaseValue;

public class ReferenceValue
extends BaseValue {
    public static final int TYPE = 9;
    private final String uuid;

    public ReferenceValue(Node target) throws RepositoryException {
        super(9);
        try {
            this.uuid = target.getUUID();
        }
        catch (UnsupportedRepositoryOperationException ure) {
            throw new IllegalArgumentException("target is nonreferenceable.");
        }
    }

    public static ReferenceValue valueOf(String s) throws ValueFormatException {
        if (s != null) {
            try {
                UUID.fromString(s);
            }
            catch (IllegalArgumentException iae) {
                throw new ValueFormatException("not a valid UUID format");
            }
            return new ReferenceValue(s);
        }
        throw new ValueFormatException("not a valid UUID format");
    }

    protected ReferenceValue(String uuid) {
        super(9);
        this.uuid = uuid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReferenceValue) {
            ReferenceValue other = (ReferenceValue)obj;
            if (this.uuid == other.uuid) {
                return true;
            }
            if (this.uuid != null && other.uuid != null) {
                return this.uuid.equals(other.uuid);
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    protected String getInternalString() throws ValueFormatException {
        if (this.uuid != null) {
            return this.uuid;
        }
        throw new ValueFormatException("empty value");
    }

    @Override
    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    @Override
    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    @Override
    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    @Override
    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }
}

