/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.common.io;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.common.DocInfo;
import com.kingdee.bos.ctrl.kdf.common.Kdf;
import com.kingdee.bos.ctrl.kdf.common.PrintInfo;
import com.kingdee.bos.ctrl.kdf.common.io.Kdf2Xml;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.jdom2.Element;

public final class Xml2Kdf {
    public static Kdf loadDocRoot(Element xml) {
        Kdf kdf = new Kdf();
        kdf.setDocInfo(Xml2Kdf.loadDocInfo(xml.getChild("DocInfo")));
        kdf.setStyles(Xml2Kdf.loadStyles(xml.getChild("Styles")));
        kdf.setDataSources(Xml2Kdf.loadDataSources(xml.getChild("DataSources")));
        kdf.setPrintInfo(Xml2Kdf.loadPrintInfo(xml.getChild("PrintInfo")));
        return kdf;
    }

    public static DocInfo loadDocInfo(Element xml) {
        DocInfo docInfo = new DocInfo();
        docInfo.setAuthors(xml.getAttributeValue("Authors"));
        docInfo.setCompany(xml.getAttributeValue("Company"));
        docInfo.setCreated(xml.getAttributeValue("Created"));
        docInfo.setLastModified(xml.getAttributeValue("LastModified"));
        return docInfo;
    }

    public static HashMap loadStyles(Element xml) {
        HashMap<String, Style> styles = new HashMap<String, Style>();
        for (Element xmlStyle : xml.getChildren("Style", Kdf2Xml.NS_COMMON)) {
            String id = xmlStyle.getAttributeValue("id");
            styles.put(id, Xml2Kdf.loadStyle(xmlStyle));
        }
        return styles;
    }

    public static Style loadStyle(Element xml) {
        return Styles.getStyle((ShareStyleAttributes)StyleParser.parseSA((Element)xml));
    }

    public static Style loadDataSource(Element xml) {
        return null;
    }

    public static HashMap loadDataSources(Element xml) {
        HashMap<String, Style> dss = new HashMap<String, Style>();
        for (Element xmlDS : xml.getChildren("DataSource")) {
            String id = xmlDS.getAttributeValue("id");
            dss.put(id, Xml2Kdf.loadDataSource(xmlDS));
        }
        return dss;
    }

    public static PrintInfo loadPrintInfo(Element xml) {
        PrintInfo printInfo = new PrintInfo();
        Element xmlPS = xml.getChild("PageSetup", Kdf2Xml.NS_COMMON);
        Element xmlPM = xmlPS.getChild("PageMargin", Kdf2Xml.NS_COMMON);
        String s = xmlPM.getAttributeValue("left");
        if (s != null) {
            printInfo.setMarginLeft(Integer.parseInt(s));
        }
        if ((s = xmlPM.getAttributeValue("right")) != null) {
            printInfo.setMarginRight(Integer.parseInt(s));
        }
        if ((s = xmlPM.getAttributeValue("top")) != null) {
            printInfo.setMarginTop(Integer.parseInt(s));
        }
        if ((s = xmlPM.getAttributeValue("bottom")) != null) {
            printInfo.setMarginBottom(Integer.parseInt(s));
        }
        printInfo.setOrientation(xmlPS.getChildText("Orientation", Kdf2Xml.NS_COMMON));
        Element xmlCPS = xmlPS.getChild("CustomizePaperSize", Kdf2Xml.NS_COMMON);
        if (xmlCPS != null) {
            s = xmlCPS.getAttributeValue("width");
            if (s != null) {
                printInfo.setCustomizePaperHeight(Integer.parseInt(s));
            }
            if ((s = xmlCPS.getAttributeValue("height")) != null) {
                printInfo.setCustomizePaperHeight(Integer.parseInt(s));
            }
        } else {
            printInfo.setPaperSizeName(xmlPS.getChildText("PaperSizeName", Kdf2Xml.NS_COMMON));
        }
        if (!StringUtil.isEmptyString((String)(s = xml.getChildText("PrinterSetup", Kdf2Xml.NS_COMMON)))) {
            printInfo.setPrinterSetup((HashPrintRequestAttributeSet)Base64.decodeToObject((String)s));
        }
        return printInfo;
    }
}

