/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.datasource;

import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import org.jdom2.Content;
import org.jdom2.Element;

public final class JDBCDataSource
extends DataSource {
    private String sqlString;
    private String connectionID;

    public JDBCDataSource() {
    }

    public JDBCDataSource(String id, String sqlString) {
        super(id);
        this.sqlString = sqlString;
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    @Override
    public String getSource() {
        return this.sqlString;
    }

    @Override
    public void setSource(String sql) {
        this.sqlString = sql;
    }

    @Override
    public Element writeToNode() {
        Element ele = this.createDSNode();
        Element eleJdbc = new Element("DBConnectionDataSource", ele.getNamespace());
        if (this.connectionID != null) {
            eleJdbc.setAttribute("connection", this.connectionID);
        }
        Element eleSql = new Element("SqlString", ele.getNamespace());
        eleSql.setText(this.getSource());
        eleJdbc.addContent((Content)eleSql);
        eleJdbc.addContent((Content)this.buildParamsNode(eleJdbc.getNamespace()));
        ele.setAttribute("id", this.getID());
        ele.addContent((Content)eleJdbc);
        if (this.getUserObject() instanceof Element) {
            ele.addContent((Content)((Element)this.getUserObject()));
        }
        return ele;
    }

    @Override
    public Object readFromNode(Element ele) {
        this.setID(ele.getAttributeValue("id").trim());
        Element dsn = ele.getChild("DesignedDataSource", ele.getNamespace());
        if (dsn != null) {
            this.setUserObject(dsn.clone());
        }
        ele = ele.getChild("DBConnectionDataSource", ele.getNamespace());
        this.setConnectionID(ele.getAttributeValue("connection"));
        this.setSource(ele.getChildText("SqlString", ele.getNamespace()));
        this.setParams(this.resolveParamsNode(ele));
        return this;
    }
}

