/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.impl;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.kdf.data.config.DBConfig;
import com.kingdee.bos.ctrl.kdf.data.config.DBInfo;
import com.kingdee.bos.ctrl.kdf.util.DES;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

public final class DBConnection {
    private static DBConnection instance;
    private HashMap pool;
    private DBConfig dbcfg;
    private DBInfo[] extraConns;

    private DBConnection(DBConfig cfg) {
        this.dbcfg = cfg;
        this.pool = new HashMap();
    }

    public DBConfig getDBConfig() {
        return this.dbcfg;
    }

    public static DBConnection instance() {
        if (instance == null) {
            File mFile = GlobalLocator.getInstance().locateResourceFile("/server/DBConfig.xml");
            DBConfig dbcfg = new DBConfig(mFile.getPath());
            instance = new DBConnection(dbcfg);
        }
        return instance;
    }

    public void setExtraInfo(DBInfo[] exInfo) {
        this.extraConns = exInfo;
    }

    public Connection getConnection(String id) {
        DBInfo dbi = null;
        if (this.extraConns != null) {
            for (int i = 0; i < this.extraConns.length; ++i) {
                if (id != null && !id.equals(this.extraConns[i].id)) continue;
                dbi = this.extraConns[i];
                break;
            }
        }
        if (dbi == null && (dbi = this.dbcfg.getDBInfo(id)) == null && id == null && this.dbcfg.getDBInfoSize() > 0) {
            dbi = this.dbcfg.getDBInfo(0);
        }
        if (dbi != null) {
            Connection con = null;
            Object o = this.pool.get(dbi);
            if (o != null) {
                return (Connection)o;
            }
            try {
                Class.forName(dbi.driver).newInstance();
                con = DriverManager.getConnection(dbi.connection, dbi.user, DES.decode(dbi.pwd));
                this.pool.put(dbi, con);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return con;
        }
        return null;
    }
}

