/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.export.direct;

import com.kingdee.bos.ctrl.kdf.export.AbstractExporter;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.RtfExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.direct.HtmlPageExporter;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageCollection;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.render.layout.TextLineBreaker;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class RtfExporter2
extends AbstractExporter {
    private PageCollection pc;
    private boolean pureText = false;
    private Dimension pageSize = new Dimension(2100, 2970);
    private float[] margin = new float[]{250.0f, 250.0f, 190.0f, 190.0f};
    private Document document;
    private static final RtfFont DEFAULT_FONT = new RtfFont("\u5b8b\u4f53", 9.0f);
    private static final float DEFAULT_BLANK_CHAR_WIDTH = 17.64f;
    private static final float DEFAULT_BLANK_LINE_HEIGHT = 35.28f;
    private static final FontRenderContext DEFAULT_RENDERCONTEXT = ((Graphics2D)new BufferedImage(1, 1, 1).getGraphics()).getFontRenderContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void export() {
        block15: {
            OutputStream os;
            float[] mg;
            Dimension dim;
            Boolean isOutTable;
            this.pc = (PageCollection)this.parameters.get(ExporterParameter.PAGE_COLLECTION);
            if (this.pc == null) {
                Form form = (Form)this.parameters.get(ExporterParameter.FORM);
                if (form != null && form.getOutputPages() != null) {
                    this.pc = form.getOutputPages();
                } else {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u8f93\u51fa\u6e90\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8981\u8f93\u51fa\u7684\u6587\u6863");
                }
            }
            if ((isOutTable = (Boolean)this.parameters.get(RtfExporterParameter.IS_OUTTABLE)) != null) {
                boolean bl = this.pureText = isOutTable == false;
            }
            if ((dim = (Dimension)this.parameters.get(ExporterParameter.PAGE_SIZE)) != null) {
                this.pageSize = dim;
            }
            if ((mg = (float[])this.parameters.get(ExporterParameter.PAGE_MARGIN)) != null) {
                this.margin = mg;
            }
            if ((os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM)) != null) {
                this.exportToStream(os);
            } else {
                String fileName;
                File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
                if (destFile == null && (fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME)) != null) {
                    destFile = new File(fileName);
                }
                os = new FileOutputStream(destFile);
                this.exportToStream(os);
                os.flush();
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
            break block15;
            catch (FileNotFoundException e) {
                e.printStackTrace();
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{os});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToStream(OutputStream os) {
        Rectangle rc = new Rectangle((float)StyleUtil.lomToPt((double)this.pageSize.getWidth()), (float)StyleUtil.lomToPt((double)this.pageSize.getHeight()));
        this.document = new Document(rc, (float)StyleUtil.lomToPt((double)this.margin[2]), (float)StyleUtil.lomToPt((double)this.margin[3]), (float)StyleUtil.lomToPt((double)this.margin[0]), (float)StyleUtil.lomToPt((double)this.margin[1]));
        RtfWriter2.getInstance((Document)this.document, (OutputStream)os);
        this.document.open();
        try {
            for (int i = 0; i < this.pc.size(); ++i) {
                if (i > 0) {
                    this.document.newPage();
                }
                if (this.pureText) {
                    this.exportPurePage(this.pc.get(i));
                    continue;
                }
                this.exportPage(this.pc.get(i));
            }
        }
        finally {
            this.document.close();
        }
    }

    private void exportPage(Page page) {
    }

    private void exportPurePage(Page page) {
        ArrayList al = new ArrayList();
        this.getAllTextCell(page, al);
        Object[] tcs = al.toArray(new TextCell[0]);
        Arrays.sort(tcs);
        try {
            this.writeTextCell((TextCell[])tcs);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void writeTextCell(TextCell[] tcs) throws DocumentException {
        Phrase currentPhrase = null;
        TextCell lastCell = null;
        for (int i = 0; i < tcs.length; ++i) {
            if (lastCell == null || tcs[i].top > lastCell.top) {
                int lc;
                if (currentPhrase != null) {
                    this.document.add(currentPhrase);
                    this.document.add((Element)new Chunk("\r\n", (com.lowagie.text.Font)DEFAULT_FONT));
                }
                if ((lc = (int)((tcs[i].top - (lastCell == null ? 0.0 : lastCell.bottom)) / (double)35.28f)) > 0) {
                    this.document.add((Element)new Chunk(this.getDupString(lc, "\r\n"), (com.lowagie.text.Font)DEFAULT_FONT));
                }
                currentPhrase = new Phrase();
            }
            int charCount = 0;
            charCount = lastCell == null || tcs[i].top != lastCell.top ? (int)(tcs[i].left / (double)17.64f) : (tcs[i].left > lastCell.right ? (int)((tcs[i].left - lastCell.right) / (double)17.64f) : 0);
            lastCell = tcs[i];
            currentPhrase.add((Element)new Chunk(this.getDupString(charCount, " "), (com.lowagie.text.Font)DEFAULT_FONT));
            currentPhrase.add((Element)new Chunk(tcs[i].text, this.kdFont2iTextFont(tcs[i].style)));
        }
        if (currentPhrase != null) {
            this.document.add(currentPhrase);
        }
    }

    private String getDupString(int count, String dup) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            sb.append(dup);
        }
        return sb.toString();
    }

    private com.lowagie.text.Font kdFont2iTextFont(Style stl) {
        int style = 0;
        if (stl.isBold()) {
            style |= 1;
        }
        if (stl.isItalic()) {
            style |= 2;
        }
        if (stl.isUnderline()) {
            style |= 4;
        }
        return new RtfFont("\u5b8b\u4f53", (float)stl.getFontSize(), style, stl.getFontColor());
    }

    private void getAllTextCell(Container cont, ArrayList al) {
        if (cont instanceof Cell) {
            Cell cel = (Cell)cont;
            Data data = cel.getData();
            if (data != null && ("datetime".equals(data.getType()) || "number".equals(data.getType()) || "string".equals(data.getType()) || "unknown".equals(data.getType()))) {
                Style style = Styles.getStyle((ShareStyleAttributes)HtmlPageExporter.getContainerSSA(cel));
                int cellwidth = cel.getRight().getInteger() - cel.getLeft().getInteger();
                int cellheight = cel.getBottom().getInteger() - cel.getTop().getInteger();
                Object[] objs = RtfExporter2.getBreakedTextSizeAndLines(cellwidth, data.getFormat(), style, DEFAULT_RENDERCONTEXT);
                Dimension size = (Dimension)objs[0];
                String[] lines = (String[])objs[1];
                Dimension[] subsize = (Dimension[])objs[2];
                double lineheight = lines.length == 0 ? 0.0 : (double)size.height * 1.0 / (double)lines.length;
                double xbias = 0.0;
                double ybias = 0.0;
                if (style.getVerticalAlign().equals(Styles.VerticalAlignment.MIDDLE)) {
                    if (size.height < cellheight) {
                        ybias = (double)(cellheight - size.height) / 2.0;
                    }
                } else if (style.getVerticalAlign().equals(Styles.VerticalAlignment.BOTTOM)) {
                    if (size.height < cellheight) {
                        ybias = cellheight - size.height;
                    }
                } else {
                    ybias = 0.0;
                }
                for (int i = 0; i < lines.length; ++i) {
                    String text = lines[i];
                    Dimension lsize = subsize[i];
                    xbias = style.getHorizontalAlign().equals(Styles.HorizontalAlignment.CENTER) ? (double)(cellwidth - lsize.width) / 2.0 : (style.getHorizontalAlign().equals(Styles.HorizontalAlignment.RIGHT) ? (double)(cellwidth - lsize.width) : 0.0);
                    double yoffset = ybias + (double)i * lineheight;
                    al.add(new TextCell((double)cel.getLeft().getInteger() + xbias, (double)cel.getLeft().getInteger() + xbias + (double)lsize.width, (double)cel.getTop().getInteger() + yoffset, (double)cel.getTop().getInteger() + yoffset + (double)lsize.height, text, style));
                }
            }
        } else {
            Iterator itr = cont.iterator();
            while (itr.hasNext()) {
                Container scont = (Container)itr.next();
                this.getAllTextCell(scont, al);
            }
        }
    }

    private static Object[] getBreakedTextSizeAndLines(int widthLimit, String source, Style style, FontRenderContext frc) {
        if (source == null || source.length() == 0) {
            return new Object[]{new Dimension(0, 0), new String[0], new Dimension[0]};
        }
        TextLineBreaker tlb = new TextLineBreaker(source, (Font)style.getKDFont(), frc);
        double width = (double)(widthLimit * 72) / 254.0;
        double mWidth = 0.0;
        double mHeight = 0.0;
        KDFont ft = style.getKDFont();
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Dimension> dal = new ArrayList<Dimension>();
        while (tlb.hasNext()) {
            String line = tlb.nextRowString(width);
            al.add(line);
            Rectangle2D r2d = ft.getStringBounds(line, frc);
            dal.add(new Dimension((int)(r2d.getWidth() * 254.0 / 72.0), (int)(r2d.getHeight() * 254.0 / 72.0)));
            double t = r2d.getWidth();
            if (t > mWidth) {
                mWidth = t;
            }
            t = r2d.getHeight();
            mHeight += t;
        }
        return new Object[]{new Dimension((int)(mWidth * 254.0 / 72.0), (int)(mHeight * 254.0 / 72.0)), al.toArray(new String[0]), dal.toArray(new Dimension[0])};
    }

    private static class TextCell
    implements Comparable {
        public double left;
        public double right;
        public double top;
        public double bottom;
        public String text;
        public Style style;

        public TextCell(double left, double right, double top, double bottom, String text, Style style) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.text = text;
            this.style = style;
        }

        public int compareTo(Object o) {
            if (!(o instanceof TextCell)) {
                return -1;
            }
            TextCell co = (TextCell)o;
            if (this.top < co.top) {
                return -1;
            }
            if (this.top == co.top) {
                if (this.left < co.left) {
                    return -1;
                }
                if (this.left == co.left) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
    }
}

