/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.data.Row;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.DataListener;
import java.util.ArrayList;
import java.util.HashMap;

public final class CachedDataListenerDecorator
implements DataListener {
    private HashMap cacheMap;
    private HashMap currentRowMap;
    private DataListener dataListener;

    public CachedDataListenerDecorator(DataListener dataListener) {
        this.dataListener = dataListener;
        this.cacheMap = new HashMap();
        this.currentRowMap = new HashMap();
    }

    public int getAvailableContentCount(String dataSource, int limit) {
        if (limit < 1) {
            return 0;
        }
        if (this.currentRowMap.containsKey(dataSource)) {
            int c = 0;
            Row row = (Row)this.currentRowMap.get(dataSource);
            if (row != null) {
                c = 1;
                ArrayList list = (ArrayList)this.cacheMap.get(dataSource);
                if (list != null) {
                    c += list.size();
                }
                if (c < limit && this.dataListener.hasNext(dataSource)) {
                    this.dataListener.blockDataSet(dataSource);
                    while (this.dataListener.hasNext(dataSource) && c < limit) {
                        this.dataListener.next(dataSource);
                        Row trow = this.dataListener.getRow(dataSource);
                        list.add(trow);
                        ++c;
                    }
                    this.dataListener.syncDataSet(dataSource);
                }
            }
            return c;
        }
        this.dataListener.blockDataSet(dataSource);
        ArrayList<Row> rowList = new ArrayList<Row>();
        int c = 0;
        if (this.dataListener.getCurrentRecordNumber(dataSource) >= 0 && this.dataListener.hasNext(dataSource)) {
            this.currentRowMap.put(dataSource, this.dataListener.getRow(dataSource));
        }
        while (this.dataListener.hasNext(dataSource) && c < limit) {
            this.dataListener.next(dataSource);
            Row row = this.dataListener.getRow(dataSource);
            if (!this.currentRowMap.containsKey(dataSource)) {
                this.currentRowMap.put(dataSource, row);
            } else {
                rowList.add(row);
            }
            ++c;
        }
        this.dataListener.syncDataSet(dataSource);
        this.cacheMap.put(dataSource, rowList);
        return rowList.size() + (this.currentRowMap.containsKey(dataSource) ? 1 : 0);
    }

    @Override
    public boolean hasNext(String dataSource) {
        if (this.cacheMap.containsKey(dataSource)) {
            ArrayList list = (ArrayList)this.cacheMap.get(dataSource);
            if (list.size() > 0) {
                return true;
            }
            this.cacheMap.remove(dataSource);
            this.currentRowMap.remove(dataSource);
        }
        return this.dataListener.hasNext(dataSource);
    }

    @Override
    public void next(String dataSource) {
        if (this.cacheMap.containsKey(dataSource)) {
            ArrayList list = (ArrayList)this.cacheMap.get(dataSource);
            if (list.size() > 0) {
                this.currentRowMap.put(dataSource, list.remove(0));
                return;
            }
            this.cacheMap.remove(dataSource);
            this.currentRowMap.remove(dataSource);
        }
        this.dataListener.next(dataSource);
    }

    @Override
    public Data getFieldData(String dataSource, String field) {
        if (this.currentRowMap.containsKey(dataSource)) {
            Row row = (Row)this.currentRowMap.get(dataSource);
            Data dt = new Data();
            dt.setType("unknown");
            dt.setValue(row.get(field));
            return dt;
        }
        return this.dataListener.getFieldData(dataSource, field);
    }

    @Override
    public Row getRow(String dataSource) {
        if (this.currentRowMap.containsKey(dataSource)) {
            return (Row)this.currentRowMap.get(dataSource);
        }
        return this.dataListener.getRow(dataSource);
    }

    @Override
    public int getCurrentRecordNumber(String dataSource) {
        if (this.cacheMap.containsKey(dataSource)) {
            ArrayList list = (ArrayList)this.cacheMap.get(dataSource);
            int l = this.dataListener.getCurrentRecordNumber(dataSource);
            return l - list.size();
        }
        return this.dataListener.getCurrentRecordNumber(dataSource);
    }

    @Override
    public int getTotalRecordCount(String dataSource) {
        return this.dataListener.getTotalRecordCount(dataSource);
    }

    @Override
    public void blockDataSet(String dataSource) {
        this.dataListener.blockDataSet(dataSource);
    }

    @Override
    public void syncDataSet(String dataSource) {
        this.dataListener.syncDataSet(dataSource);
    }
}

