/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.headfootdesigner;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootDesigner;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.ICreateDesigner;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.icons.ResourceManager;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.KDFHeaderFooterPainter;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class HeadFootDesignerAction
extends AbstractAction
implements CompositableAction {
    private static final long serialVersionUID = 12343456L;
    private transient PrintCompContainer container;
    private HeadFootDesigner designer;
    private ICreateDesigner designerCreator = new DefaultDesignerCreator();

    public HeadFootDesignerAction() {
        this.putValue("Name", this.getMLS("title", "\u9875\u7709\u9875\u811a"));
        this.putValue("ShortDescription", this.getMLS("title", "\u9875\u7709\u9875\u811a"));
        this.putValue("ICON24", ResourceManager.getImage("tbtn_page.gif"));
        this.putValue("DEFAULT_ENABLE", true);
        this.putValue("ENABLE_UNTIL_DATACOMPLETED", true);
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
        this.container = container;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KDF kdf;
        KDFHeaderFooterPainter hfPainter = null;
        ExtVarProvider varProv = null;
        Page headPage = null;
        Page footPage = null;
        HeadFootModel headModel = null;
        HeadFootModel footModel = null;
        String headId = null;
        String footId = null;
        if (this.container.getHeaderFooterPainter() instanceof KDFHeaderFooterPainter) {
            hfPainter = (KDFHeaderFooterPainter)this.container.getHeaderFooterPainter();
            kdf = hfPainter.getKdf();
            varProv = hfPainter.getExtVarProvider();
        } else {
            kdf = new KDF();
        }
        if (kdf.getHeaders().length != 0) {
            headPage = kdf.getHeaders()[0];
            headId = headPage.getId();
        }
        if (kdf.getFooters().length != 0) {
            footPage = kdf.getFooters()[0];
            footId = footPage.getId();
        }
        headModel = HeadFootParser.parseHeadFootPage2Model(headPage);
        footModel = HeadFootParser.parseHeadFootPage2Model(footPage);
        if (headModel == null) {
            headModel = new HeadFootModel();
        }
        if (footModel == null) {
            footModel = new HeadFootModel();
        }
        if (this.designer == null) {
            Container c = SwingUtilities.getAncestorOfClass(Frame.class, this.container.getBaseComponent());
            Frame frame = c != null ? (Frame)c : new Frame();
            this.designer = this.designerCreator.createDesigner(frame);
            this.designer.setTitle(this.getMLS("title", "\u9875\u7709\u9875\u811a"));
            this.designer.setSize(500, 330);
            this.designer.setLocationRelativeTo(null);
        }
        this.designer.setCurrentPageForPreview(this.container.getPreviewContext().getCurrentPage());
        this.designer.setTotalPageForPreview(this.container.getPreviewContext().getTotalPageCount());
        this.designer.setVarProv(varProv);
        this.designer.setHeadModel(headModel);
        this.designer.setFootModel(footModel);
        this.designer.show();
        if (this.designer.isHeadChanged()) {
            headModel = this.designer.getHeadModel();
            headPage = HeadFootParser.parseModel2HeadFootPage(headModel);
            if (headId == null) {
                headId = headPage.getId();
            }
            headPage.setId(headId);
            kdf.removeHeader(headId);
            kdf.addHeader(headPage);
        }
        if (this.designer.isFootChanged()) {
            footModel = this.designer.getFootModel();
            footPage = HeadFootParser.parseModel2HeadFootPage(footModel);
            if (footId == null) {
                footId = footPage.getId();
            }
            footPage.setId(footId);
            kdf.removeFooter(footId);
            kdf.addFooter(footPage);
        }
        if (hfPainter == null) {
            hfPainter = new KDFHeaderFooterPainter(kdf, headId, footId, this.container.getPrinterAttrManager());
            hfPainter.setExtVarProv(this.container.getHeaderFooterPainter().getExtVarProvider());
            this.container.setHeaderFooterPainter(hfPainter, 50, 50);
        }
        hfPainter.setKDF(kdf);
        this.container.getBaseComponent().getPreviewPane().doRepaint();
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootDesigner", (String)defaultValue);
    }

    public ICreateDesigner getDesignerCreator() {
        return this.designerCreator;
    }

    public void setDesignerCreator(ICreateDesigner designer) {
        this.designerCreator = designer;
    }

    private static class DefaultDesignerCreator
    implements ICreateDesigner {
        private DefaultDesignerCreator() {
        }

        @Override
        public HeadFootDesigner createDesigner(Frame frame) {
            HeadFootDesigner designer = new HeadFootDesigner(frame, true);
            return designer;
        }
    }
}

