/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.actions;

import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.actions.AbstractZoomAction;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.ContextEventListener;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UpdateViewEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;

public class ComboZoomAction
extends AbstractZoomAction {
    private static final long serialVersionUID = 5739851898230990991L;
    ContextEventHander contextEventHander = new ContextEventHander();
    final DefaultComboBoxModel model = new DefaultComboBoxModel();
    boolean keepContextUntouch = false;

    public ComboZoomAction() {
        this.putValue("ShortDescription", Resources.LOCAL_STR("ComboZoom.Tip"));
        this.model.addElement(Resources.LOCAL_STR("ComboZoom.FitWhole"));
        this.model.addElement(Resources.LOCAL_STR("ComboZoom.FitHeight"));
        this.model.addElement(Resources.LOCAL_STR("ComboZoom.FitWidth"));
        for (int i = 3; i < ZOOM_FACTORS.length; ++i) {
            this.model.addElement(String.valueOf((int)(ZOOM_FACTORS[i] * 100.0f)) + " %");
        }
        this.putValue("COMPONENT_TYPE", "COMBOBOX");
        this.putValue("COMBOXBOX_MODEL", this.model);
        this.putValue("DEFAULT_ENABLE", true);
        this.putValue("ENABLE_UNTIL_DATACOMPLETED", true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!event.getActionCommand().equals("comboBoxChanged")) {
            return;
        }
        if (this.keepContextUntouch) {
            return;
        }
        if (this.model.getSelectedItem() == null) {
            return;
        }
        int idxSel = this.model.getIndexOf(this.model.getSelectedItem());
        if (idxSel == -1) {
            double factor = this.getLegalZoomFactor(this.model.getSelectedItem().toString());
            if (factor > 0.0) {
                this.setZoomFactor(factor);
            }
        } else {
            double factor = ZOOM_FACTORS[idxSel];
            if (factor == -1.0) {
                this.context.setPaneFitStyle(1);
            } else if (factor == -2.0) {
                this.context.setPaneFitStyle(2);
            } else if (factor == -3.0) {
                this.context.setPaneFitStyle(3);
            } else {
                this.setZoomFactor(factor);
            }
        }
    }

    float getLegalZoomFactor(String val) {
        float result = 0.0f;
        try {
            val.trim();
            if (val.endsWith("%")) {
                val = val.substring(0, val.length() - 2);
            }
            result = Float.valueOf(val).floatValue();
        }
        catch (NumberFormatException e) {
            KDOptionPane.showMessageDialog((Component)this.container.getBaseComponent(), (Object)Resources.LOCAL_STR("ComboZoom.IllegalInput"), (String)Resources.LOCAL_STR("ComboZoom.IllegalInput"), (int)1);
            return 0.0f;
        }
        if (result < 10.0f || result > 500.0f) {
            result = 0.0f;
            KDOptionPane.showMessageDialog((Component)this.container.getBaseComponent(), (Object)Resources.LOCAL_STR("ComboZoom.InputConform"), (String)Resources.LOCAL_STR("ComboZoom.IllegalInput"), (int)1);
        }
        return (float)((double)result * 0.01);
    }

    @Override
    public void setCompContainer(PrintCompContainer cont) {
        super.setCompContainer(cont);
        this.model.setSelectedItem(this.model.getElementAt(6));
        this.context.addContextEventListener(this.contextEventHander);
        this.container.getBaseComponent().setFocusable(true);
        this.container.getBaseComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if ('w' == e.getKeyChar()) {
                    ComboZoomAction.this.context.setPaneFitStyle(1);
                } else if ('h' == e.getKeyChar()) {
                    ComboZoomAction.this.context.setPaneFitStyle(2);
                } else if ('a' == e.getKeyChar()) {
                    ComboZoomAction.this.context.setPaneFitStyle(3);
                }
            }
        });
    }

    class ContextEventHander
    implements ContextEventListener {
        ContextEventHander() {
        }

        @Override
        public void currentPageChanged(CurrentPageChangedEvent event) {
        }

        @Override
        public void uiStateChanged(UIStateChangedEvent event) {
        }

        @Override
        public void updateView(UpdateViewEvent event) {
            double factor = ComboZoomAction.this.getZoomFactor();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(2);
            ComboZoomAction.this.keepContextUntouch = true;
            ComboZoomAction.this.model.setSelectedItem(nf.format(factor * 100.0) + "%");
            ComboZoomAction.this.keepContextUntouch = false;
        }
    }
}

