/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.dialogs;

import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.PrintConfigDialog;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Frame;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JPanel;

public class BasicPrintSetupPaneBuilder {
    private PrintConfigDialog servDlg;
    private JButton btnOK;
    private JButton btnCancel;
    private PrinterAttrManager attrMgr;

    public BasicPrintSetupPaneBuilder(PrinterAttrManager attrmgr) throws PrinterNotFoundException {
        this.attrMgr = attrmgr;
        this.InitServDlg(attrmgr);
    }

    public void dispose() {
        if (this.servDlg != null) {
            this.servDlg.dispose();
        }
    }

    private void InitServDlg(PrinterAttrManager attrmgr) throws PrinterNotFoundException {
        HashPrintRequestAttributeSet asNew = new HashPrintRequestAttributeSet();
        asNew.addAll(attrmgr.getRequestAttrSet());
        PrintService[] srvs = attrmgr.getPrintServices();
        if (srvs.length == 0) {
            throw new PrinterNotFoundException();
        }
        int idx = 0;
        for (int i = 0; i < srvs.length; ++i) {
            if (srvs[i] != attrmgr.getCurrentService()) continue;
            idx = i;
            break;
        }
        this.servDlg = new PrintConfigDialog((Frame)null);
        this.servDlg.init(null, 200, 200, srvs, idx, DocFlavor.SERVICE_FORMATTED.PRINTABLE, asNew);
        JPanel pane = (JPanel)this.servDlg.getContentPane();
        JPanel p = (JPanel)pane.getComponent(1);
        this.btnOK = (JButton)p.getComponent(0);
        this.btnCancel = (JButton)p.getComponent(1);
        p.remove(this.btnOK);
        p.remove(this.btnCancel);
        this.btnCancel = new KDButton();
    }

    public KDTabbedPane getConfigPane() {
        return this.servDlg.getTabbedPane();
    }

    public PrintConfigDialog getServDlg() {
        return this.servDlg;
    }

    public JButton getOKButton() {
        return this.btnOK;
    }

    public JButton getCancelButton() {
        return this.btnCancel;
    }

    public void update() {
        if (this.servDlg != null) {
            HashPrintRequestAttributeSet asNew = new HashPrintRequestAttributeSet();
            asNew.addAll(this.attrMgr.getRequestAttrSet());
        }
    }
}

