/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.headerfooter;

import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageInfo;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientFormPages;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.FormPainter;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPage;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPageManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.PageObject;
import com.kingdee.bos.ctrl.kdf.printprovider.IHeaderFooterPainter;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.VariantValProvider;
import com.kingdee.bos.ctrl.kdf.util.file.HeaderFooterHelper;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import java.awt.Graphics2D;
import javax.print.attribute.standard.MediaPrintableArea;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.log4j.Level;

public class KDFHeaderFooterPainter
implements IHeaderFooterPainter {
    private PrinterAttrManager attrMgr;
    private KDF kdf;
    private ClientCore clientCore;
    private FormPainter fp;
    private Page header = null;
    private Page footer = null;
    private PhysicalPageManager ppmgr;
    private ClientFormPages cformPages;
    private PhysicalPage headerPage;
    private PhysicalPage footerPage;
    String headerid;
    String footerid;
    private VariantValProvider variantVals = new VariantValProvider();

    @Override
    public void setExtVarProv(ExtVarProvider provider) {
        this.variantVals.setExtVarProv(provider);
    }

    public ExtVarProvider getExtVarProv() {
        return this.variantVals.getExtVarProv();
    }

    @Override
    public ExtVarProvider getExtVarProvider() {
        return this.variantVals.getExtVarProv();
    }

    public void setKDF(KDF kdf) {
        this.kdf = kdf;
        this.header = null;
        this.footer = null;
        this.headerid = null;
        this.footerid = null;
    }

    public KDFHeaderFooterPainter(KDF kdf, String headerid, String footerid, PrinterAttrManager attrMgr) {
        this.headerid = headerid;
        this.footerid = footerid;
        this.kdf = kdf;
        this.attrMgr = attrMgr;
    }

    private Page getHeader() {
        if (this.header == null) {
            if (this.headerid != null) {
                this.header = this.kdf.getHeader(this.headerid);
            } else if (this.kdf.getHeaders().length > 0) {
                this.header = this.kdf.getHeaders()[0];
            }
        }
        return this.header;
    }

    private Page getFooter() {
        if (this.footer == null) {
            if (this.footerid != null) {
                this.footer = this.kdf.getFooter(this.footerid);
            } else if (this.kdf.getFooters().length > 0) {
                this.footer = this.kdf.getFooters()[0];
            }
        }
        return this.footer;
    }

    @Override
    public int paintFooter(Graphics2D g2, int index, int cTotal) {
        if (this.getFooter() == null) {
            return 0;
        }
        Form footerform = HeaderFooterHelper.packHeaderFooter(this.getFooter(), this.kdf);
        this.footerPage = this.buildFooterPage(footerform, index, cTotal);
        float scaleFactor = this.attrMgr == null ? 1.0f : this.attrMgr.getScaleFactor();
        g2.scale(scaleFactor, scaleFactor);
        this.fp.drawPhysicsPage(this.footerPage, g2);
        scaleFactor = 1.0f / scaleFactor;
        g2.scale(scaleFactor, scaleFactor);
        return 0;
    }

    @Override
    public int paintHeader(Graphics2D g2, int index, int cTotal) {
        if (this.getHeader() == null) {
            return 0;
        }
        Form headerform = HeaderFooterHelper.packHeaderFooter(this.getHeader(), this.kdf);
        this.headerPage = this.buildHeaderPage(headerform, index, cTotal);
        float scaleFactor = this.attrMgr == null ? 1.0f : this.attrMgr.getScaleFactor();
        g2.scale(scaleFactor, scaleFactor);
        this.fp.drawPhysicsPage(this.headerPage, g2);
        scaleFactor = 1.0f / scaleFactor;
        g2.scale(scaleFactor, scaleFactor);
        return 0;
    }

    private PhysicalPage buildHeaderPage(Form headerform, int index, int cTotal) {
        String strh;
        PageInfo pinfo = new PageInfo();
        float scaleFactor = 1.0f;
        if (this.attrMgr != null) {
            scaleFactor = this.attrMgr.getScaleFactor();
        }
        if ((strh = headerform.getPages().get(0).getBottom().getOriginString()) != null) {
            int hh = Integer.valueOf(strh);
            pinfo.setHeight((int)((float)hh * this.getScreenMapRatio()));
        } else {
            pinfo.setHeight((int)((float)this.kdf.getPrintInfo().getHeaderPreferHeight() * this.attrMgr.screenMapRatio / scaleFactor));
        }
        String strw = headerform.getPages().get(0).getRight().getOriginString();
        if (strw != null) {
            int hw = Integer.valueOf(strw);
            pinfo.setWidth((int)((float)hw * this.getScreenMapRatio() / scaleFactor));
        } else if (this.attrMgr != null) {
            pinfo.setWidth((int)(this.attrMgr.area.getWidth(1000) * 10.0f * this.getScreenMapRatio() / scaleFactor));
        }
        headerform.restoreOriginState();
        this.variantVals.setPageIdx(index);
        this.variantVals.setPageCount(cTotal);
        headerform.initOutput(this.variantVals, null, pinfo);
        PrinterAttrManager pam = this.getClientCore().getPrintService().getPrinterAttrManager();
        if (this.attrMgr != null) {
            pam.setMediaPrintableArea(new MediaPrintableArea((int)((double)this.attrMgr.getBodyX() * 25.4 / 72.0), (int)((double)this.attrMgr.getHeaderMargin() * 25.4 / 72.0), (int)((double)this.attrMgr.getBodyW() * 25.4 / 72.0), (int)((double)this.attrMgr.getBodyH() * 25.4 / 72.0), 1000));
        } else {
            pam.setMediaPrintableArea(new MediaPrintableArea(0, 0, (int)((double)headerform.getOutputPage(0).getRight().getInteger() * 0.1 + 5.0), (int)((double)headerform.getOutputPage(0).getBottom().getInteger() * 0.1 + 5.0), 1000));
        }
        this.cformPages.clear();
        this.ppmgr.clear();
        PageObject pageObj = this.cformPages.appendRawPage(headerform.getOutputPage(0));
        this.ppmgr.SetupHostPage(pageObj);
        PhysicalPage pp = (PhysicalPage)this.ppmgr.get(0);
        return pp;
    }

    public PhysicalPage buildFooterPage(Form footerform, int index, int cTotal) {
        String strh;
        PageInfo pinfo = new PageInfo();
        float scaleFactor = 1.0f;
        if (this.attrMgr != null) {
            scaleFactor = this.attrMgr.getScaleFactor();
        }
        if ((strh = footerform.getPages().get(0).getBottom().getOriginString()) != null) {
            int hh = Integer.valueOf(strh);
            pinfo.setHeight((int)((float)hh * this.getScreenMapRatio()));
        } else {
            pinfo.setHeight((int)((float)this.kdf.getPrintInfo().getFooterPreferHeight() * this.attrMgr.screenMapRatio / scaleFactor));
        }
        String strw = footerform.getPages().get(0).getRight().getOriginString();
        if (strw != null) {
            int hw = Integer.valueOf(strw);
            pinfo.setWidth((int)((float)hw * this.attrMgr.screenMapRatio / scaleFactor));
        } else if (this.attrMgr != null) {
            pinfo.setWidth((int)(this.attrMgr.area.getWidth(1000) * 10.0f * this.getScreenMapRatio() / scaleFactor));
        }
        footerform.restoreOriginState();
        this.variantVals.setPageIdx(index);
        this.variantVals.setPageCount(cTotal);
        footerform.initOutput(this.variantVals, null, pinfo);
        PrinterAttrManager pam = this.getClientCore().getPrintService().getPrinterAttrManager();
        float hm = pam.getHeaderMargin();
        float fm = pam.getFooterMargin();
        pam.setHeaderMargin(0);
        pam.setFooterMargin(0);
        if (this.attrMgr != null) {
            int footerH = pinfo.getHeight();
            int footerY = (int)(((double)this.attrMgr.getPaperHeight() - (double)this.attrMgr.getFooterMargin()) * 25.4 / 72.0 / (double)scaleFactor - (double)(footerH / 10));
            pam.setMediaPrintableArea(new MediaPrintableArea((int)((double)this.attrMgr.getBodyX() * 25.4 / 72.0), footerY, (int)((double)this.attrMgr.getBodyW() * 25.4 / 72.0), footerH, 1000));
        } else {
            pam.setMediaPrintableArea(new MediaPrintableArea(0, 0, (int)((double)footerform.getOutputPage(0).getRight().getInteger() * 0.1), (int)((double)footerform.getOutputPage(0).getBottom().getInteger() * 0.1), 1000));
        }
        pam.setHeaderMargin((int)hm);
        pam.setFooterMargin((int)fm);
        this.cformPages.clear();
        this.ppmgr.clear();
        PageObject pageObj = this.cformPages.appendRawPage(footerform.getOutputPage(0));
        this.ppmgr.SetupHostPage(pageObj);
        PhysicalPage pp = (PhysicalPage)this.ppmgr.get(0);
        return pp;
    }

    private ClientCore getClientCore() {
        if (this.clientCore == null) {
            try {
                ClientCore.logger.setLevel(Level.OFF);
                this.clientCore = new ClientCore();
                this.clientCore.initializeNotConf();
                this.clientCore.getContextOfBrowser().setViewMode(1);
                this.fp = (FormPainter)this.clientCore.getPrintService().getPainter();
                this.ppmgr = this.clientCore.getPhyPageManager();
                this.cformPages = this.clientCore.getClientFormPages();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.clientCore;
    }

    public KDF getKdf() {
        return this.kdf;
    }

    public float getScreenMapRatio() {
        if (this.attrMgr != null) {
            return this.attrMgr.screenMapRatio;
        }
        return 1.0f;
    }
}

