/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.read;

import com.kingdee.bos.ctrl.common.util.ColorUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatVO;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.ConditionVO;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidateVO;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.CompareOnOperatorMapping;
import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.KDSAttributeSpan;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.kds.ViewSplitInfoVO;
import com.kingdee.bos.ctrl.kdf.read.Parameter;
import com.kingdee.bos.ctrl.kdf.read.Parser;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Excel2007Reader {
    private static final Logger logger = CommonLogger.getLogger(Excel2007Reader.class);
    private KDSBook book = null;
    private KDSSheet kdSheet = null;
    private float defaultRowHeight = 0.0f;
    private float defaultColWidth = 0.0f;
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int curRow = 0;
    private int curCol = 0;
    public StylesTable stylesTable;
    private String stylesIndex;
    private String formula;
    private boolean nextIsBoolean;
    private short type = 0;
    public static final String NULL_FORMULA = "ATTR(semiVolatile)";
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_EXCHANGE_COMMA = "KD_EXCHANGE_COMMA";
    public static final String KD_FORMULA_SPLIT = "_@_";
    private Object value = null;
    private Map colors = HSSFColor.getIndexHash();
    private Map styles = new HashMap();
    private Map sharedFormulas = new HashMap();
    private Map sameFormulas = new HashMap();
    private String sharedIdentity;
    private boolean hasBeenShared;
    private boolean hasShared;
    private String curCell;
    private Map srcCells = new HashMap();
    private boolean isInLineStr = false;
    public static final String EXPORT_FORMULA = "EXPORT_FORMULA";
    public static final String IMPORT_FORMAT = "IMPORT_FORMAT";
    public static final String IMPORT_STYLE = "IMPORT_STYLE";
    private boolean importFormula = true;
    private boolean importFormat = true;
    private boolean importStyle = true;
    private static String currentConditionalFormating = "conditionalFormatting";
    private static String currentRule = "rule";
    private static String currentDxfId = "dxfId";
    private static String currentFormula = "formula";
    private static String currentDataValidation = "dataValidation";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public KDSBook parse(String fileName, HashMap parameter) throws Exception {
        String sImportStyle;
        String sImportFormat;
        String sImportFormula = (String)parameter.get(EXPORT_FORMULA);
        if (!StringUtil.isEmptyString((String)sImportFormula)) {
            this.importFormula = Boolean.valueOf(sImportFormula);
        }
        if (!StringUtil.isEmptyString((String)(sImportFormat = (String)parameter.get(IMPORT_FORMAT)))) {
            this.importFormat = Boolean.valueOf(sImportFormat);
        }
        if (!StringUtil.isEmptyString((String)(sImportStyle = (String)parameter.get(IMPORT_STYLE)))) {
            this.importStyle = Boolean.valueOf(sImportStyle);
        }
        return this.parse(fileName);
    }

    public KDSBook parse(String filename) throws Exception {
        this.book = new KDSBook("aa");
        OPCPackage pkg = null;
        try {
            pkg = OPCPackage.open((String)filename, (PackageAccess)PackageAccess.READ);
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            this.stylesTable = r.getStylesTable();
            XMLReader parser = this.fetchSheetParser(sst);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            while (sheets.hasNext()) {
                this.parserSheet(parser, sheets);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != pkg) {
                pkg.close();
            }
        }
        return this.book;
    }

    private void parserSheet(XMLReader parser, XSSFReader.SheetIterator sheets) throws Exception {
        InputStream sheet = sheets.next();
        try {
            this.kdSheet = new KDSSheet(this.book, sheets.getSheetName());
            this.book.addSheet(null, this.kdSheet);
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            this.sharedFormulas = null;
            this.sameFormulas = null;
            this.srcCells = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != sheet) {
                sheet.close();
            }
        }
    }

    public void parseXlsx(String fileName) {
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        this.sst = sst;
        XlsxContentHander contentHander = new XlsxContentHander();
        CellHandler cellHandler = new CellHandler();
        contentHander.registerHandler("t", new InLineStrHandler());
        contentHander.registerHandler("c", cellHandler);
        contentHander.registerHandler("v", cellHandler);
        contentHander.registerHandler("f", cellHandler);
        contentHander.registerHandler("sheetFormatPr", cellHandler);
        contentHander.registerHandler("col", cellHandler);
        contentHander.registerHandler("row", cellHandler);
        contentHander.registerHandler("mergeCell", cellHandler);
        contentHander.registerHandler("sheetData", cellHandler);
        contentHander.registerHandler("conditionalFormatting", new ConditionalFormatHandler());
        contentHander.registerHandler("cfRule", new ConditionHandler());
        contentHander.registerHandler("formula", new FormulaHandler());
        contentHander.registerHandler("formula1", new FormulaHandler());
        contentHander.registerHandler("formula2", new FormulaHandler());
        contentHander.registerHandler("dataValidation", new DataValidation());
        contentHander.registerHandler("pane", new PaneHandler());
        parser.setContentHandler(contentHander);
        return parser;
    }

    private void parseMergeCell(String[] mergeCellStrs) {
        int firstRow = Integer.parseInt(mergeCellStrs[0].replaceAll("[A-Z]", "")) - 1;
        int firstCol = this.calCellColumn(mergeCellStrs[0]) - 1;
        int lastRow = Integer.parseInt(mergeCellStrs[1].replaceAll("[A-Z]", "")) - 1;
        int lastCol = this.calCellColumn(mergeCellStrs[1]) - 1;
        this.kdSheet.getMerges().addMerge(firstRow, firstCol, lastRow, lastCol);
    }

    private String calFormula(Parser parser, String srcCell, String cellPos) {
        String tempFormula = parser.getFormula();
        int srcCol = this.calCellColumn(srcCell) - 1;
        int srcRow = Integer.parseInt(srcCell.replaceAll("[A-Z]", "").trim()) - 1;
        int offsetX = this.curCol - srcCol;
        int offsetY = this.curRow - srcRow;
        ObjectArray parametersArray = parser.getParameters();
        Parameter parameter = null;
        StringBuilder sb = new StringBuilder(tempFormula);
        StringBuilder temp = null;
        int offsetLength = 0;
        int col = 0;
        int row = 0;
        for (int i = 0; i < parametersArray.size(); ++i) {
            temp = new StringBuilder();
            parameter = (Parameter)parametersArray.get(i);
            col = parameter.isAbsCol() ? parameter.getColNum() : parameter.getColNum() + offsetX;
            row = parameter.isAbsRow() ? parameter.getRowNum() : parameter.getRowNum() + offsetY;
            temp.append(SheetBaseMath.getColumnName((int)col, (int)0, (boolean)true, (boolean)parameter.isAbsCol()));
            temp.append(SheetBaseMath.getRowName((int)row, (int)0, (boolean)true, (boolean)parameter.isAbsRow()));
            sb.delete(parameter.getTokenPos() + offsetLength, parameter.getTokenLength() + parameter.getTokenPos() + offsetLength);
            sb.insert(parameter.getTokenPos() + offsetLength, temp.toString());
            offsetLength += temp.toString().length() - parameter.getTokenLength();
        }
        return sb.toString();
    }

    private String[] convertFormula(String formula) {
        int pos;
        String tmpFormula = formula;
        String[] returnValue = new String[3];
        returnValue[1] = "0";
        String formulaValue = "";
        if (formula.indexOf(KD_FORMULA_SPLIT) != -1 && formula.toLowerCase().indexOf("mid(\"") != -1) {
            formula = formula.replace("\"&\"", "");
            int beginIndex = formula.toLowerCase().indexOf("mid(\"") + "mid(\"".length();
            int endIndex = formula.indexOf(KD_FORMULA_SPLIT);
            int valueIndex = formula.lastIndexOf(",");
            formulaValue = formula.substring(0, valueIndex - 1);
            valueIndex = formulaValue.lastIndexOf(",") - 1;
            tmpFormula = formula.substring(beginIndex, endIndex);
            String sValue = formula.substring(endIndex + KD_FORMULA_SPLIT.length(), valueIndex);
            tmpFormula = this.convertFormulaSpecialString(tmpFormula);
            sValue = this.convertFormulaSpecialString(sValue);
            returnValue[1] = "1";
            returnValue[2] = sValue;
        }
        int iNullIndex = tmpFormula.indexOf(NULL_FORMULA);
        int iNullLen = NULL_FORMULA.length();
        while (iNullIndex != -1) {
            tmpFormula = tmpFormula.substring(0, iNullIndex) + tmpFormula.substring(iNullIndex + iNullLen);
            iNullIndex = tmpFormula.indexOf(NULL_FORMULA);
        }
        if (tmpFormula != null && (pos = tmpFormula.indexOf("!")) > 0) {
            String sheetName = tmpFormula.substring(0, pos);
            try {
                if (StringUtil.isNumber((String)sheetName)) {
                    Double.parseDouble(sheetName);
                    tmpFormula = KD_DOUBLE_COMMA + sheetName + KD_DOUBLE_COMMA + tmpFormula.substring(pos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        returnValue[0] = tmpFormula;
        return returnValue;
    }

    private String convertFormulaSpecialString(String formula2) {
        String f = formula2.replace(KD_SINGLE_COMMA, KD_EXCHANGE_COMMA);
        f = f.replace(KD_DOUBLE_COMMA, "\"");
        f = f.replace(KD_EXCHANGE_COMMA, KD_DOUBLE_COMMA);
        return f;
    }

    public int calCellColumn(String curCell) {
        curCell = curCell.replaceAll("[^A-Z]", "");
        byte[] rowAbc = curCell.getBytes();
        int len = rowAbc.length;
        float num = 0.0f;
        for (int i = 0; i < len; ++i) {
            num = (float)((double)num + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        return (int)num;
    }

    private StyleAttributes parseKDStyleAttributes(CTDxf dxf) {
        StyleAttributes sa = Styles.getEmptySA();
        ShareStyleAttributes defaultssa = Styles.getDefaultSSA();
        if (null != dxf.getFont()) {
            this.font2SA(defaultssa, sa, new XSSFFont(dxf.getFont()));
        }
        if (dxf.isSetAlignment()) {
            XSSFCellAlignment cellAlignment = new XSSFCellAlignment(dxf.getAlignment());
            this.alignment2SA(defaultssa, sa, cellAlignment.getHorizontal(), cellAlignment.getVertical(), cellAlignment.getWrapText(), (short)cellAlignment.getTextRotation());
        }
        if (dxf.isSetFill()) {
            XSSFCellFill xssfCellFill = new XSSFCellFill();
            this.interior2SA(defaultssa, sa, xssfCellFill);
        }
        return sa;
    }

    public short getFillPattern(XSSFCellFill xssfCellFill) {
        STPatternType.Enum ptrn = xssfCellFill.getPatternType();
        if (ptrn == null) {
            return FillPatternType.NO_FILL.getCode();
        }
        return (short)(ptrn.intValue() - 1);
    }

    private void interior2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellFill cellFill) {
        short backmode = this.getFillPattern(cellFill);
        Pattern pn = this.getkdpattern(backmode);
        XSSFColor fillForegroundColor = cellFill.getFillForegroundColor();
        XSSFColor fillBackgroundColor = cellFill.getFillBackgroundColor();
        if (null != fillForegroundColor) {
            double tint;
            Color awtcolor = this.getAWTColor(fillForegroundColor.getIndexed());
            if (!defaultssa.getBackground().equals(awtcolor)) {
                sa.setBackground(awtcolor);
            }
            if ((tint = fillForegroundColor.getTint()) == 0.0) {
                sa.setBackground(this.wrapperColor(fillForegroundColor));
            } else {
                byte[] rgbWithTint = fillForegroundColor.getRGBWithTint();
                sa.setBackground(new Color(this.changeRGB(rgbWithTint[0]), this.changeRGB(rgbWithTint[1]), this.changeRGB(rgbWithTint[2])));
            }
        } else if (null != fillBackgroundColor) {
            double tint;
            Color awtcolor = this.getAWTColor(fillBackgroundColor.getIndexed());
            if (!defaultssa.getBackground().equals(awtcolor)) {
                sa.setBackground(awtcolor);
            }
            if ((tint = fillBackgroundColor.getTint()) == 0.0) {
                sa.setBackground(this.wrapperColor(fillBackgroundColor));
            } else {
                byte[] rgbWithTint = fillBackgroundColor.getRGBWithTint();
                sa.setBackground(new Color(this.changeRGB(rgbWithTint[0]), this.changeRGB(rgbWithTint[1]), this.changeRGB(rgbWithTint[2])));
            }
            if (Pattern.None == pn) {
                pn = Pattern.Solid;
            }
        }
        sa.setPattern(pn);
    }

    private StyleAttributes parseKDStyleAttributes(XSSFCellStyle cellStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        ShareStyleAttributes defaultssa = Styles.getDefaultSSA();
        if (this.importStyle) {
            XSSFFont xssfFont = cellStyle.getFont();
            this.font2SA(defaultssa, sa, xssfFont);
            this.alignment2SA(defaultssa, sa, cellStyle.getAlignmentEnum(), cellStyle.getVerticalAlignmentEnum(), cellStyle.getWrapText(), cellStyle.getRotation());
            this.protection2SA(defaultssa, sa, cellStyle);
            this.borders2SA(defaultssa, sa, cellStyle);
            this.interior2SA(defaultssa, sa, cellStyle);
        }
        if (this.importFormat && cellStyle.getDataFormat() != 0) {
            try {
                String format = cellStyle.getDataFormatString();
                if (!StringUtil.isEmptyString((String)format) && format.indexOf(40) == 0 && format.indexOf("_);") != -1) {
                    format = format.substring(1);
                }
                sa.setNumberFormat(format);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return sa;
    }

    private void interior2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        short backmode = cellStyle.getFillPattern().getCode();
        Pattern pn = this.getkdpattern(backmode);
        if (pn != Pattern.None) {
            if (pn == Pattern.Solid) {
                double tint;
                Color awtcolor = this.getAWTColor(cellStyle.getFillForegroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                if ((tint = cellStyle.getFillForegroundXSSFColor().getTint()) == 0.0) {
                    sa.setBackground(this.wrapperColor(cellStyle.getFillForegroundXSSFColor()));
                } else {
                    byte[] rgbWithTint = cellStyle.getFillForegroundXSSFColor().getRGBWithTint();
                    sa.setBackground(new Color(this.changeRGB(rgbWithTint[0]), this.changeRGB(rgbWithTint[1]), this.changeRGB(rgbWithTint[2])));
                }
            } else {
                double tint;
                Color awtcolor = this.getAWTColor(cellStyle.getFillBackgroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                if ((tint = cellStyle.getFillForegroundXSSFColor().getTint()) == 0.0) {
                    sa.setBackground(this.wrapperColor(cellStyle.getFillForegroundXSSFColor()));
                } else {
                    byte[] rgbWithTint = cellStyle.getFillForegroundXSSFColor().getRGBWithTint();
                    sa.setBackground(new Color(this.changeRGB(rgbWithTint[0]), this.changeRGB(rgbWithTint[1]), this.changeRGB(rgbWithTint[2])));
                }
                awtcolor = this.getAWTColor(cellStyle.getFillForegroundColor(), Color.WHITE);
                if (!defaultssa.getPatternColor().equals(awtcolor)) {
                    sa.setPatternColor(awtcolor);
                }
            }
        }
        sa.setPattern(pn);
    }

    private int changeRGB(int number) {
        return ((number & 0xF0) >> 4) * 16 + (number & 0xF);
    }

    private Color getAWTColor(short index, Color deflt) {
        HSSFColor clr = (HSSFColor)this.colors.get(new Integer(index));
        if (clr == null) {
            return deflt;
        }
        return this.getAWTColor(clr);
    }

    private Color getAWTColor(int index) {
        HSSFColor clr = (HSSFColor)this.colors.get(new Integer(index));
        if (clr == null) {
            return null;
        }
        return this.getAWTColor(clr);
    }

    private Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private Pattern getkdpattern(short backmode) {
        Pattern pn;
        switch (backmode) {
            case 1: {
                pn = Pattern.Solid;
                break;
            }
            case 2: {
                pn = Pattern.Percent50;
                break;
            }
            case 3: {
                pn = Pattern.Percent25;
                break;
            }
            case 4: {
                pn = Pattern.Percent70;
                break;
            }
            case 5: {
                pn = Pattern.DarkHorizontal;
                break;
            }
            case 6: {
                pn = Pattern.DarkVertical;
                break;
            }
            case 7: {
                pn = Pattern.DarkDownwardDiagonal;
                break;
            }
            case 8: {
                pn = Pattern.DarkUpwardDiagonal;
                break;
            }
            case 9: {
                pn = Pattern.SmallCheckerBoard;
                break;
            }
            case 10: {
                pn = Pattern.Trellis;
                break;
            }
            case 11: {
                pn = Pattern.Percent60;
                break;
            }
            case 12: {
                pn = Pattern.LightVertical;
                break;
            }
            case 13: {
                pn = Pattern.LightDownwardDiagonal;
                break;
            }
            case 14: {
                pn = Pattern.LightUpwardDiagonal;
                break;
            }
            case 15: {
                pn = Pattern.SmallGrid;
                break;
            }
            case 16: {
                pn = Pattern.Percent30;
                break;
            }
            case 17: {
                pn = Pattern.Percent20;
                break;
            }
            case 18: {
                pn = Pattern.Percent10;
                break;
            }
            default: {
                pn = Pattern.None;
            }
        }
        return pn;
    }

    private void borders2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        this.getBorderColor(sa, cellStyle, XSSFCellBorder.BorderSide.BOTTOM, 3);
        this.getBorderColor(sa, cellStyle, XSSFCellBorder.BorderSide.LEFT, 0);
        this.getBorderColor(sa, cellStyle, XSSFCellBorder.BorderSide.TOP, 1);
        this.getBorderColor(sa, cellStyle, XSSFCellBorder.BorderSide.RIGHT, 2);
        Excel2007Reader.borderstyle2sa(sa, Styles.Position.BOTTOM, cellStyle.getBorderBottom().getCode());
        Excel2007Reader.borderstyle2sa(sa, Styles.Position.LEFT, cellStyle.getBorderLeft().getCode());
        Excel2007Reader.borderstyle2sa(sa, Styles.Position.RIGHT, cellStyle.getBorderRight().getCode());
        Excel2007Reader.borderstyle2sa(sa, Styles.Position.TOP, cellStyle.getBorderTop().getCode());
    }

    private void getBorderColor(StyleAttributes sa, XSSFCellStyle cellStyle, XSSFCellBorder.BorderSide side, int pos) {
        XSSFColor borderColor = cellStyle.getBorderColor(side);
        if (null != borderColor) {
            switch (pos) {
                case 0: {
                    sa.setBorderColor(Styles.Position.LEFT, this.wrapperColor(borderColor));
                    break;
                }
                case 2: {
                    sa.setBorderColor(Styles.Position.RIGHT, this.wrapperColor(borderColor));
                    break;
                }
                case 3: {
                    sa.setBorderColor(Styles.Position.BOTTOM, this.wrapperColor(borderColor));
                    break;
                }
                case 1: {
                    sa.setBorderColor(Styles.Position.TOP, this.wrapperColor(borderColor));
                }
            }
        }
    }

    private Color wrapperColor(XSSFColor borderColor) {
        if (null == borderColor || borderColor.getARGBHex() == null) {
            return null;
        }
        Color color = new Color(0, 0, 0);
        color = ColorUtil.parseColor((String)("#" + borderColor.getARGBHex().substring(2)));
        return color;
    }

    static void borderstyle2sa(StyleAttributes sa, Styles.Position pos, short hssfborder) {
        if (hssfborder == BorderStyle.NONE.getCode()) {
            sa.setBorderLineStyle(pos, LineStyle.NULL_LINE);
        } else if (hssfborder == BorderStyle.THIN.getCode()) {
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
        } else if (hssfborder == BorderStyle.DASH_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DASH_DOT_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DASHED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.DOTTED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_CONTINUOUS);
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
        } else if (hssfborder == BorderStyle.MEDIUM.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASHED.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASH_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else if (hssfborder == BorderStyle.MEDIUM_DASH_DOT_DOT.getCode()) {
            sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
        } else {
            sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
        }
    }

    private void protection2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFCellStyle cellStyle) {
        boolean bLock = cellStyle.getLocked();
        if (defaultssa.isLocked() != bLock) {
            sa.setLocked(bLock);
        }
        boolean bhide = cellStyle.getHidden();
        if (defaultssa.isHided() != bhide) {
            sa.setHided(bhide);
        }
    }

    private void alignment2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HorizontalAlignment hAlignment, VerticalAlignment vAlignment, boolean isWraptext, short roration) {
        Styles.VerticalAlignment valign;
        Styles.HorizontalAlignment align;
        switch (hAlignment.ordinal()) {
            case 1: {
                align = Styles.HorizontalAlignment.LEFT;
                break;
            }
            case 2: {
                align = Styles.HorizontalAlignment.CENTER;
                break;
            }
            case 3: {
                align = Styles.HorizontalAlignment.RIGHT;
                break;
            }
            default: {
                align = null;
            }
        }
        if (align != null) {
            sa.setHorizontalAlign(align);
        }
        switch (vAlignment.ordinal()) {
            case 0: {
                valign = Styles.VerticalAlignment.TOP;
                break;
            }
            case 1: {
                valign = Styles.VerticalAlignment.MIDDLE;
                break;
            }
            case 2: {
                valign = Styles.VerticalAlignment.BOTTOM;
                break;
            }
            default: {
                valign = Styles.VerticalAlignment.BOTTOM;
            }
        }
        if (defaultssa.getVerticalAlign() != valign) {
            sa.setVerticalAlign(valign);
        }
        if (defaultssa.isWrapText() != isWraptext) {
            sa.setWrapText(isWraptext);
        }
        if (defaultssa.getRotation() != roration) {
            sa.setRotation((int)roration);
        }
    }

    private void font2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, XSSFFont hssffont) {
        String fontName = hssffont.getFontName();
        if (!defaultssa.getFontName().equals(fontName)) {
            sa.setFontName(fontName);
        }
        short fontSize = hssffont.getFontHeightInPoints();
        sa.setFontSize((int)fontSize);
        XSSFColor xssfColor = hssffont.getXSSFColor();
        if (xssfColor != null) {
            sa.setFontColor(this.wrapperColor(xssfColor));
        } else {
            Color awtclr = this.getAWTColor(hssffont.getColor(), Color.BLACK);
            if (!defaultssa.getFontColor().equals(awtclr)) {
                sa.setFontColor(awtclr);
            }
        }
        boolean bvalue = hssffont.getBold();
        if (defaultssa.isBold() != bvalue) {
            sa.setBold(bvalue);
        }
        bvalue = hssffont.getItalic();
        if (defaultssa.isItalic() != bvalue) {
            sa.setItalic(bvalue);
        }
        bvalue = hssffont.getStrikeout();
        if (defaultssa.isStrikeThrough() != bvalue) {
            sa.setStrikeThrough(bvalue);
        }
        boolean bl = bvalue = hssffont.getUnderline() != 0;
        if (defaultssa.isUnderline() != bvalue) {
            sa.setUnderline(bvalue);
        }
    }

    public MessagedValidateVO getValidate() {
        return (MessagedValidateVO)this.tempCache.get(currentDataValidation);
    }

    public void setValidate(MessagedValidateVO validateVO) {
        this.tempCache.put(currentDataValidation, validateVO);
    }

    public ConditionalFormatVO getConditionFormat() {
        return (ConditionalFormatVO)this.tempCache.get(currentConditionalFormating);
    }

    public List<ConditionVO> getCondition() {
        return (List)this.tempCache.get(currentRule);
    }

    public List<ShareStyleAttributes> getStyle() {
        return (List)this.tempCache.get(currentDxfId);
    }

    public List<String> getFormula() {
        return (List)this.tempCache.get(currentFormula);
    }

    public void setConditionFormat(ConditionalFormatVO format) {
        this.tempCache.put(currentConditionalFormating, format);
    }

    public void addCondition(ConditionVO condition) {
        List<ConditionVO> conditions = this.getCondition();
        if (null == conditions) {
            conditions = new ArrayList<ConditionVO>();
            this.tempCache.put(currentRule, conditions);
        }
        conditions.add(condition);
    }

    public void addStyle(ShareStyleAttributes ssa) {
        List<ShareStyleAttributes> ssAttributes = this.getStyle();
        if (null == ssAttributes) {
            ssAttributes = new ArrayList<ShareStyleAttributes>();
            this.tempCache.put(currentDxfId, ssAttributes);
        }
        ssAttributes.add(ssa);
    }

    public void addFormula(String formula) {
        List<String> formulas = this.getFormula();
        if (null == formulas) {
            formulas = new ArrayList<String>();
            this.tempCache.put(currentFormula, formulas);
        }
        formulas.add(formula);
    }

    public void clearConditions() {
        this.tempCache.remove(currentRule);
    }

    public void clearStyles() {
        this.tempCache.remove(currentDxfId);
    }

    public void clearFormulas() {
        this.tempCache.remove(currentFormula);
    }

    private static int getSplitPaneIndex(String paneName) {
        int ret = 3;
        switch (paneName) {
            case "bottomLeft": {
                ret = 2;
                break;
            }
            case "topRight": {
                ret = 1;
                break;
            }
            case "topLeft": {
                ret = 0;
                break;
            }
        }
        return ret;
    }

    private static int getColumnIndexByName(String name) {
        int index = 0;
        char[] chars = name.toCharArray();
        int rate = 1;
        char A = 'A';
        for (int i = chars.length - 1; i >= 0; --i) {
            char bit = chars[i];
            if (bit < A || bit > 'z') continue;
            index += (bit - A + 1) * rate;
            rate *= 26;
        }
        return --index;
    }

    private static int getRowIndexByName(String name) {
        char[] chars = name.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char bit = chars[i];
            if (!Character.isDigit(bit)) continue;
            sb.append(bit);
        }
        return Integer.parseInt(sb.toString());
    }

    private boolean isFormula(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        char head = str.charAt(0);
        return '=' == head || head > '9';
    }

    private String convert2BookFormula(String str) {
        String result = null;
        result = this.isFormula(str) && str.charAt(0) != '=' ? '=' + str : str;
        return result;
    }

    class PaneHandler
    extends DefaultHandler {
        PaneHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String topLeftCell = attributes.getValue("topLeftCell");
            String state = attributes.getValue("state");
            if ("frozen".equals(state)) {
                String ap;
                String yp;
                ViewSplitInfoVO info = new ViewSplitInfoVO();
                info.setFreezed(true);
                String xp = attributes.getValue("xSplit");
                if (null != xp) {
                    info.setColSplit((int)Float.parseFloat(xp));
                }
                if (null != (yp = attributes.getValue("ySplit"))) {
                    info.setRowSplit((int)Float.parseFloat(yp));
                }
                if (null != topLeftCell) {
                    info.setColFixLine(Excel2007Reader.getColumnIndexByName(topLeftCell));
                    info.setRowFixLine(Excel2007Reader.getRowIndexByName(topLeftCell));
                }
                if (null != (ap = attributes.getValue("activePane"))) {
                    info.setActivePane(Excel2007Reader.getSplitPaneIndex(ap));
                }
                Excel2007Reader.this.kdSheet.setViewSplitInfo(info);
            }
        }
    }

    class DataValidation
    extends DefaultHandler {
        DataValidation() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            MessagedValidateVO validateVO = new MessagedValidateVO();
            String validateType = attributes.getValue("type");
            String operator = attributes.getValue("operator");
            StringBuilder builder = new StringBuilder();
            builder.append(Character.toUpperCase(validateType.charAt(0)));
            builder.append(validateType.subSequence(1, validateType.length()));
            validateVO.setType(builder.toString());
            validateVO.setOperator(CompareOnOperatorMapping.getQualifier(operator));
            validateVO.setAllowBlank(Boolean.valueOf(attributes.getValue("allowBlank")).booleanValue());
            String errorStyle = attributes.getValue("errorStyle");
            validateVO.setErrorStyle(StringUtil.isEmptyString((String)errorStyle) ? "stop" : errorStyle);
            validateVO.setShowErrorMessage(Boolean.valueOf(attributes.getValue("showErrorMessage")).booleanValue());
            validateVO.setShowInputMessage(Boolean.valueOf(attributes.getValue("showInputMessage")).booleanValue());
            String errorTitle = attributes.getValue("errorTitle");
            validateVO.setErrorTitle(StringUtil.isEmptyString((String)errorTitle) ? "" : errorTitle);
            String error = attributes.getValue("error");
            validateVO.setError(StringUtil.isEmptyString((String)error) ? "" : error);
            String prompt = attributes.getValue("prompt");
            validateVO.setPrompt(StringUtil.isEmptyString((String)prompt) ? "" : prompt);
            String promptTitle = attributes.getValue("promptTitle");
            validateVO.setPromptTitle(StringUtil.isEmptyString((String)promptTitle) ? "" : promptTitle);
            validateVO.setSqref(attributes.getValue("sqref"));
            Excel2007Reader.this.setValidate(validateVO);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            MessagedValidateVO validateVO = Excel2007Reader.this.getValidate();
            List<String> formulas = Excel2007Reader.this.getFormula();
            String formula1 = formulas.get(0);
            formula1 = formula1.charAt(0) == '\"' ? Excel2007Reader.this.convert2BookFormula(formula1).replace("\"", "") : Excel2007Reader.this.convert2BookFormula(formula1);
            validateVO.setMin(formula1);
            if (formulas.size() == 2) {
                validateVO.setMax(Excel2007Reader.this.convert2BookFormula(formulas.get(1)));
            }
            Excel2007Reader.this.clearFormulas();
            Excel2007Reader.this.kdSheet.getMessagedValidateVOs().add(validateVO);
        }
    }

    class CellHandler
    extends DefaultHandler {
        CellHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String hidden;
            String collapsed;
            if ("sheetFormatPr".equals(name)) {
                Excel2007Reader.this.defaultRowHeight = Float.parseFloat(attributes.getValue("defaultRowHeight"));
            }
            if ("col".equals(name)) {
                Excel2007Reader.this.defaultColWidth = Float.parseFloat(attributes.getValue("width"));
                String colId = attributes.getValue("max");
                Excel2007Reader.this.curCol = Integer.parseInt(colId) - 1;
                String outLevel = attributes.getValue("outlineLevel");
                if (!StringUtil.isEmptyString((String)outLevel)) {
                    String min = attributes.getValue("min");
                    collapsed = attributes.getValue("collapsed");
                    hidden = attributes.getValue("hidden");
                    KDSAttributeSpan span = new KDSAttributeSpan(Integer.parseInt(min) - 1, Integer.parseInt(colId) - 1, null, (int)StyleUtil.unitToMM((double)Excel2007Reader.this.defaultColWidth), !"1".equals(hidden), Integer.parseInt(outLevel), "1".equals(collapsed));
                    if (null == Excel2007Reader.this.kdSheet.getColSpans()) {
                        Excel2007Reader.this.kdSheet.setColSpans(new ArrayList());
                    }
                    Excel2007Reader.this.kdSheet.getColSpans().add(span);
                    Excel2007Reader.this.kdSheet.getColumn(Excel2007Reader.this.curCol, true);
                } else {
                    Excel2007Reader.this.kdSheet.getColumns().setColumnWidth(Excel2007Reader.this.curCol, (float)StyleUtil.unitToMM((double)Excel2007Reader.this.defaultColWidth));
                }
            }
            if ("row".equals(name)) {
                String rowId = attributes.getValue("r");
                Excel2007Reader.this.curRow = Integer.parseInt(rowId) - 1;
                String rowHeight = attributes.getValue("ht");
                String outlineLevel = attributes.getValue("outlineLevel");
                if (null != outlineLevel || rowHeight != null) {
                    collapsed = attributes.getValue("collapsed");
                    hidden = attributes.getValue("hidden");
                    int level = 0;
                    if (null != outlineLevel) {
                        level = Integer.parseInt(outlineLevel);
                    }
                    int h = null == rowHeight ? 0 : (int)(StyleUtil.ptToLom((double)Float.parseFloat(rowHeight)) / 10.0);
                    KDSAttributeSpan span = new KDSAttributeSpan(Excel2007Reader.this.curRow, Excel2007Reader.this.curRow, null, h, !"1".equals(hidden), level, "1".equals(collapsed));
                    if (null == Excel2007Reader.this.kdSheet.getRowSpans()) {
                        Excel2007Reader.this.kdSheet.setRowSpans(new ArrayList());
                    }
                    Excel2007Reader.this.kdSheet.getRowSpans().add(span);
                    Excel2007Reader.this.kdSheet.getRow(Excel2007Reader.this.curRow, true);
                } else {
                    Excel2007Reader.this.kdSheet.getRows().setRowHeight(Excel2007Reader.this.curRow, (float)(StyleUtil.ptToLom((double)Excel2007Reader.this.defaultRowHeight) / 10.0));
                }
            }
            if ("c".equals(name)) {
                String cellType = attributes.getValue("t");
                Excel2007Reader.this.isInLineStr = "inlineStr".equals(cellType);
                Excel2007Reader.this.stylesIndex = attributes.getValue("s");
                Excel2007Reader.this.curCell = attributes.getValue("r");
                Excel2007Reader.this.curCol = Excel2007Reader.this.calCellColumn(Excel2007Reader.this.curCell) - 1;
                if (cellType != null && (cellType.equals("s") || "inlineStr".equals(cellType))) {
                    Excel2007Reader.this.nextIsString = true;
                } else {
                    Excel2007Reader.this.nextIsString = false;
                }
                if (cellType != null && cellType.equals("b")) {
                    Excel2007Reader.this.nextIsBoolean = true;
                } else {
                    Excel2007Reader.this.nextIsBoolean = false;
                }
            }
            if (Excel2007Reader.this.importFormula && "f".equals(name)) {
                Excel2007Reader.this.hasBeenShared = false;
                Excel2007Reader.this.hasShared = false;
                String formulaType = attributes.getValue("t");
                if (formulaType != null && "shared".equals(formulaType.trim())) {
                    String ref = attributes.getValue("ref");
                    Excel2007Reader.this.sharedIdentity = attributes.getValue("si");
                    if (Excel2007Reader.this.sharedFormulas == null) {
                        Excel2007Reader.this.sharedFormulas = new HashMap();
                    }
                    if (Excel2007Reader.this.srcCells == null) {
                        Excel2007Reader.this.srcCells = new HashMap();
                    }
                    if (ref != null && !StringUtil.isEmptyString((String)ref)) {
                        Excel2007Reader.this.hasBeenShared = true;
                    } else {
                        Excel2007Reader.this.hasShared = true;
                    }
                }
            }
            if ("mergeCell".equals(name)) {
                String[] mergeCellStrs = attributes.getValue("ref").split(":");
                Excel2007Reader.this.parseMergeCell(mergeCellStrs);
            }
            Excel2007Reader.this.lastContents = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            Excel2007Reader.this.lastContents = Excel2007Reader.this.lastContents + new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (Excel2007Reader.this.nextIsString && "v".equals(name)) {
                try {
                    if (StringUtil.isNumber((String)Excel2007Reader.this.lastContents)) {
                        int idx = Integer.parseInt(Excel2007Reader.this.lastContents);
                        Excel2007Reader.this.lastContents = new XSSFRichTextString(Excel2007Reader.this.sst.getEntryAt(idx)).toString();
                        Excel2007Reader.this.type = (short)1;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Excel2007Reader.this.nextIsBoolean) {
                Excel2007Reader.this.type = (short)4;
            }
            if (Excel2007Reader.this.isInLineStr) {
                Excel2007Reader.this.type = (short)1;
                Excel2007Reader.this.value = Excel2007Reader.this.lastContents;
            } else if (!StringUtil.isEmptyString((String)Excel2007Reader.this.lastContents) && ("v".equals(name) || "t".equals(name))) {
                Excel2007Reader.this.value = Excel2007Reader.this.lastContents.trim();
                if (!StringUtils.isEmpty((String)Excel2007Reader.this.stylesIndex)) {
                    XSSFCellStyle cellStyle = Excel2007Reader.this.stylesTable.getStyleAt(Integer.parseInt(Excel2007Reader.this.stylesIndex));
                    short formatIndex = cellStyle.getDataFormat();
                    String formatString = cellStyle.getDataFormatString();
                    if (formatString == null) {
                        formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                    }
                    if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
                        try {
                            DateUtil.isValidExcelDate((double)Double.parseDouble((String)Excel2007Reader.this.value));
                            Date date = DateUtil.getJavaDate((double)Double.parseDouble((String)Excel2007Reader.this.value));
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            Excel2007Reader.this.value = simpleDateFormat.format(date);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (!Excel2007Reader.this.nextIsString) {
                        long numFmtId = cellStyle.getCoreXf().getNumFmtId();
                        String formatAt = Excel2007Reader.this.stylesTable.getNumberFormatAt((short)numFmtId);
                        if (numFmtId == 176L && formatAt != null) {
                            int scale = 0;
                            int tempIndex = formatAt.indexOf(".");
                            if (tempIndex != -1) {
                                ++tempIndex;
                                while (tempIndex < formatAt.length() && Character.isDigit(formatAt.charAt(tempIndex))) {
                                    ++tempIndex;
                                    ++scale;
                                }
                            }
                            if (StringUtil.isExcelNumber((String)Excel2007Reader.this.lastContents) && Excel2007Reader.this.lastContents.substring(Excel2007Reader.this.lastContents.indexOf(".") + 1).length() >= scale) {
                                try {
                                    BigDecimal bd = new BigDecimal(Excel2007Reader.this.lastContents);
                                    Excel2007Reader.this.lastContents = bd.setScale(scale, RoundingMode.HALF_UP).toString();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        Excel2007Reader.this.value = NumberUtil.cutZero((String)Excel2007Reader.this.lastContents.trim());
                    }
                }
            }
            if ((Excel2007Reader.this.importFormula = true) && "f".equals(name)) {
                if (!Excel2007Reader.this.hasShared) {
                    Excel2007Reader.this.formula = Excel2007Reader.this.lastContents.trim();
                    String[] returnValue = Excel2007Reader.this.convertFormula(Excel2007Reader.this.formula);
                    if (returnValue[1].equals("1")) {
                        Excel2007Reader.this.value = returnValue[2];
                    }
                    Excel2007Reader.this.formula = returnValue[0];
                    if (Excel2007Reader.this.hasBeenShared && !returnValue[1].equals("1")) {
                        Parser parser = new Parser();
                        parser.parse(Excel2007Reader.this.formula);
                        Excel2007Reader.this.sharedFormulas.put(Excel2007Reader.this.sharedIdentity, parser);
                        Excel2007Reader.this.srcCells.put(Excel2007Reader.this.sharedIdentity, Excel2007Reader.this.curCell);
                    }
                    if (Excel2007Reader.this.hasBeenShared && returnValue[1].equals("1")) {
                        if (Excel2007Reader.this.sameFormulas == null) {
                            Excel2007Reader.this.sameFormulas = new HashMap();
                        }
                        Excel2007Reader.this.sameFormulas.put(Excel2007Reader.this.sharedIdentity, Excel2007Reader.this.formula);
                    }
                } else if (Excel2007Reader.this.sameFormulas != null && Excel2007Reader.this.sameFormulas.get(Excel2007Reader.this.sharedIdentity) != null) {
                    Excel2007Reader.this.formula = String.valueOf(Excel2007Reader.this.sameFormulas.get(Excel2007Reader.this.sharedIdentity));
                } else {
                    Excel2007Reader.this.formula = Excel2007Reader.this.calFormula((Parser)Excel2007Reader.this.sharedFormulas.get(Excel2007Reader.this.sharedIdentity), String.valueOf(Excel2007Reader.this.srcCells.get(Excel2007Reader.this.sharedIdentity)), Excel2007Reader.this.curCell);
                }
                Excel2007Reader.this.type = (short)2;
            }
            if ("c".equals(name)) {
                ICells kdCells = Excel2007Reader.this.kdSheet.getCells();
                XSSFCellStyle cellStyle = null;
                StyleAttributes kdsa = null;
                if (!StringUtils.isEmpty((String)Excel2007Reader.this.stylesIndex)) {
                    if (Excel2007Reader.this.styles == null) {
                        Excel2007Reader.this.styles = new HashMap();
                    }
                    if ((kdsa = (StyleAttributes)Excel2007Reader.this.styles.get(Excel2007Reader.this.stylesIndex)) == null) {
                        cellStyle = Excel2007Reader.this.stylesTable.getStyleAt(Integer.parseInt(Excel2007Reader.this.stylesIndex));
                        kdsa = Excel2007Reader.this.parseKDStyleAttributes(cellStyle);
                        Excel2007Reader.this.styles.put(Excel2007Reader.this.stylesIndex, kdsa);
                    }
                }
                KDSCell kdCell = null;
                kdCell = kdsa != null && !kdsa.isEmpty() ? kdCells.setCell(Excel2007Reader.this.curRow, Excel2007Reader.this.curCol, Excel2007Reader.this.value, Excel2007Reader.this.formula, Styles.getSSA((StyleAttributes)kdsa)) : kdCells.setCellValue(Excel2007Reader.this.curRow, Excel2007Reader.this.curCol, Excel2007Reader.this.value);
                kdCell.setType(Excel2007Reader.this.type);
                if (Excel2007Reader.this.formula != null) {
                    Excel2007Reader.this.kdSheet.getCell(Excel2007Reader.this.curRow, Excel2007Reader.this.curCol, true).setFormula(Excel2007Reader.this.formula);
                } else {
                    kdCells.setCellValue(Excel2007Reader.this.curRow, Excel2007Reader.this.curCol, Excel2007Reader.this.value);
                }
                kdCell.setType(Excel2007Reader.this.type);
                Excel2007Reader.this.value = null;
                Excel2007Reader.this.formula = null;
                Excel2007Reader.this.stylesIndex = null;
                Excel2007Reader.this.type = (short)0;
            }
            if ("sheetData".equals(name)) {
                Excel2007Reader.this.styles.clear();
            }
        }
    }

    class FormulaHandler
    extends DefaultHandler {
        private StringBuilder builder = new StringBuilder();

        FormulaHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Excel2007Reader.this.addFormula(this.builder.toString());
            this.builder = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.builder.append(ch, start, length);
        }
    }

    private class InLineStrHandler
    extends DefaultHandler {
        private StringBuilder strBuffer = new StringBuilder();

        private InLineStrHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.strBuffer = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (Excel2007Reader.this.isInLineStr) {
                this.strBuffer.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Excel2007Reader.this.lastContents = this.strBuffer.toString();
        }
    }

    class ConditionHandler
    extends DefaultHandler {
        ConditionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String qualifier;
            String dfxId = attributes.getValue("dxfId");
            StyleAttributes styleAttributes = (StyleAttributes)Excel2007Reader.this.styles.get(dfxId);
            if (null == styleAttributes) {
                CTDxf cellStyle = Excel2007Reader.this.stylesTable.getDxfAt(Integer.parseInt(dfxId));
                styleAttributes = Excel2007Reader.this.parseKDStyleAttributes(cellStyle);
                Excel2007Reader.this.styles.put(Excel2007Reader.this.stylesIndex, styleAttributes);
            }
            Excel2007Reader.this.addStyle((ShareStyleAttributes)styleAttributes);
            ConditionVO condition = new ConditionVO();
            String conditionType = attributes.getValue("type");
            if ("expression".equals(conditionType)) {
                condition.setType(Condition.Type_Formula);
            }
            if (!StringUtil.isEmptyString((String)(qualifier = attributes.getValue("operator")))) {
                condition.setQualifier(CompareOnOperatorMapping.getQualifier(qualifier));
            }
            Excel2007Reader.this.addCondition(condition);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ConditionVO condition = Excel2007Reader.this.getCondition().get(Excel2007Reader.this.getCondition().size() - 1);
            List<String> formulas = Excel2007Reader.this.getFormula();
            if (formulas.size() == 1) {
                condition.setMin(Excel2007Reader.this.convert2BookFormula(formulas.get(0)));
            } else {
                condition.setMin(Excel2007Reader.this.convert2BookFormula(formulas.get(0)));
                condition.setMax(Excel2007Reader.this.convert2BookFormula(formulas.get(1)));
            }
            Excel2007Reader.this.clearFormulas();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }

    class ConditionalFormatHandler
    extends DefaultHandler {
        ConditionalFormatHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String sqref = attributes.getValue("sqref");
            ConditionalFormatVO format = new ConditionalFormatVO();
            format.setSqref(sqref);
            Excel2007Reader.this.setConditionFormat(format);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ConditionalFormatVO format = Excel2007Reader.this.getConditionFormat();
            format.setShareStyleAttributes(Excel2007Reader.this.getStyle());
            format.setCondtionVOs(Excel2007Reader.this.getCondition());
            Excel2007Reader.this.kdSheet.getConditionFromats().add(format);
            Excel2007Reader.this.clearConditions();
            Excel2007Reader.this.clearStyles();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }

    class XlsxContentHander
    extends DefaultHandler {
        private Deque<ContentHandler> handlerStack = new LinkedList<ContentHandler>();
        private Map<String, ContentHandler> contentHanderRegister = new HashMap<String, ContentHandler>();

        XlsxContentHander() {
        }

        public void registerHandler(String qName, ContentHandler handler) {
            this.contentHanderRegister.put(qName, handler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ContentHandler handler = this.contentHanderRegister.get(qName);
            if (null != handler) {
                this.handlerStack.push(handler);
                handler.startElement(uri, localName, qName, attributes);
            } else {
                this.handlerStack.push(new DefaultHandler());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ContentHandler handler = this.handlerStack.pop();
            if (null != handler) {
                handler.endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ContentHandler handler = this.handlerStack.pop();
            if (null != handler) {
                handler.characters(ch, start, length);
                this.handlerStack.push(handler);
            }
        }
    }
}

