/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.collection;

import java.util.Comparator;
import java.util.Iterator;

public class QTree {
    private static final DefaultComparator _defaultComparator = new DefaultComparator();
    private Node _root;
    private int _ops;
    private transient Comparator _cmp = _defaultComparator;
    private QTreeIterator _qi = new QTreeIterator();

    public QTreeIterator getIterator(Object from, Object end, boolean descent) {
        this._qi.init(from, end, descent);
        return this._qi;
    }

    public int size() {
        return this._root == null ? 0 : this._root._size;
    }

    Node search(Object key) {
        Node t = this._root;
        while (t != null) {
            int cmp = this._cmp.compare(key, t._key);
            if (cmp == 0) {
                return t;
            }
            t = cmp < 0 ? t._left : t._right;
        }
        return null;
    }

    private Node insert(Node t, Node x) {
        if (t == null) {
            t = x;
            this._ops = x._size;
        } else {
            int cmp = this._cmp.compare(x._key, t._key);
            if (cmp != 0) {
                if (cmp < 0) {
                    t._left = this.insert(t._left, x);
                } else {
                    t._right = this.insert(t._right, x);
                }
                t._size += this._ops;
                t = this.maintain(t, cmp > 0);
            }
        }
        return t;
    }

    void insert(Node x) {
        this._ops = 0;
        this._root = this.insert(this._root, x);
    }

    private Node delete(Node t, Object key) {
        if (t == null) {
            return null;
        }
        int cmp = this._cmp.compare(key, t._key);
        if (cmp == 0) {
            if ((t = this.deleteNode(t)) != null) {
                --t._size;
            }
            this._ops = 1;
        } else {
            if (cmp < 0) {
                t._left = this.delete(t._left, key);
            } else {
                t._right = this.delete(t._right, key);
            }
            t._size -= this._ops;
        }
        return t;
    }

    public void delete(Object key) {
        this._ops = 0;
        this._root = this.delete(this._root, key);
    }

    private Node deleteNode(Node t) {
        Object replacementItem;
        if (t._left == null) {
            return t._right == null ? null : t._right;
        }
        if (t._right == null) {
            return t._left;
        }
        t._key = replacementItem = this.findLeftmost(t._right);
        t._right = this.deleteLeftmost(t._right);
        return t;
    }

    private Object findLeftmost(Node t) {
        if (t._left == null) {
            return t._key;
        }
        return this.findLeftmost(t._left);
    }

    private Node deleteLeftmost(Node t) {
        if (t._left == null) {
            return t._right;
        }
        t._left = this.deleteLeftmost(t._left);
        return t;
    }

    public Node prev(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) <= 0) {
            return this.prev(t._left, key);
        }
        Node prev = this.prev(t._right, key);
        return prev == null ? t : prev;
    }

    public Node next(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) >= 0) {
            return this.next(t._right, key);
        }
        Node next = this.next(t._left, key);
        return next == null ? t : next;
    }

    public Node select(Node t, int i) {
        if (t == null || i > t._size) {
            return null;
        }
        int r = (t._left == null ? 0 : t._left._size) + 1;
        if (i == r) {
            return t;
        }
        if (i < r) {
            return this.select(t._left, i);
        }
        return this.select(t._right, i - r);
    }

    public int rank(Node t, Object key) {
        if (t == null) {
            return 0;
        }
        int cmp = this._cmp.compare(key, t._key);
        if (cmp == 0) {
            return (t._left == null ? 0 : t._left._size) + 1;
        }
        if (cmp < 0) {
            return this.rank(t._left, key);
        }
        int r = this.rank(t._right, key);
        return r == 0 ? 0 : r + (t._left == null ? 0 : t._left._size) + 1;
    }

    public Object max() {
        Node node = this.max(this._root);
        return node == null ? null : node._key;
    }

    public Node max(Node t) {
        if (t == null) {
            return null;
        }
        if (t._right == null) {
            return t;
        }
        return this.max(t._right);
    }

    public Object min() {
        Node node = this.min(this._root);
        return node == null ? null : node._key;
    }

    public Node min(Node t) {
        if (t == null) {
            return null;
        }
        if (t._left == null) {
            return t;
        }
        return this.min(t._left);
    }

    public Object selectMax(Node t, int num) {
        if (t == null) {
            return null;
        }
        Node right = t._right;
        if (right != null) {
            if (right._size + 1 == num) {
                return t._key;
            }
            if (right._size + 1 > num) {
                return this.selectMax(right, num);
            }
            return this.selectMax(t._left, num - right._size - 1);
        }
        if (num == 1) {
            return t._key;
        }
        if (t._left != null) {
            return this.selectMax(t._left, num - 1);
        }
        return null;
    }

    public Object selectMin(Node t, int num) {
        if (t == null) {
            return null;
        }
        Node left = t._left;
        if (left != null) {
            if (left._size + 1 == num) {
                return t._key;
            }
            if (left._size + 1 > num) {
                return this.selectMin(left, num);
            }
            return this.selectMin(t._right, num - left._size - 1);
        }
        if (num == 1) {
            return t._key;
        }
        if (t._right != null) {
            return this.selectMin(t._right, num - 1);
        }
        return null;
    }

    public int computeRank(Node t, Object key, int rank) {
        if (t == null) {
            return 0;
        }
        Node right = t._right;
        int cmp = this._cmp.compare(key, t._key);
        if (cmp < 0) {
            ++rank;
            if (right != null) {
                rank += right._size;
            }
            return this.computeRank(t._left, key, rank);
        }
        if (cmp > 0) {
            return this.computeRank(right, key, rank);
        }
        if (right != null) {
            rank += right._size;
        }
        return rank + 1;
    }

    public boolean isEmpty() {
        return this._root == null;
    }

    public void makeEmpty() {
        this._root = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node maintain(Node t, boolean flag) {
        if (t == null) {
            return t;
        }
        Node left = t._left;
        Node right = t._right;
        if (!flag) {
            if (left == null) {
                return t;
            }
            if (left._left != null && (right == null || left._left._size > right._size)) {
                t = this.rightRotate(t);
            } else {
                if (left._right == null || right != null && left._right._size <= right._size) return t;
                t._left = this.leftRotate(left);
                t = this.rightRotate(t);
            }
        } else {
            if (right == null) {
                return t;
            }
            if (right._right != null && (left == null || right._right._size > left._size)) {
                t = this.leftRotate(t);
            } else {
                if (right._left == null || left != null && right._left._size <= left._size) return t;
                t._right = this.rightRotate(right);
                t = this.leftRotate(t);
            }
        }
        t._left = this.maintain(t._left, false);
        t._right = this.maintain(t._right, true);
        t = this.maintain(t, false);
        return this.maintain(t, true);
    }

    private Node leftRotate(Node x) {
        Node y = x._right;
        x._right = y._left;
        y._left = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    private Node rightRotate(Node x) {
        Node y = x._left;
        x._left = y._right;
        y._right = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    void inorder(Node treeNode) {
        if (treeNode != null) {
            this.inorder(treeNode._left);
            this.inorder(treeNode._right);
        }
    }

    private static class Node {
        Node _left;
        Node _right;
        Node _next;
        int _size;
        Object _key;

        private Node(Object key) {
            this._key = key;
            this._size = 1;
        }

        private Node(Object key, Node left, Node right) {
            this._key = key;
            this._left = left;
            this._right = right;
        }

        public String toString() {
            return this._key.toString();
        }
    }

    private static class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private class QTreeIterator
    implements Iterator {
        private boolean _descent;
        private boolean _minLeft;
        private boolean _maxRight;
        private Node _current;
        private Node _start;
        private Node _end;

        private QTreeIterator() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Node t = this._current;
            while (t != null) {
                sb.append(t);
                sb.append(',');
                t = t._next;
            }
            return sb.toString();
        }

        void init(Object from, Object to, boolean descent) {
            int cmpCheck;
            if (from == null) {
                cmpCheck = to == null ? 0 : -1;
            } else {
                int n = cmpCheck = to == null ? 1 : QTree.this._cmp.compare(from, to);
            }
            if (cmpCheck > 0) {
                this._current = null;
                return;
            }
            this._descent = descent;
            this._maxRight = false;
            this._minLeft = false;
            this._end = null;
            this._start = null;
            this._current = null;
            Node root = QTree.this._root;
            if (from == null) {
                this._minLeft = true;
                this._start = QTree.this.min(root);
            } else {
                this._start = QTree.this.search(from);
                if (this._start == null) {
                    this._start = QTree.this.next(root, from);
                }
            }
            if (this._start != null) {
                if (to == null) {
                    this._maxRight = true;
                    this._end = QTree.this.max(root);
                } else {
                    this._end = QTree.this.search(to);
                    if (this._end == null) {
                        this._end = QTree.this.prev(root, to);
                    }
                }
            }
            if (this._start != null && this._end != null && QTree.this._cmp.compare(this._start._key, this._end._key) <= 0) {
                if (this._start == this._end) {
                    this._current = this._start;
                    this._current._next = null;
                } else {
                    this._current = descent ? this._end : this._start;
                    this.order(root);
                    this._current = descent ? this._end : this._start;
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this._current != null) {
                return true;
            }
            this.clear();
            return false;
        }

        public Object next() {
            Object obj = null;
            if (this._current != null) {
                obj = this._current._key;
                this._current = this._current._next;
            }
            return obj;
        }

        @Override
        public void remove() {
            if (this._current != null) {
                Node curr = this._current;
                this._current = this._current._next;
                QTree.this.deleteNode(curr);
            }
        }

        public void clear() {
            Node t = this._start;
            while (t != null) {
                Node tmp = t._next;
                t._next = null;
                t = tmp;
            }
        }

        private void order(Node t) {
            if (t == null) {
                return;
            }
            Node left = t._left;
            Node right = t._right;
            Comparator cmp = QTree.this._cmp;
            if (!this._descent) {
                if (this._minLeft || left != null && cmp.compare(this._start._key, left._key) < 0) {
                    this.order(left);
                }
                if (cmp.compare(t._key, this._end._key) <= 0) {
                    this._current._next = t;
                    this._current = t;
                    t._next = null;
                }
                if (this._maxRight || right != null && cmp.compare(this._end._key, right._key) > 0) {
                    this.order(t._right);
                }
            } else {
                if (this._maxRight || right != null && cmp.compare(this._end._key, right._key) > 0) {
                    this.order(right);
                }
                if (cmp.compare(t._key, this._start._key) >= 0) {
                    this._current._next = t;
                    this._current = t;
                    t._next = null;
                }
                if (this._minLeft || left != null && cmp.compare(this._start._key, left._key) < 0) {
                    this.order(t._left);
                }
            }
        }
    }
}

