/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.collection;

import com.kingdee.bos.ctrl.excel.expans.model.collection.SBTIterator;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SBTNode;

public class SBT {
    SBTNode _root;
    private int _ops;

    public SBTNode search(Comparable key) {
        return this.search(this._root, key);
    }

    public SBTNode search(SBTNode t, Comparable key) {
        while (t != null) {
            int cmp = key.compareTo(t._key);
            if (cmp == 0) {
                return t;
            }
            t = cmp < 0 ? t._left : t._right;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[" + this.size() + "],");
        SBTIterator i = new SBTIterator(this);
        i.setInorder();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            sb.append(',');
        }
        return sb.toString();
    }

    public int size() {
        return this._root == null ? 0 : this._root.getSize();
    }

    public SBTNode insert(SBTNode t, SBTNode x) {
        if (t == null) {
            t = x;
            this._ops = x._size;
        } else {
            int cmp = x._key.compareTo(t._key);
            if (cmp != 0) {
                if (cmp < 0) {
                    t._left = this.insert(t._left, x);
                } else {
                    t._right = this.insert(t._right, x);
                }
                t._size += this._ops;
                t = this.maintain(t, cmp > 0);
            }
        }
        return t;
    }

    public void insert(SBTNode x) {
        this._ops = 0;
        this._root = this.insert(this._root, x);
    }

    private SBTNode delete(SBTNode tNode, Comparable key) {
        if (tNode == null) {
            return null;
        }
        int cmp = key.compareTo(tNode._key);
        if (cmp == 0) {
            if ((tNode = this.deleteNode(tNode)) != null) {
                --tNode._size;
            }
            this._ops = 1;
        } else {
            if (cmp < 0) {
                tNode._left = this.delete(tNode._left, key);
            } else {
                tNode._right = this.delete(tNode._right, key);
            }
            tNode._size -= this._ops;
        }
        return tNode;
    }

    public void delete(Comparable key) {
        this._ops = 0;
        this._root = this.delete(this._root, key);
    }

    public SBTNode prev(SBTNode t, Comparable key) {
        if (t == null) {
            return null;
        }
        if (key.compareTo(t._key) <= 0) {
            return this.prev(t._left, key);
        }
        SBTNode prev = this.prev(t._right, key);
        return prev == null ? t : prev;
    }

    public SBTNode next(SBTNode t, Comparable key) {
        if (t == null) {
            return null;
        }
        if (key.compareTo(t._key) >= 0) {
            return this.next(t._right, key);
        }
        SBTNode next = this.next(t._left, key);
        return next == null ? t : next;
    }

    public SBTNode select(SBTNode t, int i) {
        if (t == null || i > t._size) {
            return null;
        }
        int r = (t._left == null ? 0 : t._left._size) + 1;
        if (i == r) {
            return t;
        }
        if (i < r) {
            return this.select(t._left, i);
        }
        return this.select(t._right, i - r);
    }

    public int rank(SBTNode t, Comparable key) {
        if (t == null) {
            return 0;
        }
        int cmp = key.compareTo(t._key);
        if (cmp == 0) {
            return (t._left == null ? 0 : t._left._size) + 1;
        }
        if (cmp < 0) {
            return this.rank(t._left, key);
        }
        int r = this.rank(t._right, key);
        return r == 0 ? 0 : r + (t._left == null ? 0 : t._left._size) + 1;
    }

    public Comparable selectMax(SBTNode root, int num) {
        if (root == null) {
            return null;
        }
        if (root._right != null) {
            if (root._right._size + 1 == num) {
                return root._key;
            }
            if (root._right._size + 1 > num) {
                return this.selectMax(root._right, num);
            }
            return this.selectMax(root._left, num - root._right._size - 1);
        }
        if (num == 1) {
            return root._key;
        }
        if (root._left != null) {
            return this.selectMax(root._left, num - 1);
        }
        return null;
    }

    public Comparable selectMin(SBTNode root, int num) {
        if (root == null) {
            return null;
        }
        if (root._left != null) {
            if (root._left._size + 1 == num) {
                return root._key;
            }
            if (root._left._size + 1 > num) {
                return this.selectMin(root._left, num);
            }
            return this.selectMin(root._right, num - root._left._size - 1);
        }
        if (num == 1) {
            return root._key;
        }
        if (root._right != null) {
            return this.selectMin(root._right, num - 1);
        }
        return null;
    }

    public int computeRank(SBTNode root, Comparable key, int rank) {
        if (root == null) {
            return 0;
        }
        int cmp = key.compareTo(root._key);
        if (cmp < 0) {
            ++rank;
            if (root._right != null) {
                rank += root._right._size;
            }
            return this.computeRank(root._left, key, rank);
        }
        if (cmp > 0) {
            return this.computeRank(root._right, key, rank);
        }
        if (root._right != null) {
            rank += root._right._size;
        }
        return rank + 1;
    }

    public boolean isEmpty() {
        return this._root == null;
    }

    public void makeEmpty() {
        this._root = null;
    }

    private SBTNode leftRotate(SBTNode x) {
        SBTNode y = x._right;
        x._right = y._left;
        y._left = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    private SBTNode rightRotate(SBTNode x) {
        SBTNode y = x._left;
        x._left = y._right;
        y._right = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SBTNode maintain(SBTNode t, boolean flag) {
        if (t == null) {
            return t;
        }
        if (!flag) {
            if (t._left != null && t._left._left != null && (t._right == null || t._left._left._size > t._right._size)) {
                t = this.rightRotate(t);
            } else {
                if (t._left == null || t._left._right == null || t._right != null && t._left._right._size <= t._right._size) return t;
                t._left = this.leftRotate(t._left);
                t = this.rightRotate(t);
            }
        } else if (t._right != null && t._right._right != null && (t._left == null || t._right._right._size > t._left._size)) {
            t = this.leftRotate(t);
        } else {
            if (t._right == null || t._right._left == null || t._left != null && t._right._left._size <= t._left._size) return t;
            t._right = this.rightRotate(t._right);
            t = this.leftRotate(t);
        }
        t._left = this.maintain(t._left, false);
        t._right = this.maintain(t._right, true);
        t = this.maintain(t, false);
        return this.maintain(t, true);
    }

    private SBTNode deleteNode(SBTNode tNode) {
        Comparable replacementItem;
        if (tNode._left == null) {
            if (tNode._right == null) {
                return null;
            }
            return tNode._right;
        }
        if (tNode._right == null) {
            return tNode._left;
        }
        tNode._key = replacementItem = this.findLeftmost(tNode._right);
        tNode._right = this.deleteLeftmost(tNode._right);
        return tNode;
    }

    private Comparable findLeftmost(SBTNode tNode) {
        if (tNode._left == null) {
            return tNode._key;
        }
        return this.findLeftmost(tNode._left);
    }

    private SBTNode deleteLeftmost(SBTNode tNode) {
        if (tNode._left == null) {
            return tNode._right;
        }
        tNode._left = this.deleteLeftmost(tNode._left);
        return tNode;
    }
}

