/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.ComboBorderChooser;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Position;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ToolBarManager
implements SheetChangeListener,
BookChangeListener,
SheetPropertyChangeListener,
GraphChangeListener {
    public static final String TOOLBAR_COMMON = "common";
    public static final String TOOLBAR_STYLE = "style";
    public static final int First = 0;
    public static final int Last = -1;
    public static final String ToolItem_Print = "ToolItem_Print";
    public static final String ToolItem_PrintPreview = "ToolItem_PrintPreview";
    public static final String ToolItem_PrintSetup = "ToolItem_PrintSetup";
    public static final String ToolItem_Cut = "ToolItem_Cut";
    public static final String ToolItem_Copy = "ToolItem_Copy";
    public static final String ToolItem_Paste = "ToolItem_Paste";
    public static final String ToolItem_Stylebrush = "ToolItem_Stylebrush";
    public static final String ToolItem_Undo = "ToolItem_Undo";
    public static final String ToolItem_Redo = "ToolItem_Redo";
    public static final String ToolItem_Hyperlink = "ToolItem_Hyperlink";
    public static final String ToolItem_Diagonal = "ToolItem_Diagonal";
    public static final String ToolItem_Sum = "ToolItem_Sum";
    public static final String ToolItem_SortAscend = "ToolItem_SortAscend";
    public static final String ToolItem_SortDecsend = "ToolItem_SortDecsend";
    public static final String ToolItem_Comment = "ToolItem_Comment";
    public static final String ToolItem_FontName = "ToolItem_FontName";
    public static final String ToolItem_FontSize = "ToolItem_FontSize";
    public static final String ToolItem_FontBold = "ToolItem_FontBold";
    public static final String ToolItem_FontItalic = "ToolItem_FontItalic";
    public static final String ToolItem_FontUnderline = "ToolItem_FontUnderline";
    public static final String ToolItem_AlignLeft = "ToolItem_AlignLeft";
    public static final String ToolItem_AlignCenter = "ToolItem_AlignCenter";
    public static final String ToolItem_AlignRight = "ToolItem_AlignRight";
    public static final String ToolItem_Merger = "ToolItem_Merger";
    public static final String ToolItem_Nf_Currency = "ToolItem_Nf_Currency";
    public static final String ToolItem_Nf_Percent = "ToolItem_Nf_Percent";
    public static final String ToolItem_Nf_KilloSeparator = "ToolItem_Nf_KilloSeparator";
    public static final String ToolItem_Nf_Increase = "ToolItem_Nf_Increase";
    public static final String ToolItem_Nf_Decrease = "ToolItem_Nf_Decrease";
    public static final String ToolItem_Nf_Thousand_Sheet = "ToolItem_Nf_Thousand_Sheet";
    public static final String TOOLITEM_NF_THOUSAND_SHEET_UNSET = "ToolItem_Nf_Thousand_Sheet_unSet";
    public static final String ToolItem_Locked = "ToolItem_Locked";
    public static final String ToolItem_Style_Border = "ToolItem_Style_Border";
    public static final String ToolItem_Style_Background = "ToolItem_Style_Background";
    public static final String ToolItem_Style_FontColor = "ToolItem_Style_FontColor";
    public static final String ToolItem_Style = "ToolItem_Style";
    public static final String ToolItem_Focus = "ToolItem_Focus";
    public static final String ToolItem_CellValue_ToNumber = "ToolItem_CellValue_ToNumber";
    public static final String ToolItem_ShowGrid = "ToolItem_ShowGrid";
    public static final String ToolItem_CalcRange = "ToolItem_CalcRange";
    public static final String ToolItem_ConditionFormat = "ToolItem_ConditionFormat";
    private static String[] sysFamilyName;
    private static String[] sysFontSizeAll;
    private SpreadContext _context;
    private HashMap _toolItems = new HashMap();
    private KDToolBar _styleBar;
    private KDToolBar _commonBar;
    private ArrayList _groupMenuItemsForCommon;
    private ArrayList _groupMenuItemsForStyle;
    private boolean _syncing;

    ToolBarManager(SpreadContext context) {
        this._context = context;
    }

    public KDToolBar getToolBar(String key) {
        if (TOOLBAR_STYLE.equals(key)) {
            if (this._styleBar == null) {
                if (this._groupMenuItemsForStyle == null) {
                    this.initMenuItemsForStyle();
                }
                this._styleBar = new KDToolBar();
                this.initToolBar(this._styleBar, this._groupMenuItemsForStyle);
                this._styleBar.setPopupMenuShowable(false);
            }
            return this._styleBar;
        }
        if (this._commonBar == null) {
            if (this._groupMenuItemsForCommon == null) {
                this.initMenuItemsForCommon();
            }
            this._commonBar = new KDToolBar();
            this.initToolBar(this._commonBar, this._groupMenuItemsForCommon);
            this._commonBar.setPopupMenuShowable(false);
        }
        return this._commonBar;
    }

    public void addAllFirstGroupItem(Action[] menuItems, String toolBarKey) {
        this.addAllGroupItem(menuItems, toolBarKey, 0, 0);
    }

    public void addAllLastGroupItem(Action[] menuItems, String toolBarKey) {
        this.addAllGroupItem(menuItems, toolBarKey, -1, -1);
    }

    public void addFirstGroupItem(Action menuItem, String toolBarKey) {
        this.addGroupItem(menuItem, toolBarKey, 0, 0);
    }

    public void addLastGroupItem(Action menuItem, String toolBarKey) {
        this.addGroupItem(menuItem, toolBarKey, -1, -1);
    }

    public void addAllFirstGroupItem(Component[] menuItems, String toolBarKey) {
        this.addAllGroupItem(menuItems, toolBarKey, 0, 0);
    }

    public void addAllLastGroupItem(Component[] menuItems, String toolBarKey) {
        this.addAllGroupItem(menuItems, toolBarKey, -1, -1);
    }

    public void addFirstGroupItem(Component menuItem, String toolBarKey) {
        this.addGroupItem(menuItem, toolBarKey, 0, 0);
    }

    public void addLastGroupItem(Component menuItem, String toolBarKey) {
        this.addGroupItem(menuItem, toolBarKey, -1, -1);
    }

    public void setItemVisible(String itemKey, boolean b) {
        Object o = this.getItem(itemKey, false);
        if (o instanceof Component) {
            ((Component)o).setVisible(b);
        } else if (o instanceof ItemAction) {
            ((ItemAction)o).getComponent().setVisible(b);
        }
    }

    private void addAllGroupItem(Object[] menuItems, String toolBarKey, int groupIndex, int index) {
        for (int i = menuItems.length - 1; i >= 0; --i) {
            this.addGroupItem(menuItems[i], toolBarKey, groupIndex, index);
        }
    }

    private void addGroupItem(Object menuItem, String toolBarKey, int groupIndex, int index) {
        if (!TOOLBAR_STYLE.equals(toolBarKey)) {
            ArrayList<Object> group;
            if (this._groupMenuItemsForCommon == null) {
                this.initMenuItemsForCommon();
            }
            if (groupIndex == -1) {
                groupIndex = this._groupMenuItemsForCommon.size() - 1;
            }
            if ((group = (ArrayList<Object>)this._groupMenuItemsForCommon.get(groupIndex)) == null) {
                group = new ArrayList<Object>();
                this._groupMenuItemsForCommon.set(groupIndex, group);
            }
            if (index < 0 || index > group.size()) {
                group.add(menuItem);
            } else {
                group.add(index, menuItem);
            }
        }
    }

    private void initMenuItemsForCommon() {
        this._groupMenuItemsForCommon = new ArrayList(5);
        this._groupMenuItemsForCommon.add(null);
        ArrayList<Object> groupPrint = new ArrayList<Object>();
        groupPrint.add(this.getItem(ToolItem_Print));
        groupPrint.add(this.getItem(ToolItem_PrintPreview));
        groupPrint.add(this.getItem(ToolItem_PrintSetup));
        this._groupMenuItemsForCommon.add(groupPrint);
        ArrayList<Object> groupEdit = new ArrayList<Object>();
        groupEdit.add(this.getItem(ToolItem_Cut));
        groupEdit.add(this.getItem(ToolItem_Copy));
        groupEdit.add(this.getItem(ToolItem_Paste));
        groupEdit.add(this.getItem(ToolItem_Stylebrush));
        this._groupMenuItemsForCommon.add(groupEdit);
        ArrayList<Object> groupUndo = new ArrayList<Object>();
        groupUndo.add(this.getItem(ToolItem_Undo));
        groupUndo.add(this.getItem(ToolItem_Redo));
        this._groupMenuItemsForCommon.add(groupUndo);
        ArrayList<Object> groupNormal = new ArrayList<Object>();
        groupNormal.add(this.getItem(ToolItem_Hyperlink));
        groupNormal.add(this.getItem(ToolItem_Diagonal));
        groupNormal.add(this.getItem(ToolItem_Sum));
        groupNormal.add(this.getItem(ToolItem_SortAscend));
        groupNormal.add(this.getItem(ToolItem_SortDecsend));
        groupNormal.add(this.getItem(ToolItem_Comment));
        this._groupMenuItemsForCommon.add(groupNormal);
        this._groupMenuItemsForCommon.add(null);
    }

    private void initMenuItemsForStyle() {
        this._groupMenuItemsForStyle = new ArrayList(6);
        this._groupMenuItemsForStyle.add(null);
        ArrayList<Object> groupFont = new ArrayList<Object>();
        groupFont.add(this.getItem(ToolItem_FontName));
        groupFont.add(this.getItem(ToolItem_FontSize));
        groupFont.add(this.getItem(ToolItem_FontBold));
        groupFont.add(this.getItem(ToolItem_FontItalic));
        groupFont.add(this.getItem(ToolItem_FontUnderline));
        this._groupMenuItemsForStyle.add(groupFont);
        ArrayList<Object> groupAlign = new ArrayList<Object>();
        groupAlign.add(this.getItem(ToolItem_AlignLeft));
        groupAlign.add(this.getItem(ToolItem_AlignCenter));
        groupAlign.add(this.getItem(ToolItem_AlignRight));
        groupAlign.add(this.getItem(ToolItem_Merger));
        groupAlign.add(this.getItem(ToolItem_Locked));
        this._groupMenuItemsForStyle.add(groupAlign);
        ArrayList<Object> groupNf = new ArrayList<Object>();
        groupNf.add(this.getItem(ToolItem_Nf_Currency));
        groupNf.add(this.getItem(ToolItem_Nf_Percent));
        groupNf.add(this.getItem(ToolItem_Nf_KilloSeparator));
        groupNf.add(this.getItem(ToolItem_Nf_Increase));
        groupNf.add(this.getItem(ToolItem_Nf_Decrease));
        this._groupMenuItemsForStyle.add(groupNf);
        ArrayList<Object> groupNormal = new ArrayList<Object>();
        groupNormal.add(this.getItem(ToolItem_Style_Border));
        groupNormal.add(this.getItem(ToolItem_Style_Background));
        groupNormal.add(this.getItem(ToolItem_Style_FontColor));
        groupNormal.add(this.getItem(ToolItem_Style));
        groupNormal.add(this.getItem(ToolItem_Focus));
        groupNormal.add(this.getItem(ToolItem_CellValue_ToNumber));
        this._groupMenuItemsForStyle.add(groupNormal);
        ArrayList<Object> groupShowGrid = new ArrayList<Object>();
        groupShowGrid.add(this.getItem(ToolItem_ShowGrid));
        this._groupMenuItemsForStyle.add(groupShowGrid);
        ArrayList<Object> groupNewStyle = new ArrayList<Object>();
        groupNewStyle.add(this.getItem(ToolItem_Nf_Thousand_Sheet));
        groupNewStyle.add(this.getItem(ToolItem_CalcRange));
        groupNewStyle.add(this.getItem(ToolItem_ConditionFormat));
        this._groupMenuItemsForStyle.add(groupNewStyle);
        this._groupMenuItemsForStyle.add(null);
    }

    public Object getItem(String name) {
        return this.getItem(name, true);
    }

    private Object getItem(String name, boolean bcreate) {
        Object o = this._toolItems.get(name);
        if (o == null && bcreate) {
            o = this.createItem(name);
            this._toolItems.put(name, o);
        }
        return o;
    }

    private Object createItem(String name) {
        if (ToolItem_Print == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_Print_Wizzard"), ResourceManager.getImageIcon("print.gif"), MultiLanguageKeys.getLocalText("KEY_PRINT"));
        }
        if (ToolItem_PrintPreview == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_PrinPreview_Wizzard"), ResourceManager.getImageIcon("tbtn_preview.gif"), MultiLanguageKeys.getLocalText("KEY_PRINTPREVIEW"));
        }
        if (ToolItem_PrintSetup == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_PrintSetup_Wizzard"), ResourceManager.getImageIcon("setup.gif"), MultiLanguageKeys.getLocalText("KEY_PRINTSETUP"));
        }
        if (ToolItem_Cut == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Cut"), ResourceManager.getImageIcon("tbtn_cut.gif"), MultiLanguageKeys.getLocalText("KEY_CUT"));
        }
        if (ToolItem_Copy == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Copy"), ResourceManager.getImageIcon("tbtn_copy.gif"), MultiLanguageKeys.getLocalText("KEY_COPY"));
        }
        if (ToolItem_Paste == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Paste"), ResourceManager.getImageIcon("tbtn_paste.gif"), MultiLanguageKeys.getLocalText("KEY_PASTE"));
        }
        if (ToolItem_Stylebrush == name) {
            return this.createItemAction(this._context.getActionManager().getAction("inner_StyleBrush"), ResourceManager.getImageIcon("tbtn_formatpainter.gif"), MultiLanguageKeys.getLocalText("KEY_STYLEBRUSH"));
        }
        if (ToolItem_Undo == name) {
            KDWorkButton undoBtn = new KDWorkButton();
            undoBtn.addAssistMenuItem((Action)new ItemAction(null));
            undoBtn.setAction((Action)this._context.getActionManager().getAction("Undo"));
            undoBtn.setIcon((Icon)ResourceManager.getImageIcon("tbtn_undo.gif"));
            undoBtn.setToolTipText(MultiLanguageKeys.getLocalText("KEY_UNDO"));
            undoBtn.setEnabled(false);
            return undoBtn;
        }
        if (ToolItem_Redo == name) {
            KDWorkButton redoBtn = new KDWorkButton();
            redoBtn.addAssistMenuItem((Action)new ItemAction(null));
            redoBtn.setAction((Action)this._context.getActionManager().getAction("Redo"));
            redoBtn.setIcon((Icon)ResourceManager.getImageIcon("tbtn_redo.gif"));
            redoBtn.setToolTipText(MultiLanguageKeys.getLocalText("KEY_REDO"));
            redoBtn.setEnabled(false);
            return redoBtn;
        }
        if (ToolItem_Hyperlink == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_Hyperlink_Wizzard"), ResourceManager.getImageIcon("tbtn_hyperlink.gif"), MultiLanguageKeys.getLocalText("KEY_INSHYPERLINK"));
        }
        if (ToolItem_Diagonal == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_DiagonalHeader_Wizzard"), ResourceManager.getImageIcon("tbtn_diagonal.gif"), MultiLanguageKeys.getLocalText("KEY_INSDIAGONAL"));
        }
        if (ToolItem_Sum == name) {
            KDWorkButton sumBtn = new KDWorkButton();
            sumBtn.setAction((Action)new SumBtnAction(1));
            sumBtn.setText("");
            sumBtn.setIcon((Icon)ResourceManager.getImageIcon("tbtn_sum.gif"));
            sumBtn.setToolTipText(MultiLanguageKeys.getLocalText("KEY_AUTOSUM"));
            sumBtn.addAssistMenuItem((Action)new SumBtnAction(1));
            sumBtn.addAssistMenuItem((Action)new SumBtnAction(2));
            sumBtn.addAssistMenuItem((Action)new SumBtnAction(4));
            sumBtn.addAssistMenuItem((Action)new SumBtnAction(8));
            sumBtn.addAssistMenuItem((Action)new SumBtnAction(16));
            sumBtn.addSeparator();
            ItemAction a = new ItemAction(this._context.getActionManager().getAction("Show_Formula_Wizzard"));
            String nn = MultiLanguageKeys.getLocalText("KEY_OTHERFUNC");
            a.putValue("Name", nn);
            sumBtn.addAssistMenuItem((Action)a);
            return sumBtn;
        }
        if (ToolItem_SortAscend == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Sort_Ascending"), ResourceManager.getImageIcon("tbtn_sortascending.gif"), MultiLanguageKeys.getLocalText("KEY_SORTASCEND"));
        }
        if (ToolItem_SortDecsend == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Sort_Descending"), ResourceManager.getImageIcon("tbtn_sortdescending.gif"), MultiLanguageKeys.getLocalText("KEY_SORTDESCEND"));
        }
        if (ToolItem_Comment == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_Comment_Wizzard"), ResourceManager.getImageIcon("tbtn_postil.gif"), MultiLanguageKeys.getLocalText("KEY_COMMENT"));
        }
        if (ToolItem_FontName == name) {
            sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            KDComboBox cFamily = new KDComboBox((Object[])sysFamilyName);
            cFamily.setToolTipText(MultiLanguageKeys.getLocalText("KEY_FONT"));
            cFamily.setEditable(true);
            cFamily.setLimitedSize(false);
            cFamily.setPreferredSize(new Dimension(120, 19));
            cFamily.setSelectedItem((Object)Styles.getDefaultStyle().getFontName());
            cFamily.addActionListener((ActionListener)new FontNameAction());
            return cFamily;
        }
        if (ToolItem_FontSize == name) {
            KDComboBox cSize = new KDComboBox((Object[])sysFontSizeAll);
            cSize.setToolTipText(MultiLanguageKeys.getLocalText("KEY_FONTSIZE"));
            cSize.setEditable(true);
            cSize.setLimitedSize(false);
            cSize.setPreferredSize(new Dimension(60, 19));
            cSize.setSelectedItem((Object)String.valueOf(Styles.getDefaultStyle().getFontSize()));
            cSize.addActionListener((ActionListener)new FontSizeAction());
            return cSize;
        }
        if (ToolItem_FontBold == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Font_Bold"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_blod.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_BOLD"));
            return b;
        }
        if (ToolItem_FontItalic == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Font_Italic"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_italic.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_ITALIC"));
            return b;
        }
        if (ToolItem_FontUnderline == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Font_UnderLine"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_underline.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_UNDERLINE"));
            return b;
        }
        if (ToolItem_AlignLeft == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Alignment_Left"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_leftalign.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_ALIGNLEFT"));
            return b;
        }
        if (ToolItem_AlignCenter == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Alignment_Center"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_centeralign.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_ALIGNCENTER"));
            return b;
        }
        if (ToolItem_AlignRight == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Alignment_Right"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_rightalign.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_ALIGNRIGHT"));
            return b;
        }
        if (ToolItem_Merger == name) {
            KDToggleButton b = new KDToggleButton();
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Merge"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_mergeandcenter.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_MERGE"));
            return b;
        }
        if (ToolItem_Nf_Currency == name) {
            return this.createItemAction(this._context.getActionManager().getAction("NumberFormat_Currency"), ResourceManager.getImageIcon("tbtn_currency.gif"), MultiLanguageKeys.getLocalText("KEY_CURRENCY"));
        }
        if (ToolItem_Nf_Percent == name) {
            return this.createItemAction(this._context.getActionManager().getAction("NumberFormat_Precent"), ResourceManager.getImageIcon("tbtn_percentage.gif"), MultiLanguageKeys.getLocalText("KEY_PRECENT"));
        }
        if (ToolItem_Nf_KilloSeparator == name) {
            return this.createItemAction(this._context.getActionManager().getAction("NumberFormat_KilloSeparator"), ResourceManager.getImageIcon("tbtn_commastyle.gif"), MultiLanguageKeys.getLocalText("KEY_KILLOSEP"));
        }
        if (ToolItem_Nf_Increase == name) {
            return this.createItemAction(this._context.getActionManager().getAction("NumberFormat_DecimalIns"), ResourceManager.getImageIcon("tbtn_increasedecimal.gif"), MultiLanguageKeys.getLocalText("KEY_INCREASE"));
        }
        if (ToolItem_Nf_Decrease == name) {
            return this.createItemAction(this._context.getActionManager().getAction("NumberFormat_DecimalDec"), ResourceManager.getImageIcon("tbtn_decreasedecimal.gif"), MultiLanguageKeys.getLocalText("KEY_DECREASE"));
        }
        if (ToolItem_Locked == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("Cell_Locked"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Freeze.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("Key_Locked"));
            return b;
        }
        if (ToolItem_Style_Border == name) {
            ComboBorderChooser b = new ComboBorderChooser(this._context);
            b.setToolTipText(MultiLanguageKeys.getLocalText("KEY_Border"));
            return b;
        }
        if (ToolItem_Style_Background == name) {
            KDComboColor b = this.createBgComboColor();
            return b;
        }
        if (ToolItem_Style_FontColor == name) {
            KDComboColor b = this.createFontComboColor();
            return b;
        }
        if (ToolItem_Style == name) {
            return this.createItemAction(this._context.getActionManager().getAction("Show_Style_Wizzard"), ResourceManager.getImageIcon("tbtn_monadismsetting.gif"), MultiLanguageKeys.getLocalText("KEY_CELLSTYLE"));
        }
        if (ToolItem_Focus == name) {
            KDToggleButton b = new KDToggleButton();
            b.setForToolbar(true);
            b.setOpaque(false);
            b.setBorder(null);
            b.setAction((Action)this._context.getActionManager().getAction("SetFoucsLockedCells"));
            b.setIcon((Icon)ResourceManager.getImageIcon("tbtn_lock.gif"));
            b.setToolTipText(MultiLanguageKeys.getLocalText("Key_FocusLockedCells"));
            return b;
        }
        if (ToolItem_CellValue_ToNumber == name) {
            return this.createItemAction(this._context.getActionManager().getAction("CellValue_ToNumber"), ResourceManager.getImageIcon("tbtn_monadismconversion.gif"), MultiLanguageKeys.getLocalText("Key_CellValue_ToNumber"));
        }
        if (ToolItem_ShowGrid == name) {
            return this.createShowGridCheckBox();
        }
        if (ToolItem_CalcRange == name) {
            return this.createCalcrangeButton();
        }
        if (ToolItem_Nf_Thousand_Sheet.equals(name)) {
            KDWorkButton thousandBtn = new KDWorkButton();
            ItemAction thousand = new ItemAction(this._context.getActionManager().getAction("NumberFormat_Thousand"));
            thousand.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Thousand", "\u5343\u5143\u8868"));
            thousand.putValue("display", 1);
            thousand.putValue("numberFormat", "0\".\"000\"(\u5343\u5143)\"");
            ItemAction thousandWithoutWord = new ItemAction(this._context.getActionManager().getAction("NumberFormat_Thousand_WithoutWord"));
            thousandWithoutWord.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Thousand_WithoutWord", "\u5343\u5143\u8868(\u4e0d\u5e26\u5343\u5143)"));
            thousandWithoutWord.putValue("display", 3);
            thousandWithoutWord.putValue("numberFormat", "0\".\"000");
            ItemAction tenThousand = new ItemAction(this._context.getActionManager().getAction("NumberFormat_Ten_Thousand"));
            tenThousand.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Ten_Thousand", "\u4e07\u5143\u8868"));
            tenThousand.putValue("display", 2);
            tenThousand.putValue("numberFormat", "0\".\"0,\"(\u4e07\u5143)\"");
            ItemAction tenThousandWithoutWord = new ItemAction(this._context.getActionManager().getAction("NumberFormat_Ten_Thousand_WithoutWord"));
            tenThousandWithoutWord.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Ten_Thousand_WithoutWord", "\u4e07\u5143\u8868(\u4e0d\u5e26\u4e07\u5143)"));
            tenThousandWithoutWord.putValue("display", 4);
            tenThousandWithoutWord.putValue("numberFormat", "0\".\"0,");
            ItemAction cancelThousand = new ItemAction(this._context.getActionManager().getAction("NumberFormat_Cancel_Thousand"));
            cancelThousand.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Cancel_Thousand", "\u53d6\u6d88"));
            cancelThousand.putValue("display", 0);
            thousandBtn.addAssistMenuItem((Action)thousand);
            thousandBtn.addAssistMenuItem((Action)tenThousand);
            thousandBtn.addSeparator();
            thousandBtn.addAssistMenuItem((Action)thousandWithoutWord);
            thousandBtn.addAssistMenuItem((Action)tenThousandWithoutWord);
            thousandBtn.addAssistMenuItem((Action)cancelThousand);
            thousandBtn.setText("\u5343\u5143\u8868(\u672a\u8bbe\u7f6e)");
            thousandBtn.setIcon((Icon)ResourceManager.getImageIcon("newthousand.png"));
            thousandBtn.setToolTipText("\u5343\u5143\u8868\u6837\u5f0f\u6ca1\u6709\u8bbe\u7f6e");
            EmptyAction a = new EmptyAction();
            a.putValue("display", 0);
            thousandBtn.setAction((Action)a);
            return thousandBtn;
        }
        if (TOOLITEM_NF_THOUSAND_SHEET_UNSET.equals(name)) {
            KDWorkButton btm = new KDWorkButton();
            EmptyAction a = new EmptyAction();
            a.putValue("display", 0);
            btm.setAction((Action)a);
            btm.setText("\u5343\u5143\u8868(\u672a\u8bbe\u7f6e)");
            btm.setIcon((Icon)ResourceManager.getImageIcon("newthousand.png"));
            btm.setToolTipText("\u5343\u5143\u8868\u6837\u5f0f\u6ca1\u6709\u8bbe\u7f6e");
            return btm;
        }
        if (ToolItem_ConditionFormat.equals(name)) {
            KDWorkButton cformatBtn = new KDWorkButton();
            cformatBtn.setText(MultiLanguageKeys.getLocalText("KEY_CONDITION_PROCESS", "\u8fdb\u5ea6\u6761"));
            cformatBtn.setIcon((Icon)ResourceManager.getImageIcon("newprogress.png"));
            cformatBtn.setToolTipText(MultiLanguageKeys.getLocalText("KEY_CONDITION_PROCESS", "\u8fdb\u5ea6\u6761"));
            KDMenu processMenu = new KDMenu(MultiLanguageKeys.getLocalText("KEY_CONDITION_PROCESS", "\u8fdb\u5ea6\u6761"));
            KDMenu colorMenu = new KDMenu(MultiLanguageKeys.getLocalText("KEY_CONDITION_COLOR_GRADATION", "\u8272\u9636"));
            KDMenu picMenu = new KDMenu(MultiLanguageKeys.getLocalText("KEY_CONDITION_PIC", "\u56fe\u6807\u96c6"));
            KDMenuItem process_blueMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_BLUE_PROCESS", "\u84dd\u8272\u8fdb\u5ea6\u6761"));
            process_blueMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.blue}, 1));
            process_blueMenuItem.setIcon((Icon)ResourceManager.getImageIcon("blue_process.jpg"));
            KDMenuItem process_redMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_RED_PROCESS", "\u7ea2\u8272\u8fdb\u5ea6\u6761"));
            process_redMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.red}, 1));
            process_redMenuItem.setIcon((Icon)ResourceManager.getImageIcon("red_process.jpg"));
            KDMenuItem process_orangeMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_ORANGE_PROCESS", "\u6a59\u8272\u8fdb\u5ea6\u6761"));
            process_orangeMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.orange}, 1));
            process_orangeMenuItem.setIcon((Icon)ResourceManager.getImageIcon("orange_process.jpg"));
            KDMenuItem color_blue_redMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_GREEN_RED_GRADATION", "\u7eff\u8272-\u7ea2\u8272\u9636"));
            color_blue_redMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.green, Color.red}, 2));
            color_blue_redMenuItem.setIcon((Icon)ResourceManager.getImageIcon("color_green_red.jpg"));
            KDMenuItem color_red_blueMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_RED_GREEEN_GRADATION", "\u7ea2\u8272-\u7eff\u8272\u9636"));
            color_red_blueMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.red, Color.green}, 2));
            color_red_blueMenuItem.setIcon((Icon)ResourceManager.getImageIcon("color_red_green.jpg"));
            KDMenuItem color_yellow_blueMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_YELLOW_GREEN_GRADATION", "\u9ec4\u8272-\u7eff\u8272\u9636"));
            color_yellow_blueMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new Color[]{Color.yellow, Color.green}, 2));
            color_yellow_blueMenuItem.setIcon((Icon)ResourceManager.getImageIcon("color_yellow_green.jpg"));
            KDMenuItem pic_arrowMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_ARROW_PIC", "\u7bad\u5934\u56fe"));
            pic_arrowMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new String[]{"up.png", "middle.png", "down.png"}, 3));
            pic_arrowMenuItem.setIcon((Icon)ResourceManager.getImageIcon("up.png"));
            KDMenuItem pic_circleMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_CIRCLE_PIC", "\u7403\u5f62\u56fe"));
            pic_circleMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new String[]{"greenball.png", "orangeball.png", "redball.png"}, 3));
            pic_circleMenuItem.setIcon((Icon)ResourceManager.getImageIcon("orangeball.png"));
            KDMenuItem pic_flagMenuItem = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_FLAGE_PIC", "\u65d7\u5b50\u56fe"));
            pic_flagMenuItem.setCustomAction((Action)new CFormatFurther(this._context, new String[]{"pic_green_flag.png", "pic_yellow_flag.png", "pic_red_flag.png"}, 3));
            pic_flagMenuItem.setIcon((Icon)ResourceManager.getImageIcon("pic_red_flag.png"));
            KDMenuItem cancel = new KDMenuItem(MultiLanguageKeys.getLocalText("KEY_Cancel_Thousand", "\u53d6\u6d88"));
            cancel.setCustomAction((Action)new CancelCFormatFurther(this._context));
            processMenu.add((JMenuItem)process_blueMenuItem);
            processMenu.add((JMenuItem)process_redMenuItem);
            processMenu.add((JMenuItem)process_orangeMenuItem);
            processMenu.addSeparator();
            colorMenu.add((JMenuItem)color_blue_redMenuItem);
            colorMenu.add((JMenuItem)color_red_blueMenuItem);
            colorMenu.add((JMenuItem)color_yellow_blueMenuItem);
            colorMenu.addSeparator();
            picMenu.add((JMenuItem)pic_arrowMenuItem);
            picMenu.add((JMenuItem)pic_circleMenuItem);
            picMenu.add((JMenuItem)pic_flagMenuItem);
            picMenu.addSeparator();
            cformatBtn.addAssistMenuItem((JMenuItem)processMenu);
            cformatBtn.addAssistMenuItem((JMenuItem)colorMenu);
            cformatBtn.addAssistMenuItem((JMenuItem)picMenu);
            cformatBtn.addSeparator();
            cformatBtn.addAssistMenuItem((JMenuItem)cancel);
            return cformatBtn;
        }
        return null;
    }

    private Action createItemAction(Action a, Icon icon, String text) {
        ItemAction aw = new ItemAction(a);
        aw.putValue("SmallIcon", icon);
        aw.putValue("ShortDescription", text);
        aw.putValue("Name", text);
        return aw;
    }

    private void initToolBar(KDToolBar toolBar, ArrayList groupMenuItems) {
        boolean hasPrefixGroup = false;
        int size = groupMenuItems.size();
        for (int i = 0; i < size; ++i) {
            ArrayList agroup = (ArrayList)groupMenuItems.get(i);
            if (agroup == null || agroup.size() <= 0) continue;
            if (hasPrefixGroup) {
                toolBar.addSeparator();
            }
            int gsize = agroup.size();
            for (int j = 0; j < gsize; ++j) {
                Object o = agroup.get(j);
                if (o instanceof Component) {
                    toolBar.add((Component)o);
                    continue;
                }
                if (!(o instanceof Action)) continue;
                JButton comp = toolBar.add((Action)o);
                if (!(o instanceof ItemAction)) continue;
                ((ItemAction)o).setComponent(comp);
            }
            hasPrefixGroup = true;
        }
    }

    private boolean isSysFontName(String f) {
        if (sysFamilyName == null) {
            return false;
        }
        for (int i = 0; i < sysFamilyName.length; ++i) {
            if (!sysFamilyName[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    private boolean isSysFontSize(String f) {
        if (sysFontSizeAll == null) {
            return false;
        }
        for (int i = 0; i < sysFontSizeAll.length; ++i) {
            if (!sysFontSizeAll[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    private KDComboColor createBgComboColor() {
        KDComboColor cbc = new KDComboColor(2);
        cbc.setPictureForViewPic(ResourceManager.getImageIcon("tbtn_fillbgcolor.gif"));
        cbc.setDefaultColor(KDComboColor.TRANSPARENTCOLOR);
        cbc.setDefaultColorPrompt(MultiLanguageKeys.getLocalText("KEY_NOFILLCOLOR"));
        cbc.setToolTipText(MultiLanguageKeys.getLocalText("KEY_FILLCOLOR"));
        cbc.setColor(Color.yellow);
        cbc.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorSelectionModel csm = (ColorSelectionModel)e.getSource();
                Color c = csm.getSelectedColor();
                StyleAttributes sa = Styles.getEmptySA();
                sa.setBackground(c);
                if (c.getAlpha() == 0) {
                    sa.setPattern(Pattern.None);
                }
                ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
            }
        });
        cbc.addViewPicClickListener(new ComboColorViewPicClickListener(){

            public void clicked(ComboColorViewPicClickEvent evt) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setBackground(evt.getCurrentColor());
                if (evt.getCurrentColor().getAlpha() == 0) {
                    sa.setPattern(Pattern.None);
                }
                ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
            }
        });
        return cbc;
    }

    private KDCheckBox createShowGridCheckBox() {
        KDCheckBox checkBox = new KDCheckBox(MultiLanguageKeys.getLocalText("gridlines", "\u7f51\u683c\u7ebf"));
        checkBox.setForeground(Color.WHITE);
        checkBox.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof KDCheckBox) {
                    KDCheckBox box = (KDCheckBox)source;
                    boolean isSelected = box.isSelected();
                    Sheet sheet = ToolBarManager.this._context.getBook().getActiveSheet();
                    sheet.getSheetOption().setShowHoriLines(!isSelected);
                    sheet.getSheetOption().setShowVertLines(!isSelected);
                    ToolBarManager.this._context.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        return checkBox;
    }

    private KDWorkButton createCalcrangeButton() {
        KDWorkButton bt = new KDWorkButton();
        bt.setBorderPainted(false);
        bt.setAction((Action)this._context.getActionManager().getAction("Calc_Range"));
        bt.setText(MultiLanguageKeys.getLocalText("KEY_Cal_Range", "\u533a\u57df\u8ba1\u7b97"));
        bt.setIcon((Icon)ResourceManager.getImageIcon("newrangecalc.png"));
        bt.setToolTipText(MultiLanguageKeys.getLocalText("KEY_Cal_Range"));
        ItemAction calcRange = new ItemAction(this._context.getActionManager().getAction("Calc_Range"));
        calcRange.putValue("Name", MultiLanguageKeys.getLocalText("KEY_Cal_Range", "\u533a\u57df\u8ba1\u7b97"));
        return bt;
    }

    private KDComboColor createFontComboColor() {
        KDComboColor cbc = new KDComboColor(2);
        cbc.setPictureForViewPic(ResourceManager.getImageIcon("tbtn_fontcolor.gif"));
        cbc.setToolTipText(MultiLanguageKeys.getLocalText("KEY_FONTCOLOR"));
        cbc.setColor(Color.red);
        cbc.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorSelectionModel csm = (ColorSelectionModel)e.getSource();
                Color c = csm.getSelectedColor();
                StyleAttributes sa = Styles.getEmptySA();
                sa.setFontColor(c);
                ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
            }
        });
        cbc.addViewPicClickListener(new ComboColorViewPicClickListener(){

            public void clicked(ComboColorViewPicClickEvent evt) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setFontColor(evt.getCurrentColor());
                ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
            }
        });
        return cbc;
    }

    private Component getItemAsCompoent(String name, boolean bcreate) {
        return (Component)this.getItem(name, bcreate);
    }

    private void syncEnable(Protection pro) {
        boolean b = pro == null || pro.allowFormattingCells();
        Component comp = null;
        comp = this.getItemAsCompoent(ToolItem_FontName, false);
        if (comp != null) {
            comp.setEnabled(b);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_FontSize, false)) != null) {
            comp.setEnabled(b);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Style_Border, false)) != null) {
            comp.setEnabled(b);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Style_Background, false)) != null) {
            comp.setEnabled(b);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Style_FontColor, false)) != null) {
            comp.setEnabled(b);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Sum, false)) != null) {
            comp.setEnabled(b);
        }
    }

    private void syncStyleData(Sheet sheet) {
        Styles.HorizontalAlignment ha;
        Style style = sheet.getActiveCellStyle();
        Component comp = null;
        comp = this.getItemAsCompoent(ToolItem_FontName, false);
        if (comp != null) {
            ((JComboBox)comp).setSelectedItem(style.getFontName());
        }
        if ((comp = this.getItemAsCompoent(ToolItem_FontSize, false)) != null) {
            ((JComboBox)comp).setSelectedItem(String.valueOf(style.getFontSize()));
        }
        if ((comp = this.getItemAsCompoent(ToolItem_FontBold, false)) != null) {
            ((JToggleButton)comp).setSelected(style.isBold());
        }
        if ((comp = this.getItemAsCompoent(ToolItem_FontItalic, false)) != null) {
            ((JToggleButton)comp).setSelected(style.isItalic());
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Locked, false)) != null) {
            ((JToggleButton)comp).setSelected(style.isLocked());
        }
        if ((comp = this.getItemAsCompoent(ToolItem_FontUnderline, false)) != null) {
            ((JToggleButton)comp).setSelected(style.isUnderline());
        }
        boolean b = (ha = style.getHorizontalAlign()).getValue() == 0;
        comp = this.getItemAsCompoent(ToolItem_AlignLeft, false);
        if (comp != null) {
            ((JToggleButton)comp).setSelected(b ? false : ha == Styles.HorizontalAlignment.LEFT);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_AlignCenter, false)) != null) {
            ((JToggleButton)comp).setSelected(b ? false : ha == Styles.HorizontalAlignment.CENTER);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_AlignRight, false)) != null) {
            ((JToggleButton)comp).setSelected(b ? false : ha == Styles.HorizontalAlignment.RIGHT);
        }
        if ((comp = this.getItemAsCompoent(ToolItem_Merger, false)) != null) {
            ((JToggleButton)comp).setSelected(sheet.hasMerger(this._context.getRangeManager().getSelectionRange()));
        }
        if ((comp = this.getItemAsCompoent(ToolItem_ShowGrid, false)) != null) {
            ((KDCheckBox)comp).setSelected(sheet.getSheetOption().isShowHoriLines());
        }
        comp = this.getItemAsCompoent(ToolItem_Nf_Thousand_Sheet, false);
        Cell cell = sheet.getActiveCell();
        if (null != comp) {
            this.setNFThousandSheet((KDWorkButton)comp, cell);
        }
    }

    private void setNFThousandSheet(KDWorkButton comp, Cell cell) {
        KDWorkButton b;
        Icon icon;
        Action action;
        Integer displayMode = null;
        if (null != cell) {
            displayMode = (Integer)cell.getUserObjectValue("display");
        }
        KDWorkButton thousandBtn = comp;
        String fmt = cell == null ? null : cell.getStyle().getNumberFormat();
        boolean match = false;
        if (null != fmt) {
            Component[] cs;
            for (Component cp : cs = thousandBtn.getAssistPopup().getComponents()) {
                String nf;
                if (!(cp instanceof AbstractButton) || !fmt.equals(nf = (String)(action = ((AbstractButton)cp).getAction()).getValue("numberFormat"))) continue;
                icon = thousandBtn.getIcon();
                thousandBtn.setAction(action);
                thousandBtn.setText((String)action.getValue("Name"));
                thousandBtn.setToolTipText((String)action.getValue("Name"));
                thousandBtn.setIcon(icon);
                match = true;
                break;
            }
        }
        if (null != displayMode && displayMode != 0) {
            Component[] components;
            for (Component cp : components = thousandBtn.getAssistPopup().getComponents()) {
                if (!(cp instanceof AbstractButton)) continue;
                action = ((AbstractButton)cp).getAction();
                Integer displayNF = (Integer)action.getValue("display");
                if (displayMode.intValue() != displayNF.intValue()) continue;
                icon = thousandBtn.getIcon();
                thousandBtn.setAction(action);
                thousandBtn.setText((String)action.getValue("Name"));
                thousandBtn.setToolTipText((String)action.getValue("Name"));
                thousandBtn.setIcon(icon);
                match = true;
                break;
            }
        }
        if (!match && null != (b = (KDWorkButton)this.getItem(TOOLITEM_NF_THOUSAND_SHEET_UNSET))) {
            thousandBtn.setAction(b.getAction());
            thousandBtn.setText(b.getText());
            thousandBtn.setToolTipText(b.getToolTipText());
            thousandBtn.setIcon(b.getIcon());
        }
    }

    private void syncUndoRedo(Sheet sheet) {
        KDWorkButton btnRedo;
        UndoManager um = sheet.getBook().getUndoManager();
        KDWorkButton btnUndo = (KDWorkButton)this.getItem(ToolItem_Undo, false);
        if (btnUndo != null) {
            KDPopupMenu pm = btnUndo.getAssistPopup();
            pm.removeAll();
            boolean b = um.canUndo();
            btnUndo.setEnabled(b);
            if (b) {
                int index = um.getIndexOfNextAdd();
                int itemIndex = 0;
                for (int i = index - 1; i >= 0; --i) {
                    String str = um.getEditAt(i).getUndoPresentationName();
                    UndoStepsAction aw = new UndoStepsAction();
                    aw.setIndex(itemIndex++);
                    aw.putValue("Name", str);
                    pm.add((Action)aw);
                }
            }
        }
        if ((btnRedo = (KDWorkButton)this.getItem(ToolItem_Redo, false)) != null) {
            KDPopupMenu pm = btnRedo.getAssistPopup();
            pm.removeAll();
            boolean b = um.canRedo();
            btnRedo.setEnabled(b);
            if (b) {
                int index = um.getIndexOfNextAdd();
                int itemIndex = 0;
                int size = um.size();
                for (int i = index; i < size; ++i) {
                    String str = um.getEditAt(i).getRedoPresentationName();
                    RedoStepsAction aw = new RedoStepsAction();
                    aw.setIndex(itemIndex++);
                    aw.putValue("Name", str);
                    pm.add((Action)aw);
                }
            }
        }
    }

    @Override
    public void changed(BookChangeEvent e) {
        this._syncing = true;
        if (e.isSheetRemove() || e.isSheetHide()) {
            this.syncUndoRedo(e.getSheet());
        }
        if (!e.isGroup() && e.isSheetActive()) {
            this.syncStyleData(e.getSheet());
            this.syncEnable(e.getSheet().getSheetOption().getProtection(false));
        }
        this._syncing = false;
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
        if (e.isSheetProtectionChanged() && e.getSheet() == this._context.getBook().getActiveSheet()) {
            Protection pro = e.getSheet().getSheetOption().getProtection(false);
            this.syncEnable(pro);
            if (pro != null && pro.isProtected()) {
                this.syncUndoRedo(e.getSheet());
            }
        }
    }

    @Override
    public void changed(SheetChangeEvent e) {
        this._syncing = true;
        if (e.getSheet() == this._context.getBook().getActiveSheet()) {
            this.syncStyleData(e.getSheet());
        }
        if (e.makeUndoRedoChange()) {
            this.syncUndoRedo(e.getSheet());
        }
        this._syncing = false;
    }

    @Override
    public void changed(GraphChangedEvent e) {
        this._syncing = true;
        if (e.makeUndoRedoChange()) {
            this.syncUndoRedo(e.getSheet());
        }
        this._syncing = false;
    }

    @Override
    public void propertyChanged(GraphPropertyChangedEvent e) {
        this._syncing = true;
        if (e.makeUndoRedoChange()) {
            this.syncUndoRedo(e.getSheet());
        }
        this._syncing = false;
    }

    static {
        sysFontSizeAll = new String[]{"5", "6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }

    class CancelCFormatFurther
    extends SpreadAction {
        int type;

        public CancelCFormatFurther(SpreadContext context) {
            super(context);
        }

        public CancelCFormatFurther(SpreadContext context, int type) {
            super(context);
            this.type = type;
        }

        @Override
        protected void doAction(ActionEvent e) {
            Sheet sheet = this._context.getBook().getActiveSheet();
            SortedCellBlockArray scba = sheet.getSheetOption().getSelection().toSortedBlocks();
            sheet.getConditionFormatFurthers().removeConditionFormatFurther(sheet, scba);
            this._context.repaint();
        }
    }

    class CFormatFurther
    extends SpreadAction {
        Object ob;
        int type;

        public CFormatFurther(SpreadContext context) {
            super(context);
        }

        public CFormatFurther(SpreadContext context, Object ob, int type) {
            super(context);
            this.ob = ob;
            this.type = type;
        }

        @Override
        protected void doAction(ActionEvent e) {
            Sheet sheet = this._context.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            range.mergeSelf();
            range.insertConditionalformatFurther(this.ob, this.type);
            this._context.repaint();
        }
    }

    private class ItemAction
    extends AbstractAction {
        private Action _a;
        private Component _comp;

        ItemAction(Action a) {
            this._a = a;
            if (this._a != null) {
                this._a.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("enabled")) {
                            ItemAction.this.setEnabled(ItemAction.this._a.isEnabled());
                        }
                    }
                });
            }
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("continious")) {
                        ItemAction.this._a.putValue("continious", ItemAction.this.getValue("continious"));
                    }
                }
            });
        }

        void setComponent(Component comp) {
            this._comp = comp;
        }

        Component getComponent() {
            return this._comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._a != null) {
                this._a.actionPerformed(e);
            }
        }
    }

    private class SumBtnAction
    extends AbstractAction {
        private static final int SUM = 1;
        private static final int AVERAGE = 2;
        private static final int COUNT = 4;
        private static final int MAX = 8;
        private static final int MIN = 16;
        private int _type;

        SumBtnAction(int type) {
            this.setType(type);
        }

        private void setType(int type) {
            this._type = type;
            String name = "";
            if (this._type == 1) {
                name = MultiLanguageKeys.getLocalText("KEY_SUM");
            } else if (this._type == 2) {
                name = MultiLanguageKeys.getLocalText("KEY_AVERAGE");
            } else if (this._type == 4) {
                name = MultiLanguageKeys.getLocalText("KEY_COUNT");
            } else if (this._type == 8) {
                name = MultiLanguageKeys.getLocalText("KEY_MAX");
            } else if (this._type == 16) {
                name = MultiLanguageKeys.getLocalText("KEY_MIN");
            }
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book book = ToolBarManager.this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            int rowMax = sheet.getMaxRowIndex();
            int colMax = sheet.getMaxColIndex();
            if (rowMax < 0 || colMax < 0) {
                return;
            }
            Selection sel = sheet.getSheetOption().getSelection();
            if (sel.isSingleBlock()) {
                CellBlock cb = sel.getCloneActiveBlock();
                if (cb.isWholeSheet()) {
                    cb.setRow2(rowMax + 1);
                    cb.setCol2(colMax + 1);
                }
                if (sel.isBaseUnit()) {
                    Cell cell = sheet.getCell(cb.getRow(), cb.getCol(), false);
                    String formula = null;
                    if (cell != null) {
                        formula = cell.getFormula();
                    }
                    ToolBarManager.this._context.getStateManager().addState(ToolBarManager.this._context.getStateManager().createEditState(this.isAjustedFormula(formula) ? formula : this.getDefinedFormula("")));
                    CellTextEditor cte = (CellTextEditor)ToolBarManager.this._context.getEditManager().getCurrentEditor();
                    int caret = cte.getCaretPosition() - 1;
                    if (caret >= 0) {
                        cte.setCaretPosition(caret);
                    }
                } else {
                    int col = cb.getCol();
                    int col2 = cb.getCol2();
                    int row = cb.getRow();
                    int row2 = cb.getRow2();
                    boolean a = this.isEmptyLine(sheet, cb, col2, 1);
                    boolean b = this.isEmptyLine(sheet, cb, row2, 0);
                    if (a || b) {
                        int i;
                        book.getUndoManager().startGroup();
                        if (a) {
                            for (i = row; i <= row2; ++i) {
                                cb = CellBlock.getNewCellBlock(i, col, i, col2 - 1 < col ? col : col2 - 1);
                                if (this.isEmptyLine(sheet, cb, i, 0)) continue;
                                ToolBarManager.this._context.getRangeManager().getRange(i, col2).setFormula(this.getDefinedFormula(Sheet.getBlockA1Name(cb, false)));
                            }
                        }
                        if (b) {
                            for (i = col; i <= col2; ++i) {
                                cb = CellBlock.getNewCellBlock(row, i, row2 - 1 < row ? row : row2 - 1, i);
                                if (this.isEmptyLine(sheet, cb, i, 1)) continue;
                                ToolBarManager.this._context.getRangeManager().getRange(row2, i).setFormula(this.getDefinedFormula(Sheet.getBlockA1Name(cb, false)));
                            }
                            if (a && !this.isEmptyLine(sheet, cb = CellBlock.getNewCellBlock(row, col2, row2 - 1 < row ? row : row2 - 1, col2), col, 1)) {
                                ToolBarManager.this._context.getRangeManager().getRange(row2, col2).setFormula(this.getDefinedFormula(Sheet.getBlockA1Name(cb, false)));
                            }
                        }
                        book.getUndoManager().endGroup();
                    } else if (cb.getHeight() == 1) {
                        Position pos = SheetBaseMath.getRightEmptyPosition(sheet, cb.getRow(), cb.getCol2() - 1);
                        if (pos != null) {
                            if (pos.getCol() == cb.getCol2()) {
                                CellBlock nb = CellBlock.getNewCellBlock(cb);
                                nb.setCol2(nb.getCol2() - 1);
                                cb = nb;
                            }
                            ToolBarManager.this._context.getRangeManager().getRange(pos.getRow(), pos.getCol()).setFormula(this.getDefinedFormula(Sheet.getBlockA1Name(cb, false)));
                        }
                    } else {
                        Position pos;
                        book.getUndoManager().startGroup();
                        int maxPosRow = row2;
                        for (int j = col; j <= col2; ++j) {
                            pos = SheetBaseMath.getDownEmptyPosition(sheet, row2 - 1, j);
                            if (pos == null) continue;
                            maxPosRow = Math.max(pos.getRow(), maxPosRow);
                        }
                        for (int i = col; i <= col2; ++i) {
                            pos = SheetBaseMath.getDownEmptyPosition(sheet, row2 - 1, i);
                            if (pos == null) continue;
                            pos.setRow(maxPosRow);
                            cb = CellBlock.getNewCellBlock(row, i, pos.getRow() == row2 ? row2 - 1 : row2, i);
                            if (this.isEmptyLine(sheet, cb, i, 1)) continue;
                            ToolBarManager.this._context.getRangeManager().getRange(pos.getRow(), pos.getCol()).setFormula(this.getDefinedFormula(Sheet.getBlockA1Name(cb, false)));
                        }
                        book.getUndoManager().endGroup();
                    }
                }
            }
        }

        private boolean isEmptyLine(Sheet sheet, CellBlock cb, int index, int mark) {
            int col = cb.getCol();
            int col2 = cb.getCol2();
            int row = cb.getRow();
            int row2 = cb.getRow2();
            if (mark == 1) {
                if (!cb.containsCol(index)) {
                    return true;
                }
                for (int i = row; i <= row2; ++i) {
                    Cell cell = sheet.getCell(i, index, false);
                    if (cell == null || cell.getValue() == null) continue;
                    return false;
                }
                return true;
            }
            if (mark == 0) {
                if (!cb.containsRow(index)) {
                    return true;
                }
                for (int i = col; i <= col2; ++i) {
                    Cell cell = sheet.getCell(index, i, false);
                    if (cell == null || cell.getValue() == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean isAjustedFormula(String formula) {
            if (StringUtil.isEmptyString((String)formula)) {
                return false;
            }
            formula = formula.toUpperCase(Locale.ENGLISH);
            if (this._type == 1) {
                return formula.startsWith("=SUM(");
            }
            if (this._type == 2) {
                return formula.startsWith("=AVERAGE(");
            }
            if (this._type == 4) {
                return formula.startsWith("=COUNT(");
            }
            if (this._type == 8) {
                return formula.startsWith("=MAX(");
            }
            if (this._type == 16) {
                return formula.startsWith("=MIN(");
            }
            return false;
        }

        private String getDefinedFormula(String cbName) {
            if (this._type == 1) {
                return "=SUM(" + cbName + ")";
            }
            if (this._type == 2) {
                return "=AVERAGE(" + cbName + ")";
            }
            if (this._type == 4) {
                return "=COUNT(" + cbName + ")";
            }
            if (this._type == 8) {
                return "=MAX(" + cbName + ")";
            }
            if (this._type == 16) {
                return "=MIN(" + cbName + ")";
            }
            return "";
        }
    }

    private class FontSizeAction
    extends AbstractAction {
        private FontSizeAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ToolBarManager.this._syncing) {
                KDComboBox cb = (KDComboBox)e.getSource();
                String fn = cb.getEditor().getItem().toString();
                if (ToolBarManager.this.isSysFontSize(fn)) {
                    cb.setSelectedItem((Object)fn);
                }
                try {
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setFontSize(Integer.parseInt(fn));
                    ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
                }
                catch (Exception exception) {
                }
                finally {
                    ToolBarManager.this._context.requestFocus();
                }
            }
        }
    }

    private class FontNameAction
    extends AbstractAction {
        private FontNameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ToolBarManager.this._syncing) {
                KDComboBox cb = (KDComboBox)e.getSource();
                String fn = cb.getEditor().getItem().toString();
                if (ToolBarManager.this.isSysFontName(fn)) {
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setFontName(fn);
                    ToolBarManager.this._context.getRangeManager().getSelectionRangeInBook().setStyle(sa, Styles.getEmptySA());
                }
                ToolBarManager.this._context.requestFocus();
            }
        }
    }

    private class RedoStepsAction
    extends AbstractAction {
        private int _index;

        private RedoStepsAction() {
        }

        public void setIndex(int index) {
            this._index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book book = ToolBarManager.this._context.getBook();
            book.getUndoManager().redoSteps(this._index + 1);
        }
    }

    private class UndoStepsAction
    extends AbstractAction {
        private int _index;

        private UndoStepsAction() {
        }

        public void setIndex(int index) {
            this._index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book book = ToolBarManager.this._context.getBook();
            book.getUndoManager().undoSteps(this._index + 1);
        }
    }

    private class EmptyAction
    extends AbstractAction {
        private EmptyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

