/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state.mouse;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.impl.render.DragRubberRender;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.DefaultMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.DefaultMouseState;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.IMouseState;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.IMouseStateController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.embed.HotSpot;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.print.PrintManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPrintJob;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class TableMouseController
extends DefaultMouseController {
    protected SpreadContext _context;
    private Rectangle _bufRect1 = new Rectangle();
    private Rectangle _bufRect2 = new Rectangle();
    private static final int SELECT = 1;
    private static final int MOVE = 2;
    private static final int FILL = 3;
    private static final int GRAPH = 4;
    private static final int StyleFetch = 5;
    private static final int StyleBrush = 6;
    private static final int InvalidGraph = 7;
    private static final int PaginationRowGridMove = 8;
    private static final int PaginationColGridMove = 9;
    private int _stateFlag = 1;
    private IMouseState ss = new SelectCellsState();
    private IMouseState ms = new MoveCellsState();
    private IMouseState fs = new FillCellsState();
    private IMouseState gs = new GraphState();
    private IMouseState prgs;
    private IMouseState pcgs;

    public TableMouseController(SpreadContext context) {
        this._context = context;
        this.prgs = new PaginationRowGridState(context);
        this.pcgs = new PaginationColGridState(context);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        if (sheet == null) {
            sheet = view.getSpread().getBook().getSheet(0);
        }
        if (sheet == null) {
            return;
        }
        EmbedhLayer gl = sheet.getEmbedments(false);
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (gl != null) {
            HotSpot hs;
            if (pro == null || pro.allowEditObjects()) {
                hs = gl.getTouchHotSpot(p);
                if (hs != null) {
                    this._stateFlag = 4;
                    int type = hs.getType();
                    if (type == 8 || type == 7) {
                        view.setCursor(Cursor.getPredefinedCursor(8));
                        return;
                    }
                    if (type == 5 || type == 6) {
                        view.setCursor(Cursor.getPredefinedCursor(11));
                        return;
                    }
                    if (type == 1 || type == 4) {
                        view.setCursor(Cursor.getPredefinedCursor(5));
                        return;
                    }
                    if (type == 2 || type == 3) {
                        view.setCursor(Cursor.getPredefinedCursor(4));
                        return;
                    }
                } else {
                    EmbedObject gr = gl.getTouchEmbed(p);
                    if (gr != null) {
                        this._stateFlag = 4;
                        view.setCursor(Cursor.getPredefinedCursor(13));
                        return;
                    }
                }
            } else {
                hs = gl.getTouchHotSpot(p);
                if (hs != null) {
                    this._stateFlag = 7;
                    return;
                }
                EmbedObject gr = gl.getTouchEmbed(p);
                if (gr != null) {
                    this._stateFlag = 7;
                    return;
                }
            }
        }
        int[] rowSnapshots = sheet.getRowPaginationPointsSnapshot();
        int[] colSnapshots = sheet.getColPaginationPointsSnapshot();
        if (rowSnapshots != null && colSnapshots != null) {
            CellBlock cb;
            int i;
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            int viewX = view.getVisibleRect().x;
            int viewY = view.getVisibleRect().y;
            for (i = 0; i < colSnapshots.length; ++i) {
                if (colSnapshots[i] == 0) continue;
                cb = CellBlock.getNewCellBlock(0, colSnapshots[i], maxRow, colSnapshots[i]);
                this._bufRect1 = SheetBaseMath.getBlockRect(sheet, cb, true, this._bufRect1);
                if (!SheetBaseMath.getSelectionRightRect(viewY, this._bufRect1, false, false, this._bufRect2).contains(p)) continue;
                view.setCursor(Cursor.getPredefinedCursor(10));
                this._stateFlag = 9;
                return;
            }
            for (i = 0; i < rowSnapshots.length; ++i) {
                if (rowSnapshots[i] == 0) continue;
                cb = CellBlock.getNewCellBlock(rowSnapshots[i], 0, rowSnapshots[i], maxCol);
                this._bufRect1 = SheetBaseMath.getBlockRect(sheet, cb, true, this._bufRect1);
                if (!SheetBaseMath.getSelectionBottomRect(viewX, this._bufRect1, false, false, this._bufRect2).contains(p)) continue;
                view.setCursor(Cursor.getPredefinedCursor(8));
                this._stateFlag = 8;
                return;
            }
        }
        this.showComment(e);
        Selection sel = sheet.getSheetOption().getSelection();
        this._stateFlag = 1;
        if (sel.isSingleBlock() && !this._context.getStateManager().isState2(SpreadStateManager.Key_Range_Select)) {
            SpreadAction action;
            int viewX = view.getVisibleRect().x;
            int viewY = view.getVisibleRect().y;
            boolean isRow = sel.isRowBlocks();
            boolean isCol = sel.isColBlocks();
            this._bufRect1 = SheetBaseMath.getBlockRect(sheet, sel.getActiveBlock(), true, this._bufRect1);
            if (SheetBaseMath.getSelectionTopRect(this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionLeftRect(this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionBottomRect(viewX, this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionRightRect(viewY, this._bufRect1, isRow, isCol, this._bufRect2).contains(p)) {
                action = this._context.getActionManager().getAction("Cut");
                if (action == null || action.isEnabled()) {
                    this._stateFlag = 2;
                }
            } else if (SheetBaseMath.getSelectionCornerRect(viewX, viewY, this._bufRect1, isRow, isCol, this._bufRect2).contains(p) && ((action = this._context.getActionManager().getAction("Fill")) == null || action.isEnabled())) {
                this._stateFlag = 3;
            }
        }
        if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
            this._stateFlag = 6;
        } else if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Fetch)) {
            this._stateFlag = 5;
        }
        switch (this._stateFlag) {
            case 2: {
                view.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 3: {
                view.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 6: {
                view.setCursor(ResourceManager.getCustomCursor8Based(view, "tbtn_stylebrush.gif"));
                break;
            }
            case 5: {
                view.setCursor(ResourceManager.getCustomCursor(view, "selectcomponent_enable.gif"));
                break;
            }
            default: {
                int r = SheetBaseMath.rowAtPoint(sheet, p);
                int c = SheetBaseMath.colAtPoint(sheet, p);
                Cell cell = sheet.getCell(r, c, false);
                if (cell != null && cell.getHyperLink() != null) {
                    view.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        IMouseState ms;
        SpreadStateManager sMgr = this._context.getStateManager();
        if (!sMgr.isState2(SpreadStateManager.Key_Range_Select) && !sMgr.stopEditing()) {
            return null;
        }
        IMouseStateController msc = this._context.getUserStateController();
        if (msc != null && (ms = msc.prePressing(e)) != null) {
            return ms;
        }
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        switch (this._stateFlag) {
            case 3: {
                return this.fs;
            }
            case 2: {
                return this.ms;
            }
            case 4: {
                return this.gs;
            }
            case 1: 
            case 5: 
            case 6: {
                return this.ss;
            }
            case 8: {
                return this.prgs;
            }
            case 9: {
                return this.pcgs;
            }
        }
        return null;
    }

    private void showComment(MouseEvent e) {
        Point p = e.getPoint();
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int row = SheetBaseMath.rowAtPoint(sheet, p);
        int col = SheetBaseMath.colAtPoint(sheet, p);
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mergeBlock = null;
        if (merger != null) {
            mergeBlock = merger.searchBlock(row, col);
        }
        Cell cell = null;
        cell = mergeBlock == null ? sheet.getCell(row, col, false) : sheet.getCell(mergeBlock.getRow(), mergeBlock.getCol(), false);
        if (cell == null || cell.getComment() == null) {
            this._context.getFacadeManager().showCommentComponent((SpreadView)e.getSource(), row, col, false);
        } else {
            this._context.getFacadeManager().showCommentComponent((SpreadView)e.getSource(), cell.getRow(), cell.getCol(), true);
        }
    }

    private boolean needShowPopup(MouseEvent e) {
        return e.getButton() == 3 && e.getClickCount() == 1;
    }

    private boolean needReSelect(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Point p = e.getPoint();
        int row = SheetBaseMath.rowAtPoint(sheet, p);
        int col = SheetBaseMath.colAtPoint(sheet, p);
        return !sheet.getSheetOption().getSelection().contains(row, col);
    }

    private void showPopupMenu(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        this._context.getPopMenuManager().getPopMenu().show(view, e.getX(), e.getY());
    }

    protected Area calcDragFillInteior(Sheet sheet, CellBlock block, int pos, boolean yDir) {
        this._bufRect1 = SheetBaseMath.getBlockRect(sheet, yDir ? pos : block.getRow(), yDir ? block.getCol() : pos, block.getRow2(), block.getCol2(), true, this._bufRect1);
        return new Area(this._bufRect1);
    }

    protected Area calcDragFillBorder(Sheet sheet, CellBlock block) {
        this._bufRect1 = SheetBaseMath.getBlockRect(sheet, block, true, this._bufRect1);
        this._bufRect2.setRect(this._bufRect1.getX() - 1.0, this._bufRect1.getY() - 1.0, this._bufRect1.getWidth() + 2.0, this._bufRect1.getHeight() + 2.0);
        SheetBaseMath.bufferRect(this._bufRect1, 2, 2, -4, -4);
        Area dragArea = new Area(this._bufRect2);
        dragArea.subtract(new Area(this._bufRect1));
        return dragArea;
    }

    class FillCellsState
    extends DefaultMouseState {
        CellBlock _srcBlock;
        Rectangle _srcRect;
        Rectangle _srcRectBuffer;
        Rectangle _spotRectBuffer;
        Point _focus1;
        Point _focus2;
        boolean _sameY;
        boolean _started;
        boolean _lastDir;
        int _lastRow;
        int _lastCol;
        CellBlock _dstBlock;
        boolean _keeped;
        SortedSpanArray _rowArray;
        SortedSpanArray _colArray;

        FillCellsState() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int temp;
            Sheet sheet = TableMouseController.this._context.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            this._srcBlock = sel.getActiveBlock();
            int leftBuffer = 0;
            if (this._srcBlock.getCol() > 0) {
                leftBuffer = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol() - 1) / 2;
            }
            int rightBuffer = 0;
            if (this._srcBlock.getCol2() < 16383) {
                rightBuffer = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol2() + 1) / 2;
            }
            int topBuffer = 0;
            if (this._srcBlock.getRow() > 0) {
                topBuffer = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow() - 1) / 2;
            }
            int bottomBuffer = 0;
            if (this._srcBlock.getRow2() < 1048575) {
                bottomBuffer = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow2() + 1) / 2;
            }
            this._srcRect = SheetBaseMath.getBlockRect(sheet, this._srcBlock, true);
            int innerDeltX = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol2()) / 2;
            int innerDeltY = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow2()) / 2;
            this._spotRectBuffer = new Rectangle(this._srcRect.x + this._srcRect.width - innerDeltX, this._srcRect.y + this._srcRect.height - innerDeltY, innerDeltX + rightBuffer + 1, innerDeltY + bottomBuffer + 1);
            this._srcRectBuffer = new Rectangle(this._srcRect.x - leftBuffer, this._srcRect.y - topBuffer, this._srcRect.width + leftBuffer + rightBuffer, this._srcRect.height + topBuffer + bottomBuffer);
            if (this._srcRect.getWidth() > this._srcRect.getHeight()) {
                this._sameY = true;
                temp = (this._srcRect.height - 1) / 2;
                this._focus1 = new Point(this._srcRect.x + temp, this._srcRect.y + temp);
                this._focus2 = new Point(this._srcRect.x + this._srcRect.width - 1 - temp, this._srcRect.y + temp);
            } else {
                this._sameY = false;
                temp = (this._srcRect.width - 1) / 2;
                this._focus1 = new Point(this._srcRect.x + temp, this._srcRect.y + temp);
                this._focus2 = new Point(this._srcRect.x + temp, this._srcRect.y + this._srcRect.height - 1 - temp);
            }
            this._keeped = true;
            this._started = false;
            this._dstBlock = CellBlock.getNewCellBlock(0, 0);
            if (this._srcBlock.isRow() || this._srcBlock.isCol()) {
                this._rowArray = null;
                this._colArray = null;
            } else {
                SortedCellBlockArray cMergeBlocks;
                MergeBlocks merger = sheet.getSheetOption().getMerger(false);
                if (merger != null && (cMergeBlocks = merger.getTouchedBlocks(this._srcBlock)) != null) {
                    this._rowArray = cMergeBlocks.toRowSpans(false);
                    this._rowArray.offset(-this._srcBlock.getRow());
                    this._colArray = cMergeBlocks.toColumnSpans(false);
                    this._colArray.offset(-this._srcBlock.getCol());
                    return;
                }
                this._rowArray = null;
                this._colArray = null;
            }
            this.getRubberRender().clear();
        }

        private int getActualRow(int row) {
            int index;
            int h;
            if (this._rowArray == null || this._rowArray.isEmpty()) {
                return row;
            }
            int startRow = this._srcBlock.getRow();
            int delt = row - startRow;
            int remain = delt % (h = this._srcBlock.getHeight());
            if (remain < 0) {
                remain = h + remain;
            }
            if ((index = this._rowArray.searchRowCol(remain)) >= 0) {
                int realRow = delt < 0 ? ((Span)this._rowArray.get(index)).getStart() : ((Span)this._rowArray.get(index)).getEnd();
                return row + realRow - remain;
            }
            return row;
        }

        private int getActualCol(int col) {
            int index;
            int w;
            if (this._colArray == null || this._colArray.isEmpty()) {
                return col;
            }
            int startCol = this._srcBlock.getCol();
            int delt = col - startCol;
            int remain = delt % (w = this._srcBlock.getWidth());
            if (remain < 0) {
                remain = w + remain;
            }
            if ((index = this._colArray.searchRowCol(remain)) >= 0) {
                int realCol = delt < 0 ? ((Span)this._colArray.get(index)).getStart() : ((Span)this._colArray.get(index)).getEnd();
                return col + realCol - remain;
            }
            return col;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            boolean needRepaint;
            boolean isColOver;
            boolean isRowOver;
            Point p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int row = Sheet.dealInvalidRow(Sheet.rowAtPoint(sheet, p));
            int col = Sheet.dealInvalidCol(Sheet.colAtPoint(sheet, p));
            view.scrollCellVisible(row, col);
            boolean isUp = this.isUp(p);
            boolean bl = isRowOver = p.getY() > (double)(Sheet.getRowY(sheet, row) + Sheet.getRowHeight(sheet, row) / 2);
            row = isRowOver && row == this._srcBlock.getRow() - 1 || !isRowOver && row == this._srcBlock.getRow() ? -1 : (isUp ? (isRowOver ? row + 1 : row) : (isRowOver ? row : row - 1));
            boolean isLeft = this.isLeft(p);
            boolean bl2 = isColOver = p.getX() > (double)(Sheet.getColX(sheet, col) + Sheet.getColWidth(sheet, col) / 2);
            if (isColOver && col == this._srcBlock.getCol() - 1 || !isColOver && col == this._srcBlock.getCol()) {
                col = -1;
            } else {
                int n = isLeft ? (isColOver ? col + 1 : col) : (col = isColOver ? col : col - 1);
            }
            if (row >= 0 && (row = this.getActualRow(row)) < 0) {
                return;
            }
            if (col >= 0 && (col = this.getActualCol(col)) < 0) {
                return;
            }
            boolean yDir = this.yDir(p);
            boolean bInSpotRectBuffer = this.inSpotRectBuffer(e);
            boolean bFirstStart = !this._started && !bInSpotRectBuffer;
            boolean bChanged = this._started && (yDir != this._lastDir || yDir && this._lastRow != row || !yDir && this._lastCol != col);
            boolean bl3 = needRepaint = bFirstStart || bChanged;
            if (needRepaint) {
                this._keeped = false;
                if (this._started && bInSpotRectBuffer) {
                    this._keeped = true;
                    this._dstBlock.setRowCol(this._srcBlock);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (yDir) {
                    if (row == -1) {
                        this._dstBlock.setRowCol(this._srcBlock);
                        int rowY = SheetBaseMath.getRowY(sheet, this._srcBlock.getRow());
                        Area area = new Area(new Rectangle2D.Double(this._srcRect.getX() - 1.0, rowY - 1, this._srcRect.getWidth() + 2.0, 3.0));
                        this.getRubberRender().paint(view, area);
                    } else if (row == this._srcBlock.getRow2()) {
                        this._keeped = true;
                        this._dstBlock.setRowCol(this._srcBlock);
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else if (row > this._srcBlock.getRow2()) {
                        this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), row, this._srcBlock.getCol2());
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else if (row < this._srcBlock.getRow()) {
                        this._dstBlock.setRowCol(row, this._srcBlock.getCol(), this._srcBlock.getRow2(), this._srcBlock.getCol2());
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else {
                        this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), row, this._srcBlock.getCol2());
                        Area area = TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock);
                        this.getRubberRender().paint(view, area);
                        this._dstBlock.setRowCol(row + 1, this._srcBlock.getCol(), this._srcBlock.getRow2(), this._srcBlock.getCol2());
                    }
                } else if (col == -1) {
                    this._dstBlock.setRowCol(this._srcBlock);
                    int colX = SheetBaseMath.getColX(sheet, this._srcBlock.getCol());
                    Area area = new Area(new Rectangle(colX - 1, this._srcRect.y - 1, 3, this._srcRect.height + 2));
                    this.getRubberRender().paint(view, area);
                } else if (col == this._srcBlock.getCol2()) {
                    this._keeped = true;
                    this._dstBlock.setRowCol(this._srcBlock);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (col > this._srcBlock.getCol2()) {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), this._srcBlock.getRow2(), col);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (col < this._srcBlock.getCol()) {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), col, this._srcBlock.getRow2(), this._srcBlock.getCol2());
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), this._srcBlock.getRow2(), col);
                    Area area = TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock);
                    this.getRubberRender().paint(view, area);
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), col + 1, this._srcBlock.getRow2(), this._srcBlock.getCol2());
                }
                this._lastRow = row;
                this._lastCol = col;
                this._lastDir = yDir;
                this._started = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            if (this._keeped) {
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
            } else if (this._dstBlock.contains(this._srcBlock) && !this._srcBlock.contains(this._dstBlock)) {
                if (TableMouseController.this.needShowPopup(e)) {
                    TableMouseController.this._context.getFacadeManager().getFillOptionPopup(view, TableMouseController.this._context.getRangeManager().getRange(this._srcBlock), this._dstBlock).show((Component)view, e.getX(), e.getY());
                } else {
                    TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
                    Range rg = TableMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                    FillType resultType = new FillType(0);
                    if (rg.fill(this._dstBlock, FillType.DEFAULT, resultType)) {
                        TableMouseController.this._context.getStateManager().addState(TableMouseController.this._context.getStateManager().createFilledState(this._dstBlock, rg, resultType));
                    }
                }
            } else {
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
                TableMouseController.this._context.getStateManager().cancel();
                TableMouseController.this._context.getRangeManager().getSelectionRange().fill(this._dstBlock, null, null);
            }
        }

        private DragRubberRender getRubberRender() {
            return TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
        }

        private boolean yDir(Point p) {
            if (this._srcBlock.isRow()) {
                return true;
            }
            if (this._srcBlock.isCol()) {
                return false;
            }
            int x = p.x;
            int y = p.y;
            int x1 = this._focus1.x;
            int y1 = this._focus1.y;
            int x2 = this._focus2.x;
            int y2 = this._focus2.y;
            if (this.inbufferRect(p)) {
                return this._srcRect.getMaxY() - (double)y > this._srcRect.getMaxX() - (double)x;
            }
            if (this._sameY) {
                return !(x > x2 && Math.abs(y - y2) < x - x2 || x < x1 && Math.abs(y - y1) < x1 - x);
            }
            return y > y2 && Math.abs(x - x2) < y - y2 || y < y1 && Math.abs(x - x1) < y1 - y;
        }

        private boolean isUp(Point p) {
            return this._srcRect.y > p.y;
        }

        private boolean isLeft(Point p) {
            return this._srcRect.x > p.x;
        }

        private boolean inSpotRectBuffer(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            if (this._srcBlock.isRow()) {
                int col = view.getFirstCol();
                int row = this._srcBlock.getRow2();
                int left = 0;
                if (col > 0) {
                    left = SheetBaseMath.getColWidth(sheet, col - 1) / 2;
                }
                int right = SheetBaseMath.getColWidth(sheet, col) / 2;
                int top = SheetBaseMath.getRowHeight(sheet, row) / 2;
                int bottom = 0;
                if (row < 1048575) {
                    bottom = SheetBaseMath.getRowHeight(sheet, row + 1) / 2;
                }
                this._spotRectBuffer = new Rectangle(this._srcRect.x - left, this._srcRect.y + this._srcRect.height - top, left + right + 1, top + bottom + 1);
            } else if (this._srcBlock.isCol()) {
                int row = view.getFirstRow();
                int col = this._srcBlock.getCol2();
                int left = SheetBaseMath.getColWidth(sheet, col) / 2;
                int right = 0;
                if (col < 16383) {
                    right = SheetBaseMath.getColWidth(sheet, col + 1) / 2;
                }
                int top = 0;
                if (row > 0) {
                    top = SheetBaseMath.getRowHeight(sheet, row - 1) / 2;
                }
                int bottom = SheetBaseMath.getRowHeight(sheet, row) / 2;
                this._spotRectBuffer = new Rectangle(this._srcRect.width + this._srcRect.x - left, this._srcRect.y - top, left + right + 1, top + bottom + 1);
            }
            return this._spotRectBuffer.contains(e.getPoint());
        }

        private boolean inbufferRect(Point2D p) {
            return this._srcRectBuffer.contains(p);
        }
    }

    class MoveCellsState
    extends DefaultMouseState {
        int _pressRow;
        int _pressCol;
        int _lastRow;
        int _lastCol;

        MoveCellsState() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            this._pressRow = SheetBaseMath.rowAtPoint(sheet, point);
            this._pressRow = SheetBaseMath.dealInvalidRow(this._pressRow);
            this._pressCol = SheetBaseMath.colAtPoint(sheet, point);
            this._pressCol = SheetBaseMath.dealInvalidRow(this._pressCol);
            if (this._pressRow < 0 || this._pressCol < 0) {
                return;
            }
            CellBlock block = sel.getActiveBlock();
            if (this._pressRow > block.getRow2()) {
                --this._pressRow;
            } else if (this._pressRow < block.getRow()) {
                ++this._pressRow;
            }
            if (this._pressCol > block.getCol2()) {
                --this._pressCol;
            } else if (this._pressCol < block.getCol()) {
                ++this._pressCol;
            }
            this._lastRow = this._pressRow;
            this._lastCol = this._pressCol;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            int row = SheetBaseMath.rowAtPoint(sheet, point);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, point);
            col = SheetBaseMath.dealInvalidCol(col);
            CellBlock block = sel.getActiveBlock();
            int dr = row - this._pressRow;
            int dc = col - this._pressCol;
            int newR = block.getRow() + dr;
            int newC = block.getCol() + dc;
            int newR2 = block.getRow2() + dr;
            int newC2 = block.getCol2() + dc;
            if (newR < 0) {
                newR = 0;
                newR2 = newR + block.getHeight() - 1;
                row = this._pressRow - block.getRow() + newR;
            } else if (newR2 > 1048575) {
                newR2 = 1048575;
                newR = newR2 - block.getHeight() + 1;
                row = this._pressRow - block.getRow2() + newR2;
            }
            if (newC < 0) {
                newC = 0;
                newC2 = newC + block.getWidth() - 1;
                col = this._pressCol - block.getCol() + newC;
            } else if (newC2 > 16383) {
                newC2 = 16383;
                newC = newC2 - block.getWidth() + 1;
                col = this._pressCol - block.getCol2() + newC2;
            }
            if (row != this._lastRow || col != this._lastCol) {
                view.scrollCellVisible(row, col);
                Area area = TableMouseController.this.calcDragFillBorder(sheet, CellBlock.getNewCellBlock(newR, newC, newR2, newC2));
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().paint(view, area);
                this._lastRow = row;
                this._lastCol = col;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
            KDSpread spread = view.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            CellBlock block = sel.getActiveBlock();
            if (this._lastRow != this._pressRow || this._lastCol != this._pressCol) {
                int dr = this._lastRow - this._pressRow;
                int dc = this._lastCol - this._pressCol;
                int newR = block.getRow() + dr;
                int newC = block.getCol() + dc;
                int newR2 = block.getRow2() + dr;
                int newC2 = block.getCol2() + dc;
                CellBlock cb = CellBlock.getNewCellBlock(newR, newC, newR2, newC2);
                if (TableMouseController.this._context.getBook().getActiveSheet().getCellsIterator(cb, false, false).next() != null && !TableMouseController.this._context.getFacadeManager().showConfirmMessageBox(MultiLanguageKeys.getLocalText("KEY_SPREAD_TITLE"), MultiLanguageKeys.getLocalText("Key_ReplaceCell"), 1, 0, 0)) {
                    return;
                }
                CellBlock sb = sel.getActiveBlock();
                if (!sb.equals(cb)) {
                    sheet.getBook().getUndoManager().startGroup();
                    boolean enable = KDClipboard.isEnableSpreadSheet();
                    KDClipboard.enableSpreadSheet(false);
                    boolean offset = KDClipboard.isOffset();
                    KDClipboard.setOffset(false);
                    Range srcRange = TableMouseController.this._context.getRangeManager().getRange(sb);
                    boolean bok = srcRange.cut();
                    String[] keepKeys = new String[]{};
                    Book.IUserObjectProvider provider = TableMouseController.this._context.getBook().getUserObjectsProvider();
                    if (provider != null) {
                        keepKeys = provider.getKeepKeys();
                    }
                    if (bok) {
                        bok |= srcRange.clear(true, true, true, true, keepKeys);
                        Protection pro = sheet.getSheetOption().getProtection(false);
                        if (pro != null && pro.isProtected()) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setLocked(false);
                            srcRange.setStyle(sa, Styles.getEmptySA());
                        }
                        bok |= TableMouseController.this._context.getRangeManager().getRange(cb).paste(PasteMode.ALL, keepKeys);
                    }
                    KDClipboard.enableSpreadSheet(enable);
                    KDClipboard.setOffset(offset);
                    if (bok) {
                        sheet.getBook().getUndoManager().endGroup();
                    } else {
                        sheet.getBook().getUndoManager().cancelGroup();
                    }
                    TableMouseController.this._context.getSelection().changeSelection(cb, 2);
                }
                TableMouseController.this._context.getStateManager().stop();
            }
        }
    }

    class SelectCellsState
    extends DefaultMouseState {
        private ActionListener _al = new ActionHander();
        int _pressRow;
        int _pressCol;
        int _lastRow;
        int _lastCol;
        private boolean _bLink;

        SelectCellsState() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadStateManager sm = TableMouseController.this._context.getStateManager();
            if (sm.isState(SpreadStateManager.Key_Style_Fetch)) {
                sm.stop();
                ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
            } else if (sm.isState(SpreadStateManager.Key_Style_Brush)) {
                Range r = TableMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                if (r.paste(PasteMode.FORMATS, null)) {
                    SpreadAction brushAction = TableMouseController.this._context.getActionManager().getAction("inner_StyleBrush", false);
                    boolean continious = false;
                    if (brushAction != null) {
                        System.out.println(brushAction.getValue("continious"));
                        Object obj = brushAction.getValue("continious");
                        boolean bl = continious = obj != null ? (Boolean)obj : false;
                    }
                    if (continious) {
                        return;
                    }
                    TableMouseController.this._context.getStateManager().stop();
                    ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
                }
                if (r.isMergeLimit()) {
                    TableMouseController.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_MergeLimit_Protect"), 0);
                }
            } else if (sm.isState(SpreadStateManager.Key_Range_Select)) {
                // empty if block
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                HyperLink link;
                if (e.getClickCount() >= 2) {
                    TableMouseController.this._context.getStateManager().addState(TableMouseController.this._context.getStateManager().createEditState(e));
                } else if (this._bLink && (link = TableMouseController.this._context.getRangeManager().getActiveCellRange().getHyerLink()) != null) {
                    TableMouseController.this._context.getHyperLinkHandler().execute(link);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            EmbedhLayer gl = sheet.getEmbedments(false);
            if (gl != null) {
                gl.cancelSelectedEmbeds();
            }
            this._bLink = true;
            TableMouseController.this._context.getThreadManager().getTimer(1000, this._al).start();
            boolean needShowPopup = TableMouseController.this.needShowPopup(e);
            boolean needReSelect = true;
            if (needShowPopup) {
                needReSelect = TableMouseController.this.needReSelect(e);
            }
            if (needReSelect) {
                Point point = e.getPoint();
                SelectionAdapter sel = TableMouseController.this._context.getSelection();
                int row = SheetBaseMath.rowAtPoint(sheet, point);
                int col = SheetBaseMath.colAtPoint(sheet, point);
                if (row < 0 || col < 0) {
                    return;
                }
                if (e.isShiftDown()) {
                    if (sel.changeSelection(CellBlock.getNewCellBlock(sel.getSelectionData().getActiveRow(), sel.getSelectionData().getActiveCol(), row, col), 3)) {
                        view.getSpread().setActiveView(view);
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                } else {
                    boolean b = sel.changeSelection(CellBlock.getNewCellBlock(row, col, row, col), e.isControlDown() ? 1 : 2);
                    if (b) {
                        view.getSpread().setActiveView(view);
                        this._pressRow = row;
                        this._pressCol = col;
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                }
            }
            if (needShowPopup) {
                TableMouseController.this.showPopupMenu(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            KDSpread spread;
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            SelectionAdapter sel = TableMouseController.this._context.getSelection();
            int row = SheetBaseMath.rowAtPoint(sheet, point);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, point);
            col = SheetBaseMath.dealInvalidCol(col);
            int activeCol = sheet.getActiveCol();
            int activeRow = sheet.getActiveRow();
            int freezedRow = sheet.getSheetOption().getViewSplitInfo().getRowFixLine();
            int freezedCol = sheet.getSheetOption().getViewSplitInfo().getColFixLine();
            if (view.getSpread().isFreezed(0) && activeCol < freezedCol) {
                spread = view.getSpread();
                JScrollBar hScrollBar = spread.getScrollBarManager().getHScrollBar(3);
                int x = hScrollBar.getValue() - hScrollBar.getMinimum();
                x = x < 0 ? 0 : x;
                point.x += x;
                col = SheetBaseMath.colAtPoint(sheet, point);
            }
            if (view.getSpread().isFreezed(1) && activeRow < freezedRow) {
                spread = view.getSpread();
                JScrollBar vScrollBar = spread.getScrollBarManager().getVScrollBar(3);
                int y = vScrollBar.getValue() - vScrollBar.getMinimum();
                y = y < 0 ? 0 : y;
                point.y += y;
                row = SheetBaseMath.rowAtPoint(sheet, point);
            }
            if (this._lastRow != row || this._lastCol != col) {
                CellBlock updateB = e.isShiftDown() ? CellBlock.getNewCellBlock(sheet.getActiveRow(), sheet.getActiveCol(), row, col) : CellBlock.getNewCellBlock(this._pressRow, this._pressCol, row, col);
                sel.changeSelection(updateB, 3);
                view.scrollCellVisible(row, col);
                this._lastRow = row;
                this._lastCol = col;
            }
        }

        private class ActionHander
        implements ActionListener {
            private ActionHander() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDSpread spread;
                if (TableMouseController.this._context != null && TableMouseController.this._context.getSpread() != null && TableMouseController.this._context.getSpread().getActiveView() != null && (spread = TableMouseController.this._context.getSpread()) != null && spread.getActiveView() != null) {
                    spread.getActiveView().setCursor(Cursor.getDefaultCursor());
                }
                TableMouseController.this._context.getThreadManager().getTimer(1000, SelectCellsState.this._al).stop();
                SelectCellsState.this._bLink = false;
            }
        }
    }

    class GraphState
    extends DefaultMouseState {
        HotSpot _curHotSpot;
        Point _pressP;
        Point _curP;
        EmbedObject _curGraph;
        private static final int STEP = 10;
        private int dx;
        private int dy;

        GraphState() {
        }

        private int xy2MultipleOfStep(int dx) {
            while (Math.abs(dx) % 10 != 0) {
                ++dx;
            }
            return dx;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._curHotSpot = null;
            this._curGraph = null;
            Point p = e.getPoint();
            Sheet sheet = ((SpreadView)e.getSource()).getSpread().getBook().getActiveSheet();
            int selMode = 2;
            if (e.isShiftDown()) {
                selMode = 3;
            } else if (e.isControlDown()) {
                selMode = 1;
            }
            EmbedhLayer gl = sheet.getEmbedments(false);
            Object o = gl.selectEmbed(p, selMode);
            if (o instanceof HotSpot) {
                this._curHotSpot = (HotSpot)o;
                this._curGraph = this._curHotSpot.getOwner();
            } else if (o instanceof EmbedObject) {
                this._curGraph = (EmbedObject)o;
            }
            this._pressP = p;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            this._curP = p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int row = SheetBaseMath.rowAtPoint(sheet, p);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, p);
            col = SheetBaseMath.dealInvalidCol(col);
            view.scrollCellVisible(row, col);
            this.dx = this._curP.x - this._pressP.x;
            this.dy = this._curP.y - this._pressP.y;
            EmbedhLayer gl = sheet.getEmbedments(false);
            Shape shape = gl.getOffsetShape(this._curHotSpot, this.dx, this.dy);
            Rectangle rect = shape.getBounds();
            EmbedObject embed = gl.getActiveSelectedEmbed();
            if (embed == null) {
                return;
            }
            if (!e.isAltDown()) {
                this.calMoveOrResize(rect, embed);
            }
            if (rect.getX() < 0.0) {
                this.dx = -embed.getX();
            }
            if (rect.getY() < 0.0) {
                this.dy = -embed.getY();
            }
            shape = gl.getOffsetShape(this._curHotSpot, this.dx, this.dy);
            DragRubberRender render = TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
            render.setBeFill(false);
            render.paint(view, shape);
        }

        private void calMoveOrResize(Rectangle rect, EmbedObject embed) {
            int oldX = embed.getX();
            int oldY = embed.getY();
            if (this._curHotSpot != null) {
                int type = this._curHotSpot.getType();
                if (type == 5 || type == 1 || type == 3) {
                    this.dx = this.xy2MultipleOfStep((int)rect.getX()) - oldX;
                }
                if (type == 7 || type == 1 || type == 2) {
                    this.dy = this.xy2MultipleOfStep((int)rect.getY()) - oldY;
                }
                if (type == 6 || type == 4 || type == 2) {
                    this.dx = this.xy2MultipleOfStep((int)(rect.getX() + rect.getWidth())) - (oldX + embed.getWidth());
                }
                if (type == 8 || type == 4 || type == 3) {
                    this.dy = this.xy2MultipleOfStep((int)(rect.getY() + rect.getHeight())) - (oldY + embed.getHeight());
                }
            } else {
                this.dx = this.xy2MultipleOfStep((int)rect.getX()) - oldX;
                this.dy = this.xy2MultipleOfStep((int)rect.getY()) - oldY;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JPopupMenu jm;
            Point p;
            this._curP = p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            EmbedhLayer gl = view.getSpread().getBook().getActiveSheet().getEmbedments(false);
            if ((e.getModifiers() & 0x10) != 0) {
                gl.getSelectionRange().offsetSelectedGraphs(this._curHotSpot, this.dx, this.dy);
                this.dx = 0;
                this.dy = 0;
                DragRubberRender render = TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
                render.endPaint(view);
                render.setBeFill(true);
            } else if (TableMouseController.this.needShowPopup(e) && gl.selectionSize() == 1 && this._curHotSpot == null && (jm = TableMouseController.this._context.getPopMenuManager().getEmbedPopMenu(this._curGraph)) != null) {
                jm.show(view, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    class PaginationColGridState
    extends DefaultMouseState {
        private int fromIndex;
        private int toIndex;
        private int maxColIndex;
        private int[] colSnapshots;
        private SortedObjectArray shrinkedCols;
        private SortedObjectArray extendedCols;
        private SheetPlugablePaginationAdvice ppa;
        private Sheet sheet;
        private SpreadContext context;

        PaginationColGridState(SpreadContext context) {
            this.context = context;
        }

        private boolean isPrintArea(Sheet _sheet) {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(_sheet.getID());
            job.initConfigModel2();
            return job.getTablePrintPagination().isPrinArea();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index;
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            Point p = e.getPoint();
            this.toIndex = index = SheetBaseMath.colAtPoint(this.sheet, p);
            this.sheet.setMovingColShadowPosition(index);
            this.context.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col;
            SpreadView view = (SpreadView)e.getSource();
            this.sheet = view.getSpread().getBook().getActiveSheet();
            if (this.sheet == null) {
                this.sheet = view.getSpread().getBook().getSheet(0);
            }
            if (this.sheet == null) {
                return;
            }
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            Point p = e.getPoint();
            p = new Point(p.x - 2, p.y);
            this.fromIndex = col = SheetBaseMath.colAtPoint(this.sheet, p);
            this.toIndex = col;
            this.colSnapshots = this.sheet.getColPaginationPointsSnapshot();
            this.maxColIndex = this.sheet.getMaxColIndex();
            this.ppa = (SheetPlugablePaginationAdvice)this.sheet.getPlugablePaginationAdvice(true);
            this.shrinkedCols = this.ppa.getColShrinkedBreakObjectArray();
            this.extendedCols = this.ppa.getColExtendedBreakObjectArray();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            if (this.fromIndex == this.toIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_EqualMoving"), 0);
                this.sheet.setMovingColShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.toIndex > this.maxColIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_BeyondMaxIndex"), 0);
                this.sheet.setMovingColShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.fromIndex > this.toIndex) {
                this.recomputeAdvicesForColLeftReleased();
            } else {
                this.recomputeAdvicesForColRightReleased();
            }
            this.ppa.setColShrinkedBreaks(this.shrinkedCols);
            this.ppa.setColExtendedBreaks(this.extendedCols);
            this.sheet.setMovingColShadowPosition(-1);
            this.repaginationAndRepaint();
            PrintSetup ps = this.sheet.getSheetOption().getPrintSetup(false);
            ps.setScale(SheetBaseMath.getProperScaleRate(TableMouseController.this._context));
            this.repaginationAndRepaint();
        }

        private void recomputeAdvicesForColLeftReleased() {
            boolean lastPassedColStatusIsExtended = false;
            int lastPassedColIndex = this.fromIndex;
            boolean toIndexAdded = false;
            for (int i = 0; i < this.colSnapshots.length; ++i) {
                if (this.colSnapshots[i] < this.toIndex || this.colSnapshots[i] >= this.fromIndex || this.colSnapshots[i] >= lastPassedColIndex) continue;
                lastPassedColIndex = this.colSnapshots[i];
            }
            SortedObjectArray newExtendedCols = new SortedObjectArray();
            if (this.extendedCols != null) {
                for (int i = 0; i < this.extendedCols.size(); ++i) {
                    int eCol = (Integer)this.extendedCols.get(i);
                    if (eCol < this.toIndex) {
                        newExtendedCols.insert((Object)ObjectCache.getInteger((int)eCol));
                    } else if (eCol > this.fromIndex) {
                        newExtendedCols.insert((Object)ObjectCache.getInteger((int)(eCol - (this.fromIndex - this.toIndex))));
                    } else if (eCol == this.toIndex) {
                        newExtendedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                        toIndexAdded = true;
                    }
                    if (lastPassedColIndex != eCol) continue;
                    lastPassedColStatusIsExtended = true;
                }
            }
            SortedObjectArray newShrinkedCols = new SortedObjectArray();
            if (this.shrinkedCols != null) {
                for (int i = 0; i < this.shrinkedCols.size(); ++i) {
                    int sCol = (Integer)this.shrinkedCols.get(i);
                    if (sCol < this.toIndex) {
                        newShrinkedCols.insert((Object)ObjectCache.getInteger((int)sCol));
                        continue;
                    }
                    if (sCol > this.fromIndex) {
                        newShrinkedCols.insert((Object)ObjectCache.getInteger((int)(sCol - (this.fromIndex - this.toIndex))));
                        continue;
                    }
                    if (sCol != this.toIndex) continue;
                    newShrinkedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                    toIndexAdded = true;
                }
            }
            if (lastPassedColStatusIsExtended && lastPassedColIndex != this.toIndex) {
                int fromColIndex = 0;
                for (int i = 0; i < this.colSnapshots.length; ++i) {
                    if (this.colSnapshots[i] >= lastPassedColIndex || this.colSnapshots[i] <= fromColIndex) continue;
                    fromColIndex = this.colSnapshots[i];
                }
                int normalPageBreakAt = this.getColPageBreakIndexInNormalPagination(fromColIndex, 1);
                if (normalPageBreakAt < this.toIndex) {
                    newExtendedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                } else {
                    newShrinkedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                }
            } else if (!toIndexAdded) {
                newShrinkedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            }
            this.shrinkedCols = newShrinkedCols;
            this.extendedCols = newExtendedCols;
        }

        private void recomputeAdvicesForColRightReleased() {
            int leftBreak = 0;
            for (int i = 0; i < this.colSnapshots.length; ++i) {
                if (this.colSnapshots[i] >= this.fromIndex || this.colSnapshots[i] <= leftBreak) continue;
                leftBreak = this.colSnapshots[i];
            }
            int page1Break = this.getColPageBreakIndexInNormalPagination(leftBreak, 1);
            int page2Break = this.getColPageBreakIndexInNormalPagination(leftBreak, 2);
            if (this.toIndex > page2Break) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_ExtendedBreak_OverMoving"), 0);
                return;
            }
            SortedObjectArray newExtendedCols = new SortedObjectArray();
            if (this.extendedCols != null) {
                for (int i = 0; i < this.extendedCols.size(); ++i) {
                    int eCol = (Integer)this.extendedCols.get(i);
                    if (eCol < this.fromIndex) {
                        newExtendedCols.insert((Object)ObjectCache.getInteger((int)eCol));
                        continue;
                    }
                    if (eCol <= this.fromIndex) continue;
                    newExtendedCols.insert((Object)ObjectCache.getInteger((int)(eCol + (this.toIndex - this.fromIndex))));
                }
            }
            SortedObjectArray newShrinkedCols = new SortedObjectArray();
            if (this.shrinkedCols != null) {
                for (int i = 0; i < this.shrinkedCols.size(); ++i) {
                    int sCol = (Integer)this.shrinkedCols.get(i);
                    if (sCol < this.fromIndex) {
                        newShrinkedCols.insert((Object)ObjectCache.getInteger((int)sCol));
                        continue;
                    }
                    if (sCol <= this.fromIndex) continue;
                    newShrinkedCols.insert((Object)ObjectCache.getInteger((int)(sCol + (this.toIndex - this.fromIndex))));
                }
            }
            if (this.toIndex <= page1Break) {
                newShrinkedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            } else {
                newExtendedCols.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            }
            this.shrinkedCols = newShrinkedCols;
            this.extendedCols = newExtendedCols;
        }

        private int getColPageBreakIndexInNormalPagination(int fromIndex, int pageNo) {
            if (pageNo <= 0) {
                throw new IllegalArgumentException("\u53ea\u80fd\u8bfb\u53d6\u540e\u7eed\u5206\u9875\u95f4\u9694, Argument can not be zero or below zero.");
            }
            Sheet sheet = this.context.getBook().getActiveSheet();
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            SheetPlugablePaginationAdvice sppa = new SheetPlugablePaginationAdvice();
            if (fromIndex != 0) {
                SortedObjectArray soa = new SortedObjectArray();
                soa.insert((Object)ObjectCache.getInteger((int)fromIndex));
                sppa.setColShrinkedBreaks(soa);
            }
            sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)sppa);
            job.preparePagination();
            int[] colPaginationPointsSnapshot = job.getTablePrintPagination().getColPaginationPointsSnapshot();
            int dest = Integer.MAX_VALUE;
            while (pageNo > 0) {
                dest = Integer.MAX_VALUE;
                for (int i = 0; i < colPaginationPointsSnapshot.length; ++i) {
                    if (colPaginationPointsSnapshot[i] <= fromIndex || colPaginationPointsSnapshot[i] >= dest) continue;
                    dest = colPaginationPointsSnapshot[i];
                }
                fromIndex = dest;
                --pageNo;
            }
            pm.getMultiPrintManager().clear();
            return dest;
        }

        private void repaginationAndRepaint() {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(this.sheet.getID());
            this.sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)this.ppa);
            job.preparePagination();
            if (!job.getTablePrintPagination().isPrinArea()) {
                this.sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                this.sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            }
            pm.getMultiPrintManager().clear();
            this.context.repaint();
        }
    }

    class PaginationRowGridState
    extends DefaultMouseState {
        private int fromIndex;
        private int toIndex;
        private int maxRowIndex;
        private int[] rowSnapshots;
        private SortedObjectArray shrinkedRows;
        private SortedObjectArray extendedRows;
        private SheetPlugablePaginationAdvice ppa;
        private Sheet sheet;
        private SpreadContext context;

        PaginationRowGridState(SpreadContext context) {
            this.context = context;
        }

        private boolean isPrintArea(Sheet _sheet) {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(_sheet.getID());
            job.initConfigModel2();
            return job.getTablePrintPagination().isPrinArea();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index;
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            Point p = e.getPoint();
            this.toIndex = index = SheetBaseMath.rowAtPoint(this.sheet, p);
            this.sheet.setMovingRowShadowPosition(index);
            this.context.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            SpreadView view = (SpreadView)e.getSource();
            this.sheet = view.getSpread().getBook().getActiveSheet();
            if (this.sheet == null) {
                this.sheet = view.getSpread().getBook().getSheet(0);
            }
            if (this.sheet == null) {
                return;
            }
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            Point p = e.getPoint();
            p = new Point(p.x, p.y - 2);
            this.fromIndex = row = SheetBaseMath.rowAtPoint(this.sheet, p);
            this.toIndex = row;
            this.rowSnapshots = this.sheet.getRowPaginationPointsSnapshot();
            this.maxRowIndex = this.sheet.getMaxRowIndex();
            this.ppa = (SheetPlugablePaginationAdvice)this.sheet.getPlugablePaginationAdvice(true);
            this.shrinkedRows = this.ppa.getRowShrinkedBreakObjectArray();
            this.extendedRows = this.ppa.getRowExtendedBreakObjectArray();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isPrintArea(this.sheet)) {
                return;
            }
            if (this.fromIndex == this.toIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_EqualMoving"), 0);
                this.sheet.setMovingRowShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.toIndex > this.maxRowIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_BeyondMaxIndex"), 0);
                this.sheet.setMovingRowShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.fromIndex > this.toIndex) {
                this.recomputeAdvicesForRowUpReleased();
            } else {
                this.recomputeAdvicesForRowDownReleased();
            }
            this.ppa.setRowShrinkedBreaks(this.shrinkedRows);
            this.ppa.setRowExtendedBreaks(this.extendedRows);
            this.sheet.setMovingRowShadowPosition(-1);
            this.repaginationAndRepaint();
            PrintSetup ps = this.sheet.getSheetOption().getPrintSetup(false);
            ps.setScale(SheetBaseMath.getProperScaleRate(TableMouseController.this._context));
            this.repaginationAndRepaint();
        }

        private void recomputeAdvicesForRowUpReleased() {
            boolean lastPassedRowStatusIsExtended = false;
            int lastPassedRowIndex = this.fromIndex;
            boolean toIndexAdded = false;
            for (int i = 0; i < this.rowSnapshots.length; ++i) {
                if (this.rowSnapshots[i] < this.toIndex || this.rowSnapshots[i] >= this.fromIndex || this.rowSnapshots[i] >= lastPassedRowIndex) continue;
                lastPassedRowIndex = this.rowSnapshots[i];
            }
            SortedObjectArray newExtendedRows = new SortedObjectArray();
            if (this.extendedRows != null) {
                for (int i = 0; i < this.extendedRows.size(); ++i) {
                    int eRow = (Integer)this.extendedRows.get(i);
                    if (eRow < this.toIndex) {
                        newExtendedRows.insert((Object)ObjectCache.getInteger((int)eRow));
                    } else if (eRow > this.fromIndex) {
                        newExtendedRows.insert((Object)ObjectCache.getInteger((int)(eRow - (this.fromIndex - this.toIndex))));
                    } else if (eRow == this.toIndex) {
                        newExtendedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                        toIndexAdded = true;
                    }
                    if (lastPassedRowIndex != eRow) continue;
                    lastPassedRowStatusIsExtended = true;
                }
            }
            SortedObjectArray newShrinkedRows = new SortedObjectArray();
            if (this.shrinkedRows != null) {
                for (int i = 0; i < this.shrinkedRows.size(); ++i) {
                    int sRow = (Integer)this.shrinkedRows.get(i);
                    if (sRow < this.toIndex) {
                        newShrinkedRows.insert((Object)ObjectCache.getInteger((int)sRow));
                        continue;
                    }
                    if (sRow > this.fromIndex) {
                        newShrinkedRows.insert((Object)ObjectCache.getInteger((int)(sRow - (this.fromIndex - this.toIndex))));
                        continue;
                    }
                    if (sRow != this.toIndex) continue;
                    newShrinkedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                    toIndexAdded = true;
                }
            }
            if (lastPassedRowStatusIsExtended && lastPassedRowIndex != this.toIndex) {
                int fromRowIndex = 0;
                for (int i = 0; i < this.rowSnapshots.length; ++i) {
                    if (this.rowSnapshots[i] >= lastPassedRowIndex || this.rowSnapshots[i] <= fromRowIndex) continue;
                    fromRowIndex = this.rowSnapshots[i];
                }
                int normalPageBreakAt = this.getRowPageBreakIndexInNormalPagination(fromRowIndex, 1);
                if (normalPageBreakAt < this.toIndex) {
                    newExtendedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                } else {
                    newShrinkedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
                }
            } else if (!toIndexAdded) {
                newShrinkedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            }
            this.shrinkedRows = newShrinkedRows;
            this.extendedRows = newExtendedRows;
        }

        private void recomputeAdvicesForRowDownReleased() {
            int leftBreak = 0;
            for (int i = 0; i < this.rowSnapshots.length; ++i) {
                if (this.rowSnapshots[i] >= this.fromIndex || this.rowSnapshots[i] <= leftBreak) continue;
                leftBreak = this.rowSnapshots[i];
            }
            int page1Break = this.getRowPageBreakIndexInNormalPagination(leftBreak, 1);
            int page2Break = this.getRowPageBreakIndexInNormalPagination(leftBreak, 2);
            if (this.toIndex > page2Break) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_ExtendedBreak_OverMoving"), 0);
                return;
            }
            SortedObjectArray newExtendedRows = new SortedObjectArray();
            if (this.extendedRows != null) {
                for (int i = 0; i < this.extendedRows.size(); ++i) {
                    int eRow = (Integer)this.extendedRows.get(i);
                    if (eRow < this.fromIndex) {
                        newExtendedRows.insert((Object)ObjectCache.getInteger((int)eRow));
                        continue;
                    }
                    if (eRow <= this.fromIndex) continue;
                    newExtendedRows.insert((Object)ObjectCache.getInteger((int)(eRow + (this.toIndex - this.fromIndex))));
                }
            }
            SortedObjectArray newShrinkedRows = new SortedObjectArray();
            if (this.shrinkedRows != null) {
                for (int i = 0; i < this.shrinkedRows.size(); ++i) {
                    int eRow = (Integer)this.shrinkedRows.get(i);
                    if (eRow < this.fromIndex) {
                        newShrinkedRows.insert((Object)ObjectCache.getInteger((int)eRow));
                        continue;
                    }
                    if (eRow <= this.fromIndex) continue;
                    newShrinkedRows.insert((Object)ObjectCache.getInteger((int)(eRow + (this.toIndex - this.fromIndex))));
                }
            }
            if (this.toIndex <= page1Break) {
                newShrinkedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            } else {
                newExtendedRows.insert((Object)ObjectCache.getInteger((int)this.toIndex));
            }
            this.shrinkedRows = newShrinkedRows;
            this.extendedRows = newExtendedRows;
        }

        private int getRowPageBreakIndexInNormalPagination(int fromIndex, int pageNo) {
            if (pageNo <= 0) {
                throw new IllegalArgumentException("Argument can not be zero or below zero.");
            }
            Sheet sheet = this.context.getBook().getActiveSheet();
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            SheetPlugablePaginationAdvice sppa = new SheetPlugablePaginationAdvice();
            if (fromIndex != 0) {
                SortedObjectArray soa = new SortedObjectArray();
                soa.insert((Object)ObjectCache.getInteger((int)fromIndex));
                sppa.setRowShrinkedBreaks(soa);
            }
            sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)sppa);
            job.preparePagination();
            int[] rowPaginationPointsSnapshot = job.getTablePrintPagination().getRowPaginationPointsSnapshot();
            int dest = Integer.MAX_VALUE;
            while (pageNo > 0) {
                dest = Integer.MAX_VALUE;
                for (int i = 0; i < rowPaginationPointsSnapshot.length; ++i) {
                    if (rowPaginationPointsSnapshot[i] <= fromIndex || rowPaginationPointsSnapshot[i] >= dest) continue;
                    dest = rowPaginationPointsSnapshot[i];
                }
                fromIndex = dest;
                --pageNo;
            }
            pm.getMultiPrintManager().clear();
            return dest;
        }

        private void repaginationAndRepaint() {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(this.sheet.getID());
            this.sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)this.ppa);
            job.preparePagination();
            this.sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
            this.sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            pm.getMultiPrintManager().clear();
            this.context.repaint();
        }
    }
}

